/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform.filter;

import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedList;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.transform.filter.AbstractFilter;
import com.linkedin.data.transform.filter.FilterConstants;
import java.util.Map;

public class CopyFilter
extends AbstractFilter {
    private static final DataList EMPTY_DATALIST = new DataList();

    @Override
    protected Object onFilterDataList(DataList data, int start, int count, Object operation) {
        if (operation == FilterConstants.NEGATIVE) {
            return EMPTY_DATALIST;
        }
        int end = Math.min(data.size(), start + count);
        int size = Math.max(end - start, 0);
        DataList resultList = new DataList(size);
        for (int i = start; i < end; ++i) {
            Object value;
            Class<?> operationClass = operation.getClass();
            Object original = data.get(i);
            if (operationClass == Integer.class) {
                value = original;
            } else {
                assert (operationClass == DataMap.class);
                assert (original instanceof DataComplex);
                value = this.filter(original, (DataMap)operation);
            }
            CheckedUtil.addWithoutChecking((CheckedList)resultList, (Object)value);
        }
        return resultList;
    }

    @Override
    protected Object onFilterDataMap(DataMap data, Map<String, Object> fieldToOperation) {
        DataMap resultMap = new DataMap((int)((float)fieldToOperation.size() / 0.75f) + 1);
        for (Map.Entry<String, Object> entry : fieldToOperation.entrySet()) {
            Object value;
            Object operation = entry.getValue();
            if (operation == FilterConstants.POSITIVE) {
                value = data.get((Object)entry.getKey());
            } else {
                assert (operation.getClass() == DataMap.class);
                Object original = data.get((Object)entry.getKey());
                assert (original instanceof DataComplex);
                value = this.filter(original, (DataMap)operation);
            }
            CheckedUtil.putWithoutChecking((CheckedMap)resultMap, (Object)entry.getKey(), (Object)value);
        }
        return resultMap;
    }

    @Override
    protected Object onError(Object field, String format, Object ... args) {
        throw new RuntimeException(String.format(format, args));
    }

    @Override
    protected boolean isValidDataMapFieldOperation(Map<String, Object> result, String name, Object operation) {
        return operation != FilterConstants.NEGATIVE;
    }

    static {
        EMPTY_DATALIST.makeReadOnly();
    }
}

