/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.google;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.source.extractor.extract.google.GoogleCommon;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.io.SeekableFSInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleDriveFileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleDriveFileSystem.class);
    static final String PAGE_SIZE = "source.google.fs_helper.page_size";
    static final String FOLDER_MIME_TYPE = "application/vnd.google-apps.folder";
    static final int DEFAULT_PAGE_SIZE = 50;
    private Drive client;
    private final Closer closer = Closer.create();
    private int pageSize = 50;

    public GoogleDriveFileSystem(Drive client) {
        this();
        this.client = client;
    }

    public GoogleDriveFileSystem(Drive client, int pageSize) {
        this(client);
        Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (Object)"pageSize should be positive number");
        this.pageSize = pageSize;
    }

    public GoogleDriveFileSystem() {
    }

    public synchronized void initialize(URI uri, Configuration conf) throws IOException {
        if (this.client == null) {
            super.initialize(uri, conf);
            State state = HadoopUtils.getStateFromConf((Configuration)conf);
            Credential credential = new GoogleCommon.CredentialBuilder(state.getProp("source.conn.private.key"), state.getPropAsList("source.google.api_scopes")).fileSystemUri(state.getProp("source.google.privatekey_fs_uri")).proxyUrl(state.getProp("source.conn.use.proxy.url")).port(state.getProp("source.conn.use.proxy.port")).serviceAccountId(state.getProp("source.conn.username")).build();
            this.client = new Drive.Builder(credential.getTransport(), GoogleCommon.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName((String)Preconditions.checkNotNull((Object)state.getProp("source.google.application_name"), (Object)"ApplicationName is required")).build();
            this.pageSize = state.getPropAsInt(PAGE_SIZE, 50);
        }
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        return (FSDataInputStream)this.closer.register((Closeable)new FSDataInputStream((InputStream)new SeekableFSInputStream((InputStream)new BufferedInputStream(this.client.files().get(GoogleDriveFileSystem.toFileId(path)).executeMediaAsInputStream(), bufferSize))));
    }

    public FSDataInputStream open(Path path) throws IOException {
        return (FSDataInputStream)this.closer.register((Closeable)new FSDataInputStream((InputStream)new SeekableFSInputStream((InputStream)new BufferedInputStream(this.client.files().get(GoogleDriveFileSystem.toFileId(path)).executeMediaAsInputStream()))));
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        Preconditions.checkArgument((boolean)recursive, (Object)"Non-recursive is not supported.");
        String fileId = GoogleDriveFileSystem.toFileId(path);
        LOG.debug("Deleting file: " + fileId);
        try {
            this.client.files().delete(fileId).execute();
        }
        catch (GoogleJsonResponseException e) {
            GoogleJsonError error = e.getDetails();
            if (404 == error.getCode()) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public FileStatus[] listStatus(Path path) throws FileNotFoundException, IOException {
        String folderId = GoogleDriveFileSystem.toFileId(path);
        List<File> fileMetadata = this.lsFileMetadata(folderId, null);
        if (fileMetadata.isEmpty()) {
            throw new FileNotFoundException();
        }
        FileStatus[] statusArr = new FileStatus[fileMetadata.size()];
        int idx = 0;
        for (File metadata : fileMetadata) {
            FileStatus status = this.toFileStatus(metadata);
            statusArr[idx++] = status;
        }
        return statusArr;
    }

    private List<File> lsFileMetadata(String folderId, String fileId) throws IOException {
        String pageToken = null;
        ArrayList<File> result = new ArrayList<File>();
        Optional<String> query = this.buildQuery(folderId, fileId);
        do {
            Drive.Files.List request = this.client.files().list().setFields("files/id,files/mimeType,files/modifiedTime,files/size,files/permissions").setPageSize(Integer.valueOf(this.pageSize));
            if (query.isPresent()) {
                request = request.setQ((String)query.get());
            }
            if (pageToken != null) {
                request = request.setPageToken(pageToken);
            }
            LOG.info("Google drive List request: " + request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Google drive List request: " + request);
            }
            FileList fileList = null;
            try {
                fileList = (FileList)request.execute();
            }
            catch (GoogleJsonResponseException e) {
                GoogleJsonError error = e.getDetails();
                if (404 == error.getCode()) {
                    throw new FileNotFoundException("File not found. Request: " + request);
                }
                throw e;
            }
            pageToken = fileList.getNextPageToken();
            List files = fileList.getFiles();
            if (files == null || files.isEmpty()) {
                return result;
            }
            result.addAll(files);
        } while (pageToken != null);
        return result;
    }

    @VisibleForTesting
    Optional<String> buildQuery(String folderId, String fileName) {
        if (StringUtils.isEmpty((CharSequence)folderId) && StringUtils.isEmpty((CharSequence)fileName)) {
            return Optional.absent();
        }
        StringBuilder query = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)folderId)) {
            query.append("'").append(folderId).append("'").append(" in parents");
        }
        if (StringUtils.isNotEmpty((CharSequence)fileName)) {
            if (query.length() > 0) {
                query.append(" and ");
            }
            query.append("name contains ").append("'").append(fileName).append("'");
        }
        return Optional.of((Object)query.toString());
    }

    public static String toFileId(Path p) {
        if (p.isRoot()) {
            return "";
        }
        String format = "%s/%s";
        if (p.getParent() != null && StringUtils.isEmpty((CharSequence)p.getParent().getName())) {
            return p.getName();
        }
        return String.format("%s/%s", GoogleDriveFileSystem.toFileId(p.getParent()), p.getName());
    }

    public void close() throws IOException {
        super.close();
        this.closer.close();
    }

    public FileStatus getFileStatus(Path p) throws IOException {
        Preconditions.checkNotNull((Object)p);
        String fileId = GoogleDriveFileSystem.toFileId(p);
        File metadata = (File)this.client.files().get(fileId).setFields("id,mimeType,modifiedTime,size,permissions").execute();
        return this.toFileStatus(metadata);
    }

    private FileStatus toFileStatus(File metadata) {
        return new FileStatus(metadata.getSize() == null ? 0L : metadata.getSize(), FOLDER_MIME_TYPE.equals(metadata.getMimeType()), -1, -1L, metadata.getModifiedTime().getValue(), new Path(metadata.getId()));
    }

    public void setWorkingDirectory(Path new_dir) {
        throw new UnsupportedOperationException();
    }

    public Path getWorkingDirectory() {
        throw new UnsupportedOperationException();
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw new UnsupportedOperationException();
    }

    public URI getUri() {
        throw new UnsupportedOperationException();
    }
}

