/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ingestion.google.webmaster;

import java.util.TreeMap;

public class UrlTrieNode {
    public TreeMap<Character, UrlTrieNode> children = new TreeMap();
    private Character _value;
    private boolean _exist = false;
    private int _size = 0;

    public UrlTrieNode(Character value) {
        this._value = value;
    }

    public void add(String path) {
        UrlTrieNode parent = this;
        parent.increaseCount();
        for (int i = 0; i < path.length(); ++i) {
            Character c = Character.valueOf(path.charAt(i));
            UrlTrieNode child = parent.children.get(c);
            if (child == null) {
                child = new UrlTrieNode(c);
                parent.children.put(c, child);
            }
            child.increaseCount();
            parent = child;
        }
        parent._exist = true;
    }

    public UrlTrieNode getChild(String path) {
        UrlTrieNode parent = this;
        for (int i = 0; i < path.length(); ++i) {
            Character c = Character.valueOf(path.charAt(i));
            UrlTrieNode child = parent.children.get(c);
            if (child == null) {
                return null;
            }
            parent = child;
        }
        return parent;
    }

    public Character getValue() {
        return this._value;
    }

    public boolean isExist() {
        return this._exist;
    }

    public int getSize() {
        return this._size;
    }

    public void increaseCount() {
        ++this._size;
    }

    public String toString() {
        return "UrlTrieNode{_value=" + this._value + ", _exist=" + this._exist + ", _size=" + this._size + '}';
    }
}

