/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ingestion.google.webmaster;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterFilter;
import org.apache.gobblin.ingestion.google.webmaster.ProducerJob;

public class SimpleProducerJob
extends ProducerJob {
    private final String _page;
    private final String _startDate;
    private final String _endDate;
    private static final GoogleWebmasterFilter.FilterOperator _operator = GoogleWebmasterFilter.FilterOperator.EQUALS;

    SimpleProducerJob(String page, String startDate, String endDate) {
        this._page = page;
        this._startDate = startDate;
        this._endDate = endDate;
    }

    public SimpleProducerJob(ProducerJob job) {
        this(job.getPage(), job.getStartDate(), job.getEndDate());
    }

    public static List<ProducerJob> deserialize(String jobs) {
        if (jobs == null || jobs.trim().isEmpty()) {
            jobs = "[]";
        }
        JsonArray jobsJson = new JsonParser().parse(jobs).getAsJsonArray();
        return (List)new Gson().fromJson((JsonElement)jobsJson, new TypeToken<ArrayList<SimpleProducerJob>>(){}.getType());
    }

    @Override
    public String getPage() {
        return this._page;
    }

    @Override
    public String getStartDate() {
        return this._startDate;
    }

    @Override
    public String getEndDate() {
        return this._endDate;
    }

    @Override
    public GoogleWebmasterFilter.FilterOperator getOperator() {
        return _operator;
    }

    @Override
    public int getPagesSize() {
        return 1;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._page, this._startDate, this._endDate, _operator});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!SimpleProducerJob.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        SimpleProducerJob other = (SimpleProducerJob)obj;
        if (!Objects.equals(this._page, other._page)) return false;
        if (!Objects.equals(this._startDate, other._startDate)) return false;
        if (!Objects.equals(this._endDate, other._endDate)) return false;
        if (!Objects.equals((Object)_operator, (Object)_operator)) return false;
        return true;
    }

    public String toString() {
        return String.format("SimpleProducerJob{_page='%s', _startDate='%s', _endDate='%s', _operator=%s}", new Object[]{this._page, this._startDate, this._endDate, _operator});
    }
}

