/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ingestion.google.webmaster;

import com.google.api.client.auth.oauth2.Credential;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebMasterSource;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterClientImpl;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterDataFetcher;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterExtractor;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterFilter;
import org.apache.gobblin.source.extractor.extract.google.GoogleCommon;
import org.apache.gobblin.source.extractor.partition.Partition;
import org.apache.gobblin.source.extractor.watermark.DateWatermark;
import org.apache.gobblin.source.extractor.watermark.TimestampWatermark;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleWebMasterSourceDaily
extends GoogleWebMasterSource {
    private static final Logger log = LoggerFactory.getLogger(GoogleWebMasterSourceDaily.class);

    @Override
    GoogleWebmasterExtractor createExtractor(WorkUnitState state, Map<String, Integer> columnPositionMap, List<GoogleWebmasterFilter.Dimension> requestedDimensions, List<GoogleWebmasterDataFetcher.Metric> requestedMetrics, JsonArray schemaJson) throws IOException {
        Preconditions.checkArgument((state.getProp("source.querybased.watermark.type").compareToIgnoreCase("Hour") == 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((state.getPropAsInt("source.querybased.partition.interval") == 24 ? 1 : 0) != 0);
        Partition partition = Partition.deserialize((WorkUnit)state.getWorkunit());
        long lowWatermark = partition.getLowWatermark();
        long expectedHighWatermark = partition.getHighWatermark();
        int dateDiff = partition.isHighWatermarkInclusive() ? 1 : 0;
        long highWatermarkDate = DateWatermark.adjustWatermark((String)Long.toString(expectedHighWatermark), (int)dateDiff);
        long updatedExpectedHighWatermark = TimestampWatermark.adjustWatermark((String)Long.toString(highWatermarkDate), (int)-1);
        updatedExpectedHighWatermark = Math.max(lowWatermark, updatedExpectedHighWatermark);
        GoogleWebmasterClientImpl gscClient = new GoogleWebmasterClientImpl(GoogleWebMasterSourceDaily.getCredential((State)state), state.getProp("source.entity"));
        return new GoogleWebmasterExtractor(gscClient, state, lowWatermark, updatedExpectedHighWatermark, columnPositionMap, requestedDimensions, requestedMetrics, schemaJson);
    }

    private static Credential getCredential(State wuState) {
        String scope = wuState.getProp("source.google.api_scopes", "https://www.googleapis.com/auth/webmasters.readonly");
        Preconditions.checkArgument((Objects.equals("https://www.googleapis.com/auth/webmasters.readonly", scope) || Objects.equals("https://www.googleapis.com/auth/webmasters", scope) ? 1 : 0) != 0, (Object)"The scope for WebMaster must either be WEBMASTERS_READONLY or WEBMASTERS");
        String credentialFile = wuState.getProp("source.conn.private.key");
        List<String> scopes = Collections.singletonList(scope);
        return new GoogleCommon.CredentialBuilder(credentialFile, scopes).fileSystemUri(wuState.getProp("source.google.privatekey_fs_uri")).proxyUrl(wuState.getProp("source.conn.use.proxy.url")).port(wuState.getProp("source.conn.use.proxy.port")).serviceAccountId(wuState.getProp("source.conn.username")).build();
    }
}

