/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ingestion.google;

import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.writer.partitioner.WriterPartitioner;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DayPartitioner
implements WriterPartitioner<GenericRecord> {
    private static final String PARTITION_COLUMN_PREFIX = "type";
    private static final String PARTITION_COLUMN_YEAR = "year";
    private static final String PARTITION_COLUMN_MONTH = "month";
    private static final String PARTITION_COLUMN_DAY = "day";
    private static final String DEFAULT_DATE_COLUMN = "Date";
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String NAME = "YearMonthDayPartitioner";
    private static final String NAME_SPACE = "gobblin.ingestion.google";
    private final boolean _withColumnNames;
    private final String _prefix;
    private final boolean _withPrefix;
    private final String _dateColumn;
    private final DateTimeFormatter _dateFormatter;
    private final Schema _partitionSchema;

    public DayPartitioner(State state, int numBranches, int branchId) {
        this._withColumnNames = state.getPropAsBoolean("writer.partitioner.google_ingestioncolumn_names.include", false);
        this._prefix = state.getProp("writer.partitioner.google_ingestionprefix");
        this._withPrefix = StringUtils.isNotBlank((CharSequence)this._prefix);
        this._dateColumn = state.getProp("writer.partitioner.google_ingestiondate.column_name", DEFAULT_DATE_COLUMN);
        this._dateFormatter = DateTimeFormat.forPattern((String)state.getProp("writer.partitioner.google_ingestiondate.format", DEFAULT_DATE_FORMAT));
        SchemaBuilder.FieldAssembler assembler = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)NAME).namespace(NAME_SPACE)).fields();
        Schema stringType = Schema.create((Schema.Type)Schema.Type.STRING);
        if (this._withPrefix) {
            assembler = assembler.name(PARTITION_COLUMN_PREFIX).type(stringType).noDefault();
        }
        this._partitionSchema = (Schema)assembler.name(PARTITION_COLUMN_YEAR).type(stringType).noDefault().name(PARTITION_COLUMN_MONTH).type(stringType).noDefault().name(PARTITION_COLUMN_DAY).type(stringType).noDefault().endRecord();
    }

    public Schema partitionSchema() {
        return this._partitionSchema;
    }

    public GenericRecord partitionForRecord(GenericRecord record) {
        GenericData.Record partition = new GenericData.Record(this._partitionSchema);
        String dateString = record.get(this._dateColumn).toString();
        DateTime date = this._dateFormatter.parseDateTime(dateString);
        if (this._withPrefix) {
            if (this._withColumnNames) {
                partition.put(PARTITION_COLUMN_PREFIX, (Object)("type=" + this._prefix));
            } else {
                partition.put(PARTITION_COLUMN_PREFIX, (Object)this._prefix);
            }
        }
        if (this._withColumnNames) {
            partition.put(PARTITION_COLUMN_YEAR, (Object)("year=" + date.getYear()));
            partition.put(PARTITION_COLUMN_MONTH, (Object)("month=" + date.getMonthOfYear()));
            partition.put(PARTITION_COLUMN_DAY, (Object)("day=" + date.getDayOfMonth()));
        } else {
            partition.put(PARTITION_COLUMN_YEAR, (Object)date.getYear());
            partition.put(PARTITION_COLUMN_MONTH, (Object)date.getMonthOfYear());
            partition.put(PARTITION_COLUMN_DAY, (Object)date.getDayOfMonth());
        }
        return partition;
    }
}

