/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ingestion.google;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncIteratorWithDataSink<T>
implements Iterator<T> {
    private static final Logger log = LoggerFactory.getLogger(AsyncIteratorWithDataSink.class);
    private final Object lock = new Object();
    private volatile Throwable exceptionInProducerThread = null;
    private Thread _producerThread;
    protected LinkedBlockingDeque<T> _dataSink;
    private final int _pollBlockingTime;
    private T _next = null;

    protected AsyncIteratorWithDataSink(int queueSize, int pollBlockingTime) {
        log.info(String.format("Setting queue size: %d, poll blocking second: %d", queueSize, pollBlockingTime));
        this._dataSink = new LinkedBlockingDeque(queueSize);
        this._pollBlockingTime = pollBlockingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        this.initialize();
        if (this._next != null) {
            return true;
        }
        try {
            this._next = this._dataSink.poll(this._pollBlockingTime, TimeUnit.SECONDS);
            while (this._next == null) {
                if (this._producerThread.isAlive()) {
                    log.info(String.format("Producer job not done yet. Will re-poll for %s second(s)...", this._pollBlockingTime));
                    this._next = this._dataSink.poll(this._pollBlockingTime, TimeUnit.SECONDS);
                    continue;
                }
                Object object = this.lock;
                synchronized (object) {
                    if (this.exceptionInProducerThread != null) {
                        throw new RuntimeException(String.format("Found exception in producer thread %s", this._producerThread.getName()), this.exceptionInProducerThread);
                    }
                }
                log.info("Producer job done. No more data in the queue.");
                return false;
            }
            return true;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void initialize() {
        if (this._producerThread == null) {
            this._producerThread = new Thread(this.getProducerRunnable());
            this._producerThread.setUncaughtExceptionHandler(this.getExceptionHandler());
            this._producerThread.start();
        }
    }

    protected abstract Runnable getProducerRunnable();

    @Override
    public T next() {
        if (this.hasNext()) {
            T toReturn = this._next;
            this._next = null;
            return toReturn;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Thread.UncaughtExceptionHandler getExceptionHandler() {
        return new Thread.UncaughtExceptionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Object object = AsyncIteratorWithDataSink.this.lock;
                synchronized (object) {
                    AsyncIteratorWithDataSink.this.exceptionInProducerThread = e;
                }
            }
        };
    }
}

