/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;

@Description(name="field", value="_FUNC_(str, str1, str2, ...) - returns the index of str in the str1,str2,... list or 0 if not found", extended="All primitive types are supported, arguments are compared using str.equals(x). If str is NULL, the return value is 0.")
public class GenericUDFField
extends GenericUDF {
    private transient ObjectInspector[] argumentOIs;
    private final IntWritable r = new IntWritable();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 2) {
            throw new UDFArgumentException("The function FIELD(str, str1, str2, ...) needs at least two arguments.");
        }
        this.argumentOIs = arguments;
        for (int i = 0; i < arguments.length; ++i) {
            ObjectInspector.Category category = arguments[i].getCategory();
            if (category == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentTypeException(i, "The " + GenericUDFUtils.getOrdinal(i + 1) + " argument of function FIELD is expected to a " + ObjectInspector.Category.PRIMITIVE.toString().toLowerCase() + " type, but " + category.toString().toLowerCase() + " is found");
        }
        return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null) {
            this.r.set(0);
            return this.r;
        }
        for (int i = 1; i < arguments.length; ++i) {
            if (arguments[i].get() == null || ObjectInspectorUtils.compare((Object)arguments[0].get(), (ObjectInspector)this.argumentOIs[0], (Object)arguments[i].get(), (ObjectInspector)this.argumentOIs[i]) != 0) continue;
            this.r.set(i);
            return this.r;
        }
        this.r.set(0);
        return this.r;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length >= 2);
        StringBuilder sb = new StringBuilder();
        sb.append("field(");
        sb.append(StringUtils.join((Object[])children, (String)", "));
        sb.append(")");
        return sb.toString();
    }
}

