/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.util.HashSet;
import java.util.Set;

public enum HiveCommand {
    SET,
    RESET,
    DFS,
    ADD,
    LIST,
    RELOAD,
    DELETE,
    COMPILE;

    private static final Set<String> COMMANDS;

    public static HiveCommand find(String[] command) {
        if (null == command) {
            return null;
        }
        String cmd = command[0];
        if (cmd != null) {
            cmd = cmd.trim().toUpperCase();
            if (command.length > 1 && "role".equalsIgnoreCase(command[1])) {
                return null;
            }
            if (command.length > 1 && "from".equalsIgnoreCase(command[1])) {
                return null;
            }
            if (COMMANDS.contains(cmd)) {
                return HiveCommand.valueOf(cmd);
            }
        }
        return null;
    }

    static {
        COMMANDS = new HashSet<String>();
        for (HiveCommand command : HiveCommand.values()) {
            COMMANDS.add(command.name());
        }
    }
}

