/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeNullDesc;

public abstract class PrunerExpressionOperatorFactory {
    public static final NodeProcessor getDefaultExprProcessor() {
        return new DefaultExprProcessor();
    }

    public static final NodeProcessor getGenericFuncProcessor() {
        return new GenericFuncExprProcessor();
    }

    public static final NodeProcessor getFieldProcessor() {
        return new FieldExprProcessor();
    }

    public static class DefaultExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            if (nd instanceof ExprNodeConstantDesc) {
                return ((ExprNodeConstantDesc)nd).clone();
            }
            if (nd instanceof ExprNodeNullDesc) {
                return ((ExprNodeNullDesc)nd).clone();
            }
            return new ExprNodeConstantDesc(((ExprNodeDesc)nd).getTypeInfo(), null);
        }
    }

    public static abstract class ColumnExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprNodeDesc newcd = null;
            ExprNodeColumnDesc cd = (ExprNodeColumnDesc)nd;
            newcd = this.processColumnDesc(procCtx, cd);
            return newcd;
        }

        protected abstract ExprNodeDesc processColumnDesc(NodeProcessorCtx var1, ExprNodeColumnDesc var2);
    }

    public static class FieldExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprNodeFieldDesc fnd = (ExprNodeFieldDesc)nd;
            boolean unknown = false;
            boolean idx = false;
            ExprNodeDesc left_nd = null;
            for (Object child : nodeOutputs) {
                ExprNodeDesc child_nd = (ExprNodeDesc)child;
                if (child_nd instanceof ExprNodeConstantDesc && ((ExprNodeConstantDesc)child_nd).getValue() == null) {
                    unknown = true;
                }
                left_nd = child_nd;
            }
            assert (!idx);
            ExprNodeDesc newnd = null;
            newnd = unknown ? new ExprNodeConstantDesc(fnd.getTypeInfo(), null) : new ExprNodeFieldDesc(fnd.getTypeInfo(), left_nd, fnd.getFieldName(), fnd.getIsList());
            return newnd;
        }
    }

    public static class GenericFuncExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprNodeDesc newfd = null;
            ExprNodeGenericFuncDesc fd = (ExprNodeGenericFuncDesc)nd;
            boolean unknown = false;
            if (FunctionRegistry.isOpAndOrNot(fd)) {
                boolean isAllNull = true;
                for (Object child : nodeOutputs) {
                    ExprNodeDesc child_nd = (ExprNodeDesc)child;
                    if (child_nd instanceof ExprNodeConstantDesc && ((ExprNodeConstantDesc)child_nd).getValue() == null) continue;
                    isAllNull = false;
                }
                unknown = isAllNull;
            } else if (!FunctionRegistry.isDeterministic(fd.getGenericUDF())) {
                unknown = true;
            } else {
                for (Object child : nodeOutputs) {
                    ExprNodeDesc child_nd = (ExprNodeDesc)child;
                    if (!(child_nd instanceof ExprNodeConstantDesc) || ((ExprNodeConstantDesc)child_nd).getValue() != null) continue;
                    unknown = true;
                }
            }
            if (unknown) {
                newfd = new ExprNodeConstantDesc(fd.getTypeInfo(), null);
            } else {
                ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
                for (Object child : nodeOutputs) {
                    children.add((ExprNodeDesc)child);
                }
                newfd = new ExprNodeGenericFuncDesc(fd.getTypeInfo(), fd.getGenericUDF(), children);
            }
            return newfd;
        }
    }
}

