/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.BucketMapJoinOptimizer;
import org.apache.hadoop.hive.ql.optimizer.BucketingSortingReduceSinkOptimizer;
import org.apache.hadoop.hive.ql.optimizer.ColumnPruner;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagate;
import org.apache.hadoop.hive.ql.optimizer.GlobalLimitOptimizer;
import org.apache.hadoop.hive.ql.optimizer.GroupByOptimizer;
import org.apache.hadoop.hive.ql.optimizer.JoinReorder;
import org.apache.hadoop.hive.ql.optimizer.LimitPushdownOptimizer;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.NonBlockingOpDeDupProc;
import org.apache.hadoop.hive.ql.optimizer.SamplePruner;
import org.apache.hadoop.hive.ql.optimizer.SimpleFetchAggregation;
import org.apache.hadoop.hive.ql.optimizer.SimpleFetchOptimizer;
import org.apache.hadoop.hive.ql.optimizer.SkewJoinOptimizer;
import org.apache.hadoop.hive.ql.optimizer.SortedDynPartitionOptimizer;
import org.apache.hadoop.hive.ql.optimizer.SortedMergeBucketMapJoinOptimizer;
import org.apache.hadoop.hive.ql.optimizer.StatsOptimizer;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.correlation.CorrelationOptimizer;
import org.apache.hadoop.hive.ql.optimizer.correlation.ReduceSinkDeDuplication;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteGBUsingIndex;
import org.apache.hadoop.hive.ql.optimizer.lineage.Generator;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.ListBucketingPruner;
import org.apache.hadoop.hive.ql.optimizer.metainfo.annotation.AnnotateWithOpTraits;
import org.apache.hadoop.hive.ql.optimizer.pcr.PartitionConditionRemover;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.optimizer.stats.annotation.AnnotateWithStatistics;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcessor;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.ppd.PredicatePushDown;
import org.apache.hadoop.hive.ql.ppd.PredicateTransitivePropagate;
import org.apache.hadoop.hive.ql.ppd.SyntheticJoinPredicate;

public class Optimizer {
    private ParseContext pctx;
    private List<Transform> transformations;
    private static final Log LOG = LogFactory.getLog((String)Optimizer.class.getName());

    public void initialize(HiveConf hiveConf) {
        boolean isTezExecEngine = HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez");
        boolean bucketMapJoinOptimizer = false;
        this.transformations = new ArrayList<Transform>();
        this.transformations.add(new Generator());
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTPPD)) {
            this.transformations.add(new PredicateTransitivePropagate());
            if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTCONSTANTPROPAGATION)) {
                this.transformations.add(new ConstantPropagate());
            }
            this.transformations.add(new SyntheticJoinPredicate());
            this.transformations.add(new PredicatePushDown());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTCONSTANTPROPAGATION)) {
            this.transformations.add(new ConstantPropagate());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTPPD)) {
            this.transformations.add(new PartitionPruner());
            this.transformations.add(new PartitionConditionRemover());
            if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTLISTBUCKETING)) {
                this.transformations.add(new ListBucketingPruner());
            }
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTGROUPBY) || HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_GROUPBY_SORT)) {
            this.transformations.add(new GroupByOptimizer());
        }
        this.transformations.add(new ColumnPruner());
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_SKEWJOIN_COMPILETIME)) {
            if (!isTezExecEngine) {
                this.transformations.add(new SkewJoinOptimizer());
            } else {
                LOG.warn((Object)"Skew join is currently not supported in tez! Disabling the skew join optimization.");
            }
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTGBYUSINGINDEX)) {
            this.transformations.add(new RewriteGBUsingIndex());
        }
        this.transformations.add(new SamplePruner());
        this.transformations.add(new MapJoinProcessor());
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTBUCKETMAPJOIN) && !isTezExecEngine) {
            this.transformations.add(new BucketMapJoinOptimizer());
            bucketMapJoinOptimizer = true;
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTSORTMERGEBUCKETMAPJOIN) && !isTezExecEngine) {
            if (!bucketMapJoinOptimizer) {
                this.transformations.add(new BucketMapJoinOptimizer());
            }
            this.transformations.add(new SortedMergeBucketMapJoinOptimizer());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTIMIZEBUCKETINGSORTING)) {
            this.transformations.add(new BucketingSortingReduceSinkOptimizer());
        }
        this.transformations.add(new UnionProcessor());
        this.transformations.add(new JoinReorder());
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.DYNAMICPARTITIONING) && HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.DYNAMICPARTITIONINGMODE).equals("nonstrict") && HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTSORTDYNAMICPARTITION) && !HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTLISTBUCKETING)) {
            this.transformations.add(new SortedDynPartitionOptimizer());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTREDUCEDEDUPLICATION)) {
            this.transformations.add(new ReduceSinkDeDuplication());
        }
        this.transformations.add(new NonBlockingOpDeDupProc());
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVELIMITOPTENABLE)) {
            this.transformations.add(new GlobalLimitOptimizer());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTCORRELATION) && !HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEGROUPBYSKEW) && !HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_SKEWJOIN_COMPILETIME) && !isTezExecEngine) {
            this.transformations.add(new CorrelationOptimizer());
        }
        if (HiveConf.getFloatVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVELIMITPUSHDOWNMEMORYUSAGE) > 0.0f) {
            this.transformations.add(new LimitPushdownOptimizer());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTIMIZEMETADATAQUERIES)) {
            this.transformations.add(new StatsOptimizer());
        }
        if (this.pctx.getContext().getExplain() && !isTezExecEngine) {
            this.transformations.add(new AnnotateWithStatistics());
            this.transformations.add(new AnnotateWithOpTraits());
        }
        if (!HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEFETCHTASKCONVERSION).equals("none")) {
            this.transformations.add(new SimpleFetchOptimizer());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEFETCHTASKAGGR)) {
            this.transformations.add(new SimpleFetchAggregation());
        }
    }

    public ParseContext optimize() throws SemanticException {
        for (Transform t : this.transformations) {
            this.pctx = t.transform(this.pctx);
        }
        return this.pctx;
    }

    public ParseContext getPctx() {
        return this.pctx;
    }

    public void setPctx(ParseContext pctx) {
        this.pctx = pctx;
    }
}

