/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.write;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.Progressable;
import parquet.hadoop.ParquetOutputFormat;
import parquet.hadoop.util.ContextUtil;

public class ParquetRecordWriterWrapper
implements org.apache.hadoop.mapred.RecordWriter<Void, ArrayWritable>,
FileSinkOperator.RecordWriter {
    public static final Log LOG = LogFactory.getLog(ParquetRecordWriterWrapper.class);
    private final RecordWriter<Void, ArrayWritable> realWriter;
    private final TaskAttemptContext taskContext;

    public ParquetRecordWriterWrapper(OutputFormat<Void, ArrayWritable> realOutputFormat, JobConf jobConf, String name, Progressable progress) throws IOException {
        try {
            TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)jobConf.get("mapred.task.id"));
            if (taskAttemptID == null) {
                taskAttemptID = new TaskAttemptID();
            }
            this.taskContext = ContextUtil.newTaskAttemptContext((Configuration)jobConf, (TaskAttemptID)taskAttemptID);
            LOG.info((Object)("creating real writer to write at " + name));
            this.realWriter = ((ParquetOutputFormat)realOutputFormat).getRecordWriter(this.taskContext, new Path(name));
            LOG.info((Object)("real writer: " + this.realWriter));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void close(Reporter reporter) throws IOException {
        try {
            this.realWriter.close(this.taskContext);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void write(Void key, ArrayWritable value) throws IOException {
        try {
            this.realWriter.write((Object)key, (Object)value);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close(boolean abort) throws IOException {
        this.close(null);
    }

    @Override
    public void write(Writable w) throws IOException {
        this.write(null, (ArrayWritable)w);
    }
}

