/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObject;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

final class OrcUnion
implements UnionObject {
    private byte tag;
    private Object object;

    OrcUnion() {
    }

    void set(byte tag, Object object) {
        this.tag = tag;
        this.object = object;
    }

    public byte getTag() {
        return this.tag;
    }

    public Object getObject() {
        return this.object;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != OrcUnion.class) {
            return false;
        }
        OrcUnion oth = (OrcUnion)other;
        if (this.tag != oth.tag) {
            return false;
        }
        if (this.object == null) {
            return oth.object == null;
        }
        return this.object.equals(oth.object);
    }

    public int hashCode() {
        int result = this.tag;
        if (this.object != null) {
            result ^= this.object.hashCode();
        }
        return result;
    }

    public String toString() {
        return "union(" + Integer.toString(this.tag & 0xFF) + ", " + this.object + ")";
    }

    static class OrcUnionObjectInspector
    implements UnionObjectInspector {
        private List<ObjectInspector> children;

        protected OrcUnionObjectInspector() {
        }

        OrcUnionObjectInspector(int columnId, List<OrcProto.Type> types) {
            OrcProto.Type type = types.get(columnId);
            this.children = new ArrayList<ObjectInspector>(type.getSubtypesCount());
            for (int i = 0; i < type.getSubtypesCount(); ++i) {
                this.children.add(OrcStruct.createObjectInspector(type.getSubtypes(i), types));
            }
        }

        OrcUnionObjectInspector(UnionTypeInfo info) {
            List unionChildren = info.getAllUnionObjectTypeInfos();
            this.children = new ArrayList<ObjectInspector>(unionChildren.size());
            for (TypeInfo child : info.getAllUnionObjectTypeInfos()) {
                this.children.add(OrcStruct.createObjectInspector(child));
            }
        }

        public List<ObjectInspector> getObjectInspectors() {
            return this.children;
        }

        public byte getTag(Object obj) {
            return ((OrcUnion)obj).tag;
        }

        public Object getField(Object obj) {
            return ((OrcUnion)obj).object;
        }

        public String getTypeName() {
            StringBuilder builder = new StringBuilder("uniontype<");
            boolean first = true;
            for (ObjectInspector child : this.children) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(child.getTypeName());
            }
            builder.append(">");
            return builder.toString();
        }

        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.UNION;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            List<ObjectInspector> other = ((OrcUnionObjectInspector)o).children;
            if (other.size() != this.children.size()) {
                return false;
            }
            for (int i = 0; i < this.children.size(); ++i) {
                if (other.get(i).equals(this.children.get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

