/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.mr.ExecReducer;
import org.apache.hadoop.hive.ql.exec.tez.CustomEdgeConfiguration;
import org.apache.hadoop.hive.ql.exec.tez.CustomPartitionEdge;
import org.apache.hadoop.hive.ql.exec.tez.CustomPartitionVertex;
import org.apache.hadoop.hive.ql.exec.tez.CustomVertexConfiguration;
import org.apache.hadoop.hive.ql.exec.tez.HivePreWarmProcessor;
import org.apache.hadoop.hive.ql.exec.tez.HiveSplitGenerator;
import org.apache.hadoop.hive.ql.exec.tez.MapTezProcessor;
import org.apache.hadoop.hive.ql.exec.tez.MergeFileTezProcessor;
import org.apache.hadoop.hive.ql.exec.tez.ReduceTezProcessor;
import org.apache.hadoop.hive.ql.exec.tez.tools.TezMergedLogicalInput;
import org.apache.hadoop.hive.ql.io.BucketizedHiveInputFormat;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.io.HiveOutputFormatImpl;
import org.apache.hadoop.hive.ql.io.merge.MergeFileMapper;
import org.apache.hadoop.hive.ql.io.merge.MergeFileOutputFormat;
import org.apache.hadoop.hive.ql.io.merge.MergeFileWork;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.CommonMergeJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MergeJoinWork;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.PreWarmVertex;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.dag.library.vertexmanager.ShuffleVertexManager;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.input.MultiMRInput;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.mapreduce.partition.MRPartitioner;
import org.apache.tez.runtime.library.common.comparator.TezBytesComparator;
import org.apache.tez.runtime.library.common.serializer.TezBytesWritableSerialization;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVEdgeConfig;
import org.apache.tez.runtime.library.conf.UnorderedKVEdgeConfig;
import org.apache.tez.runtime.library.conf.UnorderedPartitionedKVEdgeConfig;
import org.apache.tez.runtime.library.input.ConcatenatedMergedKeyValueInput;

public class DagUtils {
    public static final String TEZ_TMP_DIR_KEY = "_hive_tez_tmp_dir";
    private static final Log LOG = LogFactory.getLog((String)DagUtils.class.getName());
    private static final String TEZ_DIR = "_tez_scratch_dir";
    private static DagUtils instance;
    public static final String TEZ_MERGE_CURRENT_MERGE_FILE_PREFIX = "hive.tez.current.merge.file.prefix";
    public static final String TEZ_MERGE_WORK_FILE_PREFIXES = "hive.tez.merge.file.prefixes";

    private void addCredentials(MapWork mapWork, DAG dag) {
        Set<String> paths = mapWork.getPathToAliases().keySet();
        if (!paths.isEmpty()) {
            Iterator pathIterator = Iterators.transform(paths.iterator(), (Function)new Function<String, URI>(){

                public URI apply(String input) {
                    return new Path(input).toUri();
                }
            });
            HashSet uris = new HashSet();
            Iterators.addAll(uris, (Iterator)pathIterator);
            if (LOG.isDebugEnabled()) {
                for (URI uri : uris) {
                    LOG.debug((Object)("Marking URI as needing credentials: " + uri));
                }
            }
            dag.addURIsForCredentials(uris);
        }
    }

    private void addCredentials(ReduceWork reduceWork, DAG dag) {
    }

    private JobConf initializeVertexConf(JobConf baseConf, Context context, MapWork mapWork) {
        JobConf conf = new JobConf((Configuration)baseConf);
        conf.set("__hive.context.name", mapWork.getName());
        if (mapWork.getNumMapTasks() != null) {
            conf.setInt("mapreduce.job.maps", mapWork.getNumMapTasks().intValue());
        }
        if (mapWork.getMaxSplitSize() != null) {
            HiveConf.setLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE, (long)mapWork.getMaxSplitSize());
        }
        if (mapWork.getMinSplitSize() != null) {
            HiveConf.setLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)mapWork.getMinSplitSize());
        }
        if (mapWork.getMinSplitSizePerNode() != null) {
            HiveConf.setLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZEPERNODE, (long)mapWork.getMinSplitSizePerNode());
        }
        if (mapWork.getMinSplitSizePerRack() != null) {
            HiveConf.setLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZEPERRACK, (long)mapWork.getMinSplitSizePerRack());
        }
        Utilities.setInputAttributes((Configuration)conf, mapWork);
        String inpFormat = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZINPUTFORMAT);
        if (inpFormat == null || !StringUtils.isNotBlank((String)inpFormat)) {
            inpFormat = ShimLoader.getHadoopShims().getInputFormatClassName();
        }
        if (mapWork.isUseBucketizedHiveInputFormat()) {
            inpFormat = BucketizedHiveInputFormat.class.getName();
        }
        if (mapWork.isUseOneNullRowInputFormat()) {
            inpFormat = CombineHiveInputFormat.class.getName();
        }
        if (mapWork.getDummyTableScan()) {
            inpFormat = CombineHiveInputFormat.class.getName();
        }
        conf.set(TEZ_TMP_DIR_KEY, context.getMRTmpPath().toUri().toString());
        conf.set("mapred.mapper.class", ExecMapper.class.getName());
        conf.set("mapred.input.format.class", inpFormat);
        if (mapWork instanceof MergeFileWork) {
            MergeFileWork mfWork = (MergeFileWork)mapWork;
            conf.set("mapred.mapper.class", MergeFileMapper.class.getName());
            conf.set("mapred.input.format.class", mfWork.getInputformat());
            conf.setClass("mapred.output.format.class", MergeFileOutputFormat.class, FileOutputFormat.class);
        }
        return conf;
    }

    public GroupInputEdge createEdge(VertexGroup group, JobConf vConf, Vertex w, TezEdgeProperty edgeProp, TezWork.VertexType vertexType) throws IOException {
        Class mergeInputClass;
        LOG.info((Object)("Creating Edge between " + group.getGroupName() + " and " + w.getName()));
        TezEdgeProperty.EdgeType edgeType = edgeProp.getEdgeType();
        switch (edgeType) {
            case BROADCAST_EDGE: {
                mergeInputClass = ConcatenatedMergedKeyValueInput.class;
                break;
            }
            case CUSTOM_EDGE: {
                mergeInputClass = ConcatenatedMergedKeyValueInput.class;
                int numBuckets = edgeProp.getNumBuckets();
                CustomVertexConfiguration vertexConf = new CustomVertexConfiguration(numBuckets, vertexType);
                DataOutputBuffer dob = new DataOutputBuffer();
                vertexConf.write((DataOutput)dob);
                VertexManagerPluginDescriptor desc = VertexManagerPluginDescriptor.create((String)CustomPartitionVertex.class.getName());
                byte[] userPayloadBytes = dob.getData();
                ByteBuffer userPayload = ByteBuffer.wrap(userPayloadBytes);
                desc.setUserPayload(UserPayload.create((ByteBuffer)userPayload));
                w.setVertexManagerPlugin(desc);
                break;
            }
            case CUSTOM_SIMPLE_EDGE: {
                mergeInputClass = ConcatenatedMergedKeyValueInput.class;
                break;
            }
            case SIMPLE_EDGE: {
                this.setupAutoReducerParallelism(edgeProp, w);
            }
            default: {
                mergeInputClass = TezMergedLogicalInput.class;
            }
        }
        return GroupInputEdge.create((VertexGroup)group, (Vertex)w, (EdgeProperty)this.createEdgeProperty(edgeProp, (Configuration)vConf), (InputDescriptor)InputDescriptor.create((String)mergeInputClass.getName()));
    }

    public Edge createEdge(JobConf vConf, Vertex v, Vertex w, TezEdgeProperty edgeProp, TezWork.VertexType vertexType) throws IOException {
        switch (edgeProp.getEdgeType()) {
            case CUSTOM_EDGE: {
                int numBuckets = edgeProp.getNumBuckets();
                CustomVertexConfiguration vertexConf = new CustomVertexConfiguration(numBuckets, vertexType);
                DataOutputBuffer dob = new DataOutputBuffer();
                vertexConf.write((DataOutput)dob);
                VertexManagerPluginDescriptor desc = VertexManagerPluginDescriptor.create((String)CustomPartitionVertex.class.getName());
                byte[] userPayloadBytes = dob.getData();
                ByteBuffer userPayload = ByteBuffer.wrap(userPayloadBytes);
                desc.setUserPayload(UserPayload.create((ByteBuffer)userPayload));
                w.setVertexManagerPlugin(desc);
                break;
            }
            case SIMPLE_EDGE: {
                this.setupAutoReducerParallelism(edgeProp, w);
                break;
            }
        }
        return Edge.create((Vertex)v, (Vertex)w, (EdgeProperty)this.createEdgeProperty(edgeProp, (Configuration)vConf));
    }

    private EdgeProperty createEdgeProperty(TezEdgeProperty edgeProp, Configuration conf) throws IOException {
        MRHelpers.translateMRConfToTez((Configuration)conf);
        String keyClass = conf.get("tez.runtime.key.class");
        String valClass = conf.get("tez.runtime.value.class");
        String partitionerClassName = conf.get("mapred.partitioner.class");
        TezEdgeProperty.EdgeType edgeType = edgeProp.getEdgeType();
        switch (edgeType) {
            case BROADCAST_EDGE: {
                UnorderedKVEdgeConfig et1Conf = UnorderedKVEdgeConfig.newBuilder((String)keyClass, (String)valClass).setFromConfiguration(conf).setKeySerializationClass(TezBytesWritableSerialization.class.getName(), null).setValueSerializationClass(TezBytesWritableSerialization.class.getName(), null).build();
                return et1Conf.createDefaultBroadcastEdgeProperty();
            }
            case CUSTOM_EDGE: {
                assert (partitionerClassName != null);
                Map<String, String> partitionerConf = this.createPartitionerConf(partitionerClassName, conf);
                UnorderedPartitionedKVEdgeConfig et2Conf = UnorderedPartitionedKVEdgeConfig.newBuilder((String)keyClass, (String)valClass, (String)MRPartitioner.class.getName(), partitionerConf).setFromConfiguration(conf).setKeySerializationClass(TezBytesWritableSerialization.class.getName(), null).setValueSerializationClass(TezBytesWritableSerialization.class.getName(), null).build();
                EdgeManagerPluginDescriptor edgeDesc = EdgeManagerPluginDescriptor.create((String)CustomPartitionEdge.class.getName());
                CustomEdgeConfiguration edgeConf = new CustomEdgeConfiguration(edgeProp.getNumBuckets(), null);
                DataOutputBuffer dob = new DataOutputBuffer();
                edgeConf.write((DataOutput)dob);
                byte[] userPayload = dob.getData();
                edgeDesc.setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap(userPayload)));
                return et2Conf.createDefaultCustomEdgeProperty(edgeDesc);
            }
            case CUSTOM_SIMPLE_EDGE: {
                assert (partitionerClassName != null);
                Map<String, String> partitionerConf = this.createPartitionerConf(partitionerClassName, conf);
                UnorderedPartitionedKVEdgeConfig et3Conf = UnorderedPartitionedKVEdgeConfig.newBuilder((String)keyClass, (String)valClass, (String)MRPartitioner.class.getName(), partitionerConf).setFromConfiguration(conf).setKeySerializationClass(TezBytesWritableSerialization.class.getName(), null).setValueSerializationClass(TezBytesWritableSerialization.class.getName(), null).build();
                return et3Conf.createDefaultEdgeProperty();
            }
        }
        assert (partitionerClassName != null);
        Map<String, String> partitionerConf = this.createPartitionerConf(partitionerClassName, conf);
        OrderedPartitionedKVEdgeConfig et4Conf = OrderedPartitionedKVEdgeConfig.newBuilder((String)keyClass, (String)valClass, (String)MRPartitioner.class.getName(), partitionerConf).setFromConfiguration(conf).setKeySerializationClass(TezBytesWritableSerialization.class.getName(), TezBytesComparator.class.getName(), null).setValueSerializationClass(TezBytesWritableSerialization.class.getName(), null).build();
        return et4Conf.createDefaultEdgeProperty();
    }

    private Map<String, String> createPartitionerConf(String partitionerClassName, Configuration baseConf) {
        HashMap<String, String> partitionerConf = new HashMap<String, String>();
        partitionerConf.put("mapred.partitioner.class", partitionerClassName);
        if (baseConf.get("mapreduce.totalorderpartitioner.path") != null) {
            partitionerConf.put("mapreduce.totalorderpartitioner.path", baseConf.get("mapreduce.totalorderpartitioner.path"));
        }
        return partitionerConf;
    }

    public static Resource getContainerResource(Configuration conf) {
        int memory = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZCONTAINERSIZE) > 0 ? HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZCONTAINERSIZE) : conf.getInt("mapreduce.map.memory.mb", 1024);
        int cpus = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZCPUVCORES) > 0 ? HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZCPUVCORES) : conf.getInt("mapreduce.map.cpu.vcores", 1);
        return Resource.newInstance((int)memory, (int)cpus);
    }

    private Map<String, String> getContainerEnvironment(Configuration conf, boolean isMap) {
        HashMap<String, String> environment = new HashMap<String, String>();
        MRHelpers.updateEnvBasedOnMRTaskEnv((Configuration)conf, environment, (boolean)isMap);
        return environment;
    }

    private String getContainerJavaOpts(Configuration conf) {
        String javaOpts = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZJAVAOPTS);
        String logLevel = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZLOGLEVEL);
        ArrayList logProps = Lists.newArrayList();
        TezUtils.addLog4jSystemProperties((String)logLevel, (List)logProps);
        StringBuilder sb = new StringBuilder();
        for (String str : logProps) {
            sb.append(str).append(" ");
        }
        logLevel = sb.toString();
        if (HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZCONTAINERSIZE) > 0) {
            if (javaOpts != null) {
                return javaOpts + " " + logLevel;
            }
            return logLevel;
        }
        if (javaOpts != null && !javaOpts.isEmpty()) {
            LOG.warn((Object)(HiveConf.ConfVars.HIVETEZJAVAOPTS + " will be ignored because " + HiveConf.ConfVars.HIVETEZCONTAINERSIZE + " is not set!"));
        }
        return logLevel + " " + MRHelpers.getJavaOptsForMRMapper((Configuration)conf);
    }

    private Vertex createVertex(JobConf conf, MergeJoinWork mergeJoinWork, LocalResource appJarLr, List<LocalResource> additionalLr, FileSystem fs, Path mrScratchDir, Context ctx, TezWork.VertexType vertexType) throws Exception {
        Utilities.setMergeWork(conf, mergeJoinWork, mrScratchDir, false);
        if (mergeJoinWork.getMainWork() instanceof MapWork) {
            List<BaseWork> mapWorkList = mergeJoinWork.getBaseWorkList();
            MapWork mapWork = (MapWork)mergeJoinWork.getMainWork();
            Vertex mergeVx = this.createVertex(conf, mapWork, appJarLr, additionalLr, fs, mrScratchDir, ctx, vertexType);
            conf.setClass("mapred.input.format.class", HiveInputFormat.class, InputFormat.class);
            conf.setBoolean("mapreduce.tez.input.initializer.serialize.event.payload", false);
            for (int i = 0; i < mapWorkList.size(); ++i) {
                mapWork = (MapWork)mapWorkList.get(i);
                conf.set(TEZ_MERGE_CURRENT_MERGE_FILE_PREFIX, mapWork.getName());
                conf.set("iocontext.input.name", mapWork.getName());
                LOG.info((Object)"Going through each work and adding MultiMRInput");
                mergeVx.addDataSource(mapWork.getName(), MultiMRInput.createConfigBuilder((Configuration)conf, HiveInputFormat.class).build());
            }
            VertexManagerPluginDescriptor desc = VertexManagerPluginDescriptor.create((String)CustomPartitionVertex.class.getName());
            CustomVertexConfiguration vertexConf = new CustomVertexConfiguration(((CommonMergeJoinDesc)mergeJoinWork.getMergeJoinOperator().getConf()).getNumBuckets(), vertexType, mergeJoinWork.getBigTableAlias(), mapWorkList.size() + 1);
            DataOutputBuffer dob = new DataOutputBuffer();
            vertexConf.write((DataOutput)dob);
            byte[] userPayload = dob.getData();
            desc.setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap(userPayload)));
            mergeVx.setVertexManagerPlugin(desc);
            return mergeVx;
        }
        Vertex mergeVx = this.createVertex(conf, (ReduceWork)mergeJoinWork.getMainWork(), appJarLr, additionalLr, fs, mrScratchDir, ctx);
        return mergeVx;
    }

    private Vertex createVertex(JobConf conf, MapWork mapWork, LocalResource appJarLr, List<LocalResource> additionalLr, FileSystem fs, Path mrScratchDir, Context ctx, TezWork.VertexType vertexType) throws Exception {
        DataSourceDescriptor dataSource;
        boolean groupSplitsInInputInitializer;
        Path tezDir = this.getTezDir(mrScratchDir);
        Utilities.cacheMapWork((Configuration)conf, mapWork, mrScratchDir);
        Utilities.createTmpDirs((Configuration)conf, mapWork);
        Vertex map = null;
        int numTasks = -1;
        Class<HiveInputFormat> inputFormatClass = conf.getClass("mapred.input.format.class", InputFormat.class);
        boolean vertexHasCustomInput = TezWork.VertexType.isCustomInputType(vertexType);
        LOG.info((Object)("Vertex has custom input? " + vertexHasCustomInput));
        if (vertexHasCustomInput) {
            groupSplitsInInputInitializer = false;
            inputFormatClass = HiveInputFormat.class;
            conf.setClass("mapred.input.format.class", HiveInputFormat.class, InputFormat.class);
            conf.setBoolean("mapreduce.tez.input.initializer.serialize.event.payload", false);
        } else {
            groupSplitsInInputInitializer = inputFormatClass == HiveInputFormat.class;
        }
        if (mapWork instanceof MergeFileWork) {
            Path outputPath = ((MergeFileWork)mapWork).getOutputDir();
            Path tempOutPath = Utilities.toTempPath(outputPath);
            try {
                if (!fs.exists(tempOutPath)) {
                    fs.mkdirs(tempOutPath);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Can't make path " + outputPath + " : " + e.getMessage());
            }
        }
        conf.set("iocontext.input.name", mapWork.getName());
        if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_AM_SPLIT_GENERATION) && !mapWork.isUseOneNullRowInputFormat()) {
            Utilities.setMapWork((Configuration)conf, mapWork, mrScratchDir, false);
            if (groupSplitsInInputInitializer) {
                InputInitializerDescriptor descriptor = InputInitializerDescriptor.create((String)HiveSplitGenerator.class.getName());
                dataSource = MRInputLegacy.createConfigBuilder((Configuration)conf, inputFormatClass).groupSplits(true).setCustomInitializerDescriptor(descriptor).build();
            } else {
                dataSource = vertexHasCustomInput ? MultiMRInput.createConfigBuilder((Configuration)conf, inputFormatClass).groupSplits(false).build() : MRInputLegacy.createConfigBuilder((Configuration)conf, inputFormatClass).groupSplits(false).build();
            }
        } else {
            dataSource = MRInputHelpers.configureMRInputWithLegacySplitGeneration((Configuration)conf, (Path)new Path(tezDir, "split_" + mapWork.getName().replaceAll(" ", "_")), (boolean)true);
            numTasks = dataSource.getNumberOfShards();
            Utilities.setMapWork((Configuration)conf, mapWork, mrScratchDir, false);
        }
        UserPayload serializedConf = TezUtils.createUserPayloadFromConf((Configuration)conf);
        String procClassName = MapTezProcessor.class.getName();
        if (mapWork instanceof MergeFileWork) {
            procClassName = MergeFileTezProcessor.class.getName();
        }
        map = Vertex.create((String)mapWork.getName(), (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)procClassName).setUserPayload(serializedConf)), (int)numTasks, (Resource)DagUtils.getContainerResource((Configuration)conf));
        map.setTaskEnvironment(this.getContainerEnvironment((Configuration)conf, true));
        map.setTaskLaunchCmdOpts(this.getContainerJavaOpts((Configuration)conf));
        assert (mapWork.getAliasToWork().keySet().size() == 1);
        String alias = mapWork.getAliasToWork().keySet().iterator().next();
        map.addDataSource(alias, dataSource);
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        localResources.put(this.getBaseName(appJarLr), appJarLr);
        for (LocalResource lr : additionalLr) {
            localResources.put(this.getBaseName(lr), lr);
        }
        map.addTaskLocalFiles(localResources);
        return map;
    }

    private JobConf initializeVertexConf(JobConf baseConf, Context context, ReduceWork reduceWork) {
        JobConf conf = new JobConf((Configuration)baseConf);
        conf.set("__hive.context.name", reduceWork.getName());
        conf.set("mapred.reducer.class", ExecReducer.class.getName());
        boolean useSpeculativeExecReducers = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESPECULATIVEEXECREDUCERS);
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HADOOPSPECULATIVEEXECREDUCERS, (boolean)useSpeculativeExecReducers);
        return conf;
    }

    private Vertex createVertex(JobConf conf, ReduceWork reduceWork, LocalResource appJarLr, List<LocalResource> additionalLr, FileSystem fs, Path mrScratchDir, Context ctx) throws Exception {
        conf.set("iocontext.input.name", reduceWork.getName());
        Utilities.setReduceWork((Configuration)conf, reduceWork, mrScratchDir, false);
        Utilities.createTmpDirs((Configuration)conf, reduceWork);
        Vertex reducer = Vertex.create((String)reduceWork.getName(), (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)ReduceTezProcessor.class.getName()).setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)conf))), (int)(reduceWork.isAutoReduceParallelism() ? reduceWork.getMaxReduceTasks() : reduceWork.getNumReduceTasks().intValue()), (Resource)DagUtils.getContainerResource((Configuration)conf));
        reducer.setTaskEnvironment(this.getContainerEnvironment((Configuration)conf, false));
        reducer.setTaskLaunchCmdOpts(this.getContainerJavaOpts((Configuration)conf));
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        localResources.put(this.getBaseName(appJarLr), appJarLr);
        for (LocalResource lr : additionalLr) {
            localResources.put(this.getBaseName(lr), lr);
        }
        reducer.addTaskLocalFiles(localResources);
        return reducer;
    }

    private LocalResource createLocalResource(FileSystem remoteFs, Path file, LocalResourceType type, LocalResourceVisibility visibility) {
        FileStatus fstat = null;
        try {
            fstat = remoteFs.getFileStatus(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        URL resourceURL = ConverterUtils.getYarnUrlFromPath((Path)file);
        long resourceSize = fstat.getLen();
        long resourceModificationTime = fstat.getModificationTime();
        LOG.info((Object)("Resource modification time: " + resourceModificationTime));
        LocalResource lr = (LocalResource)Records.newRecord(LocalResource.class);
        lr.setResource(resourceURL);
        lr.setType(type);
        lr.setSize(resourceSize);
        lr.setVisibility(visibility);
        lr.setTimestamp(resourceModificationTime);
        return lr;
    }

    public PreWarmVertex createPreWarmVertex(TezConfiguration conf, int numContainers, Map<String, LocalResource> localResources) throws IOException, TezException {
        ProcessorDescriptor prewarmProcDescriptor = ProcessorDescriptor.create((String)HivePreWarmProcessor.class.getName());
        prewarmProcDescriptor.setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)conf));
        PreWarmVertex prewarmVertex = PreWarmVertex.create((String)"prewarm", (ProcessorDescriptor)prewarmProcDescriptor, (int)numContainers, (Resource)DagUtils.getContainerResource((Configuration)conf));
        HashMap<String, LocalResource> combinedResources = new HashMap<String, LocalResource>();
        if (localResources != null) {
            combinedResources.putAll(localResources);
        }
        prewarmVertex.addTaskLocalFiles(localResources);
        prewarmVertex.setTaskLaunchCmdOpts(this.getContainerJavaOpts((Configuration)conf));
        prewarmVertex.setTaskEnvironment(this.getContainerEnvironment((Configuration)conf, false));
        return prewarmVertex;
    }

    public Path getDefaultDestDir(Configuration conf) throws LoginException, IOException {
        String jarPathStr;
        UserGroupInformation ugi = ShimLoader.getHadoopShims().getUGIForConf(conf);
        String userName = ShimLoader.getHadoopShims().getShortUserName(ugi);
        String userPathStr = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_USER_INSTALL_DIR);
        Path userPath = new Path(userPathStr);
        FileSystem fs = userPath.getFileSystem(conf);
        String hdfsDirPathStr = jarPathStr = userPathStr + "/" + userName;
        Path hdfsDirPath = new Path(hdfsDirPathStr);
        try {
            FileStatus fstatus = fs.getFileStatus(hdfsDirPath);
            if (!fstatus.isDir()) {
                throw new IOException(ErrorMsg.INVALID_DIR.format(hdfsDirPath.toString()));
            }
        }
        catch (FileNotFoundException e) {
            fs.mkdirs(hdfsDirPath);
        }
        Path retPath = new Path(hdfsDirPath.toString() + "/.hiveJars");
        fs.mkdirs(retPath);
        return retPath;
    }

    public List<LocalResource> localizeTempFilesFromConf(String hdfsDirPathStr, Configuration conf) throws IOException, LoginException {
        ArrayList<LocalResource> tmpResources = new ArrayList<LocalResource>();
        this.addTempResources(conf, tmpResources, hdfsDirPathStr, LocalResourceType.FILE, DagUtils.getTempFilesFromConf(conf));
        this.addTempResources(conf, tmpResources, hdfsDirPathStr, LocalResourceType.ARCHIVE, DagUtils.getTempArchivesFromConf(conf));
        return tmpResources;
    }

    private static String[] getTempFilesFromConf(Configuration conf) {
        String addedJars;
        String addedFiles = Utilities.getResourceFiles(conf, SessionState.ResourceType.FILE);
        if (StringUtils.isNotBlank((String)addedFiles)) {
            HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEADDEDFILES, (String)addedFiles);
        }
        if (StringUtils.isNotBlank((String)(addedJars = Utilities.getResourceFiles(conf, SessionState.ResourceType.JAR)))) {
            HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEADDEDJARS, (String)addedJars);
        }
        String auxJars = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEAUXJARS);
        String allFiles = auxJars + "," + addedJars + "," + addedFiles;
        return allFiles.split(",");
    }

    private static String[] getTempArchivesFromConf(Configuration conf) {
        String addedArchives = Utilities.getResourceFiles(conf, SessionState.ResourceType.ARCHIVE);
        if (StringUtils.isNotBlank((String)addedArchives)) {
            HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEADDEDARCHIVES, (String)addedArchives);
            return addedArchives.split(",");
        }
        return new String[0];
    }

    public List<LocalResource> localizeTempFiles(String hdfsDirPathStr, Configuration conf, String[] inputOutputJars) throws IOException, LoginException {
        if (inputOutputJars == null) {
            return null;
        }
        ArrayList<LocalResource> tmpResources = new ArrayList<LocalResource>();
        this.addTempResources(conf, tmpResources, hdfsDirPathStr, LocalResourceType.FILE, inputOutputJars);
        return tmpResources;
    }

    private void addTempResources(Configuration conf, List<LocalResource> tmpResources, String hdfsDirPathStr, LocalResourceType type, String[] files) throws IOException {
        for (String file : files) {
            if (!StringUtils.isNotBlank((String)file)) continue;
            Path hdfsFilePath = new Path(hdfsDirPathStr, this.getResourceBaseName(new Path(file)));
            LocalResource localResource = this.localizeResource(new Path(file), hdfsFilePath, type, conf);
            tmpResources.add(localResource);
        }
    }

    public FileStatus getHiveJarDirectory(Configuration conf) throws IOException, LoginException {
        FileStatus fstatus = null;
        String hdfsDirPathStr = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_JAR_DIRECTORY, null);
        if (hdfsDirPathStr != null) {
            LOG.info((Object)("Hive jar directory is " + hdfsDirPathStr));
            fstatus = DagUtils.validateTargetDir(new Path(hdfsDirPathStr), conf);
        }
        if (fstatus == null) {
            Path destDir = this.getDefaultDestDir(conf);
            LOG.info((Object)("Jar dir is null/directory doesn't exist. Choosing HIVE_INSTALL_DIR - " + destDir));
            fstatus = DagUtils.validateTargetDir(destDir, conf);
        }
        if (fstatus == null) {
            throw new IOException(ErrorMsg.NO_VALID_LOCATIONS.getMsg());
        }
        return fstatus;
    }

    public static FileStatus validateTargetDir(Path path, Configuration conf) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        FileStatus fstatus = null;
        try {
            fstatus = fs.getFileStatus(path);
        }
        catch (FileNotFoundException fe) {
            // empty catch block
        }
        return fstatus != null && fstatus.isDir() ? fstatus : null;
    }

    public String getExecJarPathLocal() throws URISyntaxException {
        return DagUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI().toString();
    }

    public String getBaseName(LocalResource lr) {
        return FilenameUtils.getName((String)lr.getResource().getFile());
    }

    public String getResourceBaseName(Path path) {
        return path.getName();
    }

    private boolean checkPreExisting(Path src, Path dest, Configuration conf) throws IOException {
        FileSystem destFS = dest.getFileSystem(conf);
        FileSystem sourceFS = src.getFileSystem(conf);
        if (destFS.exists(dest)) {
            return sourceFS.getFileStatus(src).getLen() == destFS.getFileStatus(dest).getLen();
        }
        return false;
    }

    public LocalResource localizeResource(Path src, Path dest, LocalResourceType type, Configuration conf) throws IOException {
        FileSystem destFS;
        block7: {
            destFS = dest.getFileSystem(conf);
            if (src != null && !this.checkPreExisting(src, dest, conf)) {
                LOG.info((Object)("Localizing resource because it does not exist: " + src + " to dest: " + dest));
                try {
                    destFS.copyFromLocalFile(false, false, src, dest);
                }
                catch (IOException e) {
                    LOG.info((Object)"Looks like another thread is writing the same file will wait.");
                    int waitAttempts = conf.getInt(HiveConf.ConfVars.HIVE_LOCALIZE_RESOURCE_NUM_WAIT_ATTEMPTS.varname, HiveConf.ConfVars.HIVE_LOCALIZE_RESOURCE_NUM_WAIT_ATTEMPTS.defaultIntVal);
                    long sleepInterval = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LOCALIZE_RESOURCE_WAIT_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
                    LOG.info((Object)("Number of wait attempts: " + waitAttempts + ". Wait interval: " + sleepInterval));
                    boolean found = false;
                    for (int i = 0; i < waitAttempts; ++i) {
                        if (!this.checkPreExisting(src, dest, conf)) {
                            try {
                                Thread.sleep(sleepInterval);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                throw new IOException(interruptedException);
                            }
                        }
                        found = true;
                        break;
                    }
                    if (found) break block7;
                    LOG.error((Object)"Could not find the jar that was being uploaded");
                    throw new IOException("Previous writer likely failed to write " + dest + ". Failing because I am unlikely to write too.");
                }
            }
        }
        return this.createLocalResource(destFS, dest, type, LocalResourceVisibility.PRIVATE);
    }

    public JobConf createConfiguration(HiveConf hiveConf) throws IOException {
        hiveConf.setBoolean("mapred.mapper.new-api", false);
        JobConf conf = new JobConf((Configuration)new TezConfiguration((Configuration)hiveConf));
        conf.set("mapred.output.committer.class", HadoopShimsSecure.NullOutputCommitter.class.getName());
        conf.setBoolean("mapred.committer.job.setup.cleanup.needed", false);
        conf.setBoolean("mapred.committer.job.task.cleanup.needed", false);
        conf.setClass("mapred.output.format.class", HiveOutputFormatImpl.class, OutputFormat.class);
        conf.set("mapreduce.job.output.key.class", HiveKey.class.getName());
        conf.set("mapreduce.job.output.value.class", BytesWritable.class.getName());
        conf.set("mapred.partitioner.class", HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEPARTITIONER));
        conf.set("tez.runtime.partitioner.class", MRPartitioner.class.getName());
        return conf;
    }

    public JobConf initializeVertexConf(JobConf conf, Context context, BaseWork work) {
        if (work instanceof MapWork) {
            return this.initializeVertexConf(conf, context, (MapWork)work);
        }
        if (work instanceof ReduceWork) {
            return this.initializeVertexConf(conf, context, (ReduceWork)work);
        }
        if (work instanceof MergeJoinWork) {
            return this.initializeVertexConf(conf, context, (MergeJoinWork)work);
        }
        assert (false);
        return null;
    }

    private JobConf initializeVertexConf(JobConf conf, Context context, MergeJoinWork work) {
        if (work.getMainWork() instanceof MapWork) {
            return this.initializeVertexConf(conf, context, (MapWork)work.getMainWork());
        }
        return this.initializeVertexConf(conf, context, (ReduceWork)work.getMainWork());
    }

    public Vertex createVertex(JobConf conf, BaseWork work, Path scratchDir, LocalResource appJarLr, List<LocalResource> additionalLr, FileSystem fileSystem, Context ctx, boolean hasChildren, TezWork tezWork, TezWork.VertexType vertexType) throws Exception {
        StatsPublisher statsPublisher;
        StatsFactory factory;
        Vertex v = null;
        if (work instanceof MapWork) {
            v = this.createVertex(conf, (MapWork)work, appJarLr, additionalLr, fileSystem, scratchDir, ctx, vertexType);
        } else if (work instanceof ReduceWork) {
            v = this.createVertex(conf, (ReduceWork)work, appJarLr, additionalLr, fileSystem, scratchDir, ctx);
        } else if (work instanceof MergeJoinWork) {
            v = this.createVertex(conf, (MergeJoinWork)work, appJarLr, additionalLr, fileSystem, scratchDir, ctx, vertexType);
        } else {
            throw new HiveException(ErrorMsg.GENERIC_ERROR.getErrorCodedMsg());
        }
        if (work.isGatheringStats() && (factory = StatsFactory.newFactory((Configuration)conf)) != null && !(statsPublisher = factory.getStatsPublisher()).init((Configuration)conf) && HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_RELIABLE)) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_INITIALIZATION_ERROR.getErrorCodedMsg());
        }
        if (!hasChildren) {
            v.addDataSink("out_" + work.getName(), new DataSinkDescriptor((OutputDescriptor)OutputDescriptor.create((String)MROutput.class.getName()).setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)conf)), null, null));
        }
        return v;
    }

    public void addCredentials(BaseWork work, DAG dag) {
        if (work instanceof MapWork) {
            this.addCredentials((MapWork)work, dag);
        } else if (work instanceof ReduceWork) {
            this.addCredentials((ReduceWork)work, dag);
        }
    }

    public Path createTezDir(Path scratchDir, Configuration conf) throws IOException {
        String userName = System.getProperty("user.name");
        try {
            UserGroupInformation ugi = ShimLoader.getHadoopShims().getUGIForConf(conf);
            userName = ShimLoader.getHadoopShims().getShortUserName(ugi);
        }
        catch (LoginException e) {
            throw new IOException(e);
        }
        scratchDir = new Path(scratchDir, userName);
        Path tezDir = this.getTezDir(scratchDir);
        FileSystem fs = tezDir.getFileSystem(conf);
        LOG.debug((Object)("TezDir path set " + tezDir + " for user: " + userName));
        fs.mkdirs(tezDir);
        return tezDir;
    }

    public Path getTezDir(Path scratchDir) {
        return new Path(scratchDir, TEZ_DIR);
    }

    public static DagUtils getInstance() {
        if (instance == null) {
            instance = new DagUtils();
        }
        return instance;
    }

    private void setupAutoReducerParallelism(TezEdgeProperty edgeProp, Vertex v) throws IOException {
        if (edgeProp.isAutoReduce()) {
            Configuration pluginConf = new Configuration(false);
            VertexManagerPluginDescriptor desc = VertexManagerPluginDescriptor.create((String)ShuffleVertexManager.class.getName());
            pluginConf.setBoolean("tez.shuffle-vertex-manager.enable.auto-parallel", true);
            pluginConf.setInt("tez.shuffle-vertex-manager.min-task-parallelism", edgeProp.getMinReducer());
            pluginConf.setLong("tez.shuffle-vertex-manager.desired-task-input-size", edgeProp.getInputSizePerReducer());
            UserPayload payload = TezUtils.createUserPayloadFromConf((Configuration)pluginConf);
            desc.setUserPayload(payload);
            v.setVertexManagerPlugin(desc);
        }
    }

    private DagUtils() {
    }
}

