/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.Writable;

public class MapJoinEagerRowContainer
implements MapJoinRowContainer,
AbstractRowContainer.RowIterator<List<Object>> {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final List<List<Object>> list;
    private byte aliasFilter = (byte)-1;
    private int index = 0;

    public MapJoinEagerRowContainer() {
        this.list = new ArrayList<List<Object>>(1);
    }

    @Override
    public void addRow(List<Object> t) {
        this.list.add(t);
    }

    @Override
    public void addRow(Object[] t) {
        this.addRow(this.toList(t));
    }

    @Override
    public AbstractRowContainer.RowIterator<List<Object>> rowIter() {
        return this;
    }

    @Override
    public List<Object> first() {
        this.index = 0;
        if (this.index < this.list.size()) {
            return this.list.get(this.index);
        }
        return null;
    }

    @Override
    public List<Object> next() {
        ++this.index;
        if (this.index < this.list.size()) {
            return this.list.get(this.index);
        }
        return null;
    }

    @Override
    public int rowCount() {
        return this.list.size();
    }

    @Override
    public void clearRows() {
        this.list.clear();
    }

    @Override
    public byte getAliasFilter() {
        return this.aliasFilter;
    }

    @Override
    public MapJoinRowContainer copy() {
        MapJoinEagerRowContainer result = new MapJoinEagerRowContainer();
        for (List<Object> item : this.list) {
            result.addRow(item);
        }
        return result;
    }

    public void read(MapJoinObjectSerDeContext context, ObjectInputStream in, Writable container) throws IOException, SerDeException {
        this.clearRows();
        long numRows = in.readLong();
        for (long rowIndex = 0L; rowIndex < numRows; ++rowIndex) {
            container.readFields((DataInput)in);
            this.read(context, container);
        }
    }

    public void read(MapJoinObjectSerDeContext context, Writable currentValue) throws SerDeException {
        SerDe serde = context.getSerDe();
        List value = (List)ObjectInspectorUtils.copyToStandardObject((Object)serde.deserialize(currentValue), (ObjectInspector)serde.getObjectInspector(), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        if (value == null) {
            this.addRow(this.toList(EMPTY_OBJECT_ARRAY));
        } else {
            Object[] valuesArray = value.toArray();
            if (context.hasFilterTag()) {
                this.aliasFilter = (byte)(this.aliasFilter & ((ShortWritable)valuesArray[valuesArray.length - 1]).get());
            }
            this.addRow(this.toList(valuesArray));
        }
    }

    @Override
    public void write(MapJoinObjectSerDeContext context, ObjectOutputStream out) throws IOException, SerDeException {
        SerDe serde = context.getSerDe();
        ObjectInspector valueObjectInspector = context.getStandardOI();
        long numRows = this.rowCount();
        long numRowsWritten = 0L;
        out.writeLong(numRows);
        Object row = this.first();
        while (row != null) {
            serde.serialize((Object)row.toArray(), valueObjectInspector).write((DataOutput)out);
            ++numRowsWritten;
            row = this.next();
        }
        if (numRows != (long)this.rowCount()) {
            throw new ConcurrentModificationException("Values was modifified while persisting");
        }
        if (numRowsWritten != numRows) {
            throw new IllegalStateException("Expected to write " + numRows + " but wrote " + numRowsWritten);
        }
    }

    private List<Object> toList(Object[] array) {
        return new NoCopyingArrayList(array);
    }

    private static class NoCopyingArrayList
    extends AbstractList<Object> {
        private Object[] array;

        public NoCopyingArrayList(Object[] array) {
            this.array = array;
        }

        @Override
        public Object get(int index) {
            return this.array[index];
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Object[] toArray() {
            return this.array;
        }
    }
}

