/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class SelectOperator
extends Operator<SelectDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient ExprNodeEvaluator[] eval;
    transient Object[] output;
    private transient boolean isSelectStarNoCompute = false;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        if (((SelectDesc)this.conf).isSelStarNoCompute()) {
            this.initializeChildren(hconf);
            this.isSelectStarNoCompute = true;
            return;
        }
        List<ExprNodeDesc> colList = ((SelectDesc)this.conf).getColList();
        this.eval = new ExprNodeEvaluator[colList.size()];
        for (int i = 0; i < colList.size(); ++i) {
            assert (colList.get(i) != null);
            this.eval[i] = ExprNodeEvaluatorFactory.get(colList.get(i));
            if (!HiveConf.getBoolVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEEXPREVALUATIONCACHE)) continue;
            this.eval[i] = ExprNodeEvaluatorFactory.toCachedEval(this.eval[i]);
        }
        this.output = new Object[this.eval.length];
        this.LOG.info((Object)("SELECT " + ((StructObjectInspector)this.inputObjInspectors[0]).getTypeName()));
        this.outputObjInspector = SelectOperator.initEvaluatorsAndReturnStruct(this.eval, ((SelectDesc)this.conf).getOutputColumnNames(), this.inputObjInspectors[0]);
        this.initializeChildren(hconf);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        int i;
        if (this.isSelectStarNoCompute) {
            this.forward(row, this.inputObjInspectors[tag]);
            return;
        }
        try {
            for (i = 0; i < this.eval.length; ++i) {
                this.output[i] = this.eval[i].evaluate(row);
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new HiveException("Error evaluating " + ((SelectDesc)this.conf).getColList().get(i).getExprString(), e);
        }
        this.forward(this.output, this.outputObjInspector);
    }

    @Override
    public String getName() {
        return SelectOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "SEL";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.SELECT;
    }

    @Override
    public boolean supportSkewJoinOptimization() {
        return true;
    }

    @Override
    public boolean columnNamesRowResolvedCanBeObtained() {
        return true;
    }

    @Override
    public boolean supportAutomaticSortMergeJoin() {
        return true;
    }

    @Override
    public boolean supportUnionRemoveOptimization() {
        return true;
    }

    @Override
    public boolean acceptLimitPushdown() {
        return true;
    }

    public boolean isIdentitySelect() {
        if (this.getNumParent() != 1) {
            return false;
        }
        if (((SelectDesc)this.getConf()).isSelStarNoCompute() || ((SelectDesc)this.getConf()).isSelectStar()) {
            return true;
        }
        return OperatorUtils.sameRowSchema(this, this.getParentOperators().get(0));
    }
}

