/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;

public class RowSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<ColumnInfo> signature = new ArrayList();

    public RowSchema() {
    }

    public RowSchema(RowSchema that) {
        this.signature = (ArrayList)that.signature.clone();
    }

    public RowSchema(ArrayList<ColumnInfo> signature) {
        this.signature = signature;
    }

    public void setSignature(ArrayList<ColumnInfo> signature) {
        this.signature = signature;
    }

    public ArrayList<ColumnInfo> getSignature() {
        return this.signature;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RowSchema) || obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RowSchema dest = (RowSchema)obj;
        if (this.signature == null && dest.getSignature() == null) {
            return true;
        }
        if (this.signature == null && dest.getSignature() != null || this.signature != null && dest.getSignature() == null) {
            return false;
        }
        if (this.signature.size() != dest.getSignature().size()) {
            return false;
        }
        Iterator<ColumnInfo> origIt = this.signature.iterator();
        Iterator<ColumnInfo> destIt = dest.getSignature().iterator();
        while (origIt.hasNext()) {
            ColumnInfo origColumn = origIt.next();
            ColumnInfo destColumn = destIt.next();
            if (origColumn == null && destColumn == null) continue;
            if (origColumn == null && destColumn != null || origColumn != null && destColumn == null) {
                return false;
            }
            if (origColumn.equals(destColumn)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (ColumnInfo col : this.signature) {
            if (sb.length() > 1) {
                sb.append(',');
            }
            sb.append(col.toString());
        }
        sb.append(')');
        return sb.toString();
    }
}

