/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectsEqualComparer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;

public class KeyWrapperFactory {
    transient ExprNodeEvaluator[] keyFields;
    transient ObjectInspector[] keyObjectInspectors;
    transient ObjectInspector[] currentKeyObjectInspectors;
    transient ListObjectsEqualComparer currentStructEqualComparer;
    transient ListObjectsEqualComparer newKeyStructEqualComparer;
    transient Object[] singleEleArray = new Object[1];
    transient StringObjectInspector soi_new;
    transient StringObjectInspector soi_copy;

    public KeyWrapperFactory(ExprNodeEvaluator[] keyFields, ObjectInspector[] keyObjectInspectors, ObjectInspector[] currentKeyObjectInspectors) {
        this.keyFields = keyFields;
        this.keyObjectInspectors = keyObjectInspectors;
        this.currentKeyObjectInspectors = currentKeyObjectInspectors;
    }

    public KeyWrapper getKeyWrapper() {
        if (this.keyFields.length == 1 && TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.keyObjectInspectors[0]).equals((Object)TypeInfoFactory.stringTypeInfo)) {
            assert (TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.currentKeyObjectInspectors[0]).equals((Object)TypeInfoFactory.stringTypeInfo));
            this.soi_new = (StringObjectInspector)this.keyObjectInspectors[0];
            this.soi_copy = (StringObjectInspector)this.currentKeyObjectInspectors[0];
            return new TextKeyWrapper(false);
        }
        this.currentStructEqualComparer = new ListObjectsEqualComparer(this.currentKeyObjectInspectors, this.currentKeyObjectInspectors);
        this.newKeyStructEqualComparer = new ListObjectsEqualComparer(this.currentKeyObjectInspectors, this.keyObjectInspectors);
        return new ListKeyWrapper(false);
    }

    class TextKeyWrapper
    extends KeyWrapper {
        int hashcode;
        Object key;
        boolean isCopy;

        public TextKeyWrapper(boolean isCopy) {
            this(-1, null, isCopy);
        }

        private TextKeyWrapper(int hashcode, Object key, boolean isCopy) {
            this.hashcode = hashcode;
            this.key = key;
            this.isCopy = isCopy;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object other) {
            Text t2;
            Text t1;
            Object obj = ((TextKeyWrapper)other).key;
            if (this.isCopy) {
                t1 = KeyWrapperFactory.this.soi_copy.getPrimitiveWritableObject(this.key);
                t2 = KeyWrapperFactory.this.soi_copy.getPrimitiveWritableObject(obj);
            } else {
                t1 = KeyWrapperFactory.this.soi_new.getPrimitiveWritableObject(this.key);
                t2 = KeyWrapperFactory.this.soi_copy.getPrimitiveWritableObject(obj);
            }
            if (t1 == null && t2 == null) {
                return true;
            }
            if (t1 == null || t2 == null) {
                return false;
            }
            return t1.equals((Object)t2);
        }

        @Override
        public void setHashKey() {
            this.hashcode = this.key == null ? 0 : this.key.hashCode();
        }

        @Override
        public void getNewKey(Object row, ObjectInspector rowInspector) throws HiveException {
            this.key = KeyWrapperFactory.this.keyFields[0].evaluate(row);
        }

        @Override
        public KeyWrapper copyKey() {
            return new TextKeyWrapper(this.hashcode, ObjectInspectorUtils.copyToStandardObject((Object)this.key, (ObjectInspector)KeyWrapperFactory.this.soi_new, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE), true);
        }

        @Override
        public void copyKey(KeyWrapper oldWrapper) {
            TextKeyWrapper textWrapper = (TextKeyWrapper)oldWrapper;
            this.hashcode = textWrapper.hashcode;
            this.isCopy = true;
            this.key = ObjectInspectorUtils.copyToStandardObject((Object)textWrapper.key, (ObjectInspector)KeyWrapperFactory.this.soi_new, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }

        @Override
        public Object[] getKeyArray() {
            KeyWrapperFactory.this.singleEleArray[0] = this.key;
            return KeyWrapperFactory.this.singleEleArray;
        }
    }

    class ListKeyWrapper
    extends KeyWrapper {
        int hashcode;
        Object[] keys;
        ListObjectsEqualComparer equalComparer;

        public ListKeyWrapper(boolean isCopy) {
            this(-1, new Object[keyWrapperFactory.keyFields.length], isCopy);
        }

        private ListKeyWrapper(int hashcode, Object[] copiedKeys, boolean isCopy) {
            this.hashcode = hashcode;
            this.keys = copiedKeys;
            this.setEqualComparer(isCopy);
        }

        private void setEqualComparer(boolean copy) {
            this.equalComparer = !copy ? KeyWrapperFactory.this.newKeyStructEqualComparer : KeyWrapperFactory.this.currentStructEqualComparer;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            Object[] copied_in_hashmap = ((ListKeyWrapper)obj).keys;
            return this.equalComparer.areEqual(copied_in_hashmap, this.keys);
        }

        @Override
        public void setHashKey() {
            this.hashcode = Arrays.hashCode(this.keys);
        }

        @Override
        public void getNewKey(Object row, ObjectInspector rowInspector) throws HiveException {
            for (int i = 0; i < KeyWrapperFactory.this.keyFields.length; ++i) {
                this.keys[i] = KeyWrapperFactory.this.keyFields[i].evaluate(row);
            }
        }

        @Override
        public KeyWrapper copyKey() {
            Object[] newDefaultKeys = this.deepCopyElements(this.keys, KeyWrapperFactory.this.keyObjectInspectors, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            return new ListKeyWrapper(this.hashcode, newDefaultKeys, true);
        }

        @Override
        public void copyKey(KeyWrapper oldWrapper) {
            ListKeyWrapper listWrapper = (ListKeyWrapper)oldWrapper;
            this.hashcode = listWrapper.hashcode;
            this.equalComparer = KeyWrapperFactory.this.currentStructEqualComparer;
            this.deepCopyElements(listWrapper.keys, KeyWrapperFactory.this.keyObjectInspectors, this.keys, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }

        @Override
        public Object[] getKeyArray() {
            return this.keys;
        }

        private Object[] deepCopyElements(Object[] keys, ObjectInspector[] keyObjectInspectors, ObjectInspectorUtils.ObjectInspectorCopyOption copyOption) {
            Object[] result = new Object[keys.length];
            this.deepCopyElements(keys, keyObjectInspectors, result, copyOption);
            return result;
        }

        private void deepCopyElements(Object[] keys, ObjectInspector[] keyObjectInspectors, Object[] result, ObjectInspectorUtils.ObjectInspectorCopyOption copyOption) {
            for (int i = 0; i < keys.length; ++i) {
                result[i] = ObjectInspectorUtils.copyToStandardObject((Object)keys[i], (ObjectInspector)keyObjectInspectors[i], (ObjectInspectorUtils.ObjectInspectorCopyOption)copyOption);
            }
        }
    }
}

