/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.utils;

import com.google.common.base.Splitter;
import com.google.gson.Gson;
import com.typesafe.config.Config;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.gobblin.http.HttpOperation;
import org.apache.gobblin.http.ResponseStatus;
import org.apache.gobblin.http.StatusType;
import org.apache.gobblin.util.AvroUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final Gson GSON = new Gson();
    private static final Splitter LIST_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();

    public static HttpOperation toHttpOperation(GenericRecord record) {
        Object body;
        if (record instanceof HttpOperation) {
            return (HttpOperation)record;
        }
        HttpOperation.Builder builder = HttpOperation.newBuilder();
        Map stringMap = AvroUtils.toStringMap((Object)record.get("keys"));
        if (stringMap != null) {
            builder.setKeys(stringMap);
        }
        if ((stringMap = AvroUtils.toStringMap((Object)record.get("queryParams"))) != null) {
            builder.setQueryParams(stringMap);
        }
        if ((stringMap = AvroUtils.toStringMap((Object)record.get("headers"))) != null) {
            builder.setHeaders(stringMap);
        }
        if ((body = record.get("body")) != null) {
            builder.setBody(body.toString());
        }
        return builder.build();
    }

    public static URI buildURI(String urlTemplate, Map<String, String> keys, Map<String, String> queryParams) {
        String url = urlTemplate;
        if (keys != null && keys.size() != 0) {
            url = StrSubstitutor.replace((Object)urlTemplate, keys);
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (queryParams != null && queryParams.size() != 0) {
                for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                    uriBuilder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Fail to build uri", e);
        }
    }

    public static List<String> getStringList(String list) {
        return LIST_SPLITTER.splitToList((CharSequence)list);
    }

    public static Set<String> getErrorCodeWhitelist(Config config) {
        String list = config.getString("errorCodeWhitelist").toLowerCase();
        return new HashSet<String>(HttpUtils.getStringList(list));
    }

    public static void updateStatusType(ResponseStatus status, int statusCode, Set<String> errorCodeWhitelist) {
        if (statusCode >= 300 & statusCode < 500) {
            ArrayList<String> whitelist = new ArrayList<String>();
            whitelist.add(Integer.toString(statusCode));
            if (statusCode > 400) {
                whitelist.add("4xx");
            } else {
                whitelist.add("3xx");
            }
            if (whitelist.stream().anyMatch(errorCodeWhitelist::contains)) {
                status.setType(StatusType.CONTINUE);
            } else {
                status.setType(StatusType.CLIENT_ERROR);
            }
        } else if (statusCode >= 500) {
            List<String> whitelist = Arrays.asList(Integer.toString(statusCode), "5xx");
            if (whitelist.stream().anyMatch(errorCodeWhitelist::contains)) {
                status.setType(StatusType.CONTINUE);
            } else {
                status.setType(StatusType.SERVER_ERROR);
            }
        }
    }

    public static Map<String, Object> toMap(String jsonString) {
        HashMap map = new HashMap();
        return (Map)GSON.fromJson(jsonString, map.getClass());
    }

    public static String createApacheHttpClientLimiterKey(Config config) {
        try {
            String urlTemplate = config.getString("urlTemplate");
            URL url = new URL(urlTemplate);
            String key = url.getProtocol() + "/" + url.getHost();
            if (url.getPort() > 0) {
                key = key + "/" + url.getPort();
            }
            log.info("Get limiter key [" + key + "]");
            return key;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot get limiter key.", e);
        }
    }

    public static String createR2ClientLimiterKey(Config config) {
        String urlTemplate = config.getString("urlTemplate");
        try {
            String escaped = URIUtil.encodeQuery((String)urlTemplate);
            URI uri = new URI(escaped);
            if (uri.getHost() == null) {
                throw new RuntimeException("Cannot get host part from uri" + urlTemplate);
            }
            String key = uri.getScheme() + "/" + uri.getHost();
            if (uri.getPort() > 0) {
                key = key + "/" + uri.getPort();
            }
            log.info("Get limiter key [" + key + "]");
            return key;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create R2 limiter key", e);
        }
    }
}

