/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.http;

import com.codahale.metrics.Timer;
import java.io.IOException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.gobblin.async.Callback;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.NotConfiguredException;
import org.apache.gobblin.broker.iface.SharedResourceFactory;
import org.apache.gobblin.broker.iface.SharedResourceKey;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.http.HttpClient;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.broker.MetricContextFactory;
import org.apache.gobblin.metrics.broker.MetricContextKey;
import org.apache.gobblin.util.http.HttpLimiterKey;
import org.apache.gobblin.util.limiter.Limiter;
import org.apache.gobblin.util.limiter.broker.SharedLimiterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThrottledHttpClient<RQ, RP>
implements HttpClient<RQ, RP> {
    private static final Logger log = LoggerFactory.getLogger(ThrottledHttpClient.class);
    protected final Limiter limiter;
    protected final SharedResourcesBroker<GobblinScopeTypes> broker;
    private final Timer sendTimer;
    private final MetricContext metricContext;

    public ThrottledHttpClient(SharedResourcesBroker<GobblinScopeTypes> broker, String limiterKey) {
        this.broker = broker;
        try {
            this.limiter = (Limiter)broker.getSharedResource((SharedResourceFactory)new SharedLimiterFactory(), (SharedResourceKey)new HttpLimiterKey(limiterKey));
            this.metricContext = (MetricContext)broker.getSharedResource((SharedResourceFactory)new MetricContextFactory(), (SharedResourceKey)new MetricContextKey());
            this.sendTimer = this.metricContext.timer(limiterKey);
        }
        catch (NotConfiguredException e) {
            log.error("Limiter cannot be initialized due to exception " + ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    @Override
    public final RP sendRequest(RQ request) throws IOException {
        Timer.Context context = this.sendTimer.time();
        try {
            if (this.limiter.acquirePermits(1L) != null) {
                log.debug("Acquired permits successfully");
                RP RP = this.sendRequestImpl(request);
                return RP;
            }
            try {
                throw new IOException("Acquired permits return null");
            }
            catch (InterruptedException e) {
                throw new IOException("Throttling is interrupted");
            }
        }
        finally {
            context.stop();
        }
    }

    @Override
    public final void sendAsyncRequest(RQ request, Callback<RP> callback) throws IOException {
        block6: {
            Timer.Context context = this.sendTimer.time();
            try {
                if (this.limiter.acquirePermits(1L) != null) {
                    log.debug("Acquired permits successfully");
                    this.sendAsyncRequestImpl(request, callback);
                    break block6;
                }
                throw new IOException("Acquired permits return null");
            }
            catch (InterruptedException e) {
                throw new IOException("Throttling is interrupted");
            }
            finally {
                context.stop();
            }
        }
    }

    public abstract RP sendRequestImpl(RQ var1) throws IOException;

    public abstract void sendAsyncRequestImpl(RQ var1, Callback<RP> var2) throws IOException;

    public Timer getSendTimer() {
        return this.sendTimer;
    }
}

