/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.SchemaParseException;
import org.apache.commons.lang.reflect.MethodUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.hive.HivePartition;
import org.apache.gobblin.hive.HiveRegistrationUnit;
import org.apache.gobblin.hive.HiveTable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.avro.AvroSerDe;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class HiveMetaStoreUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetaStoreUtils.class);
    private static final TableType DEFAULT_TABLE_TYPE = TableType.EXTERNAL_TABLE;
    private static final Splitter LIST_SPLITTER_COMMA = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private static final Splitter LIST_SPLITTER_COLON = Splitter.on((String)":").trimResults().omitEmptyStrings();
    private static final String EXTERNAL = "EXTERNAL";
    public static final String RUNTIME_PROPS = "runtime.props";

    private HiveMetaStoreUtils() {
    }

    public static Table getTable(HiveTable hiveTable) {
        State props = hiveTable.getProps();
        Table table = new Table();
        table.setDbName(hiveTable.getDbName());
        table.setTableName(hiveTable.getTableName());
        table.setParameters(HiveMetaStoreUtils.getParameters(props));
        if (hiveTable.getCreateTime().isPresent()) {
            table.setCreateTime(Ints.checkedCast((long)((Long)hiveTable.getCreateTime().get())));
        }
        if (hiveTable.getLastAccessTime().isPresent()) {
            table.setLastAccessTime(Ints.checkedCast((long)((Long)hiveTable.getLastAccessTime().get())));
        }
        if (hiveTable.getOwner().isPresent()) {
            table.setOwner((String)hiveTable.getOwner().get());
        }
        if (hiveTable.getRetention().isPresent()) {
            table.setRetention(Ints.checkedCast((long)((Long)hiveTable.getRetention().get())));
        }
        if (hiveTable.getTableType().isPresent()) {
            table.setTableType((String)hiveTable.getTableType().get());
        } else {
            table.setTableType(DEFAULT_TABLE_TYPE.toString());
        }
        if (table.getTableType().equals(TableType.EXTERNAL_TABLE.toString())) {
            table.getParameters().put(EXTERNAL, Boolean.TRUE.toString().toUpperCase());
        }
        table.setPartitionKeys(HiveMetaStoreUtils.getFieldSchemas(hiveTable.getPartitionKeys()));
        table.setSd(HiveMetaStoreUtils.getStorageDescriptor(hiveTable));
        return table;
    }

    public static HiveTable getHiveTable(Table table) {
        State tableProps = HiveMetaStoreUtils.getTableProps(table);
        State storageProps = HiveMetaStoreUtils.getStorageProps(table.getSd());
        State serDeProps = HiveMetaStoreUtils.getSerDeProps(table.getSd().getSerdeInfo());
        HiveTable hiveTable = ((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)new HiveTable.Builder().withDbName(table.getDbName())).withTableName(table.getTableName())).withPartitionKeys(HiveMetaStoreUtils.getColumns(table.getPartitionKeys())).withProps(tableProps)).withStorageProps(storageProps)).withSerdeProps(serDeProps)).build();
        if (table.getCreateTime() > 0) {
            hiveTable.setCreateTime(table.getCreateTime());
        }
        if (table.getSd().getCols() != null) {
            hiveTable.setColumns(HiveMetaStoreUtils.getColumns(table.getSd().getCols()));
        }
        if (table.getSd().getBucketCols() != null) {
            hiveTable.setBucketColumns(table.getSd().getBucketCols());
        }
        return hiveTable;
    }

    public static Partition getPartition(HivePartition hivePartition) {
        State props = hivePartition.getProps();
        Partition partition = new Partition();
        partition.setDbName(hivePartition.getDbName());
        partition.setTableName(hivePartition.getTableName());
        partition.setValues(hivePartition.getValues());
        partition.setParameters(HiveMetaStoreUtils.getParameters(props));
        if (hivePartition.getCreateTime().isPresent()) {
            partition.setCreateTime(Ints.checkedCast((long)((Long)hivePartition.getCreateTime().get())));
        } else if (props.contains("create.time")) {
            partition.setCreateTime(props.getPropAsInt("create.time"));
        }
        if (props.contains("last.access.time")) {
            partition.setLastAccessTime(props.getPropAsInt("last.access.time"));
        }
        partition.setSd(HiveMetaStoreUtils.getStorageDescriptor(hivePartition));
        return partition;
    }

    public static HivePartition getHivePartition(Partition partition) {
        State partitionProps = HiveMetaStoreUtils.getPartitionProps(partition);
        State storageProps = HiveMetaStoreUtils.getStorageProps(partition.getSd());
        State serDeProps = HiveMetaStoreUtils.getSerDeProps(partition.getSd().getSerdeInfo());
        HivePartition hivePartition = ((HivePartition.Builder)((HivePartition.Builder)((HivePartition.Builder)((HivePartition.Builder)((HivePartition.Builder)new HivePartition.Builder().withDbName(partition.getDbName())).withTableName(partition.getTableName())).withPartitionValues(partition.getValues()).withProps(partitionProps)).withStorageProps(storageProps)).withSerdeProps(serDeProps)).build();
        if (partition.getCreateTime() > 0) {
            hivePartition.setCreateTime(partition.getCreateTime());
        }
        if (partition.getSd().getCols() != null) {
            hivePartition.setColumns(HiveMetaStoreUtils.getColumns(partition.getSd().getCols()));
        }
        if (partition.getSd().getBucketCols() != null) {
            hivePartition.setBucketColumns(partition.getSd().getBucketCols());
        }
        return hivePartition;
    }

    private static Map<String, String> getParameters(State props) {
        HashMap parameters = Maps.newHashMap();
        if (props.contains(RUNTIME_PROPS)) {
            String runtimePropsString = props.getProp(RUNTIME_PROPS);
            for (String propValue : LIST_SPLITTER_COMMA.splitToList((CharSequence)runtimePropsString)) {
                List tokens = LIST_SPLITTER_COLON.splitToList((CharSequence)propValue);
                Preconditions.checkState((tokens.size() == 2 ? 1 : 0) != 0, (Object)(propValue + " is not a valid Hive table/partition property"));
                parameters.put(tokens.get(0), tokens.get(1));
            }
        }
        for (String propKey : props.getPropertyNames()) {
            if (propKey.equals(RUNTIME_PROPS)) continue;
            parameters.put(propKey, props.getProp(propKey));
        }
        return parameters;
    }

    private static StorageDescriptor getStorageDescriptor(HiveRegistrationUnit unit) {
        State props = unit.getStorageProps();
        StorageDescriptor sd = new StorageDescriptor();
        sd.setParameters(HiveMetaStoreUtils.getParameters(props));
        sd.setCols(HiveMetaStoreUtils.getFieldSchemas(unit));
        if (unit.getLocation().isPresent()) {
            sd.setLocation((String)unit.getLocation().get());
        }
        if (unit.getInputFormat().isPresent()) {
            sd.setInputFormat((String)unit.getInputFormat().get());
        }
        if (unit.getOutputFormat().isPresent()) {
            sd.setOutputFormat((String)unit.getOutputFormat().get());
        }
        if (unit.getIsCompressed().isPresent()) {
            sd.setCompressed(((Boolean)unit.getIsCompressed().get()).booleanValue());
        }
        if (unit.getNumBuckets().isPresent()) {
            sd.setNumBuckets(((Integer)unit.getNumBuckets().get()).intValue());
        }
        if (unit.getBucketColumns().isPresent()) {
            sd.setBucketCols((List)unit.getBucketColumns().get());
        }
        if (unit.getIsStoredAsSubDirs().isPresent()) {
            sd.setStoredAsSubDirectories(((Boolean)unit.getIsStoredAsSubDirs().get()).booleanValue());
        }
        sd.setSerdeInfo(HiveMetaStoreUtils.getSerDeInfo(unit));
        return sd;
    }

    private static SerDeInfo getSerDeInfo(HiveRegistrationUnit unit) {
        State props = unit.getSerDeProps();
        SerDeInfo si = new SerDeInfo();
        si.setParameters(HiveMetaStoreUtils.getParameters(props));
        si.setName(unit.getTableName());
        if (unit.getSerDeType().isPresent()) {
            si.setSerializationLib((String)unit.getSerDeType().get());
        }
        return si;
    }

    private static State getTableProps(Table table) {
        State tableProps = new State();
        for (Map.Entry entry : table.getParameters().entrySet()) {
            tableProps.setProp((String)entry.getKey(), entry.getValue());
        }
        if (table.isSetCreateTime()) {
            tableProps.setProp("create.time", (Object)table.getCreateTime());
        }
        if (table.isSetLastAccessTime()) {
            tableProps.setProp("last.access.time", (Object)table.getCreateTime());
        }
        if (table.isSetOwner()) {
            tableProps.setProp("owner", (Object)table.getOwner());
        }
        if (table.isSetTableType()) {
            tableProps.setProp("table.type", (Object)table.getTableType());
        }
        if (table.isSetRetention()) {
            tableProps.setProp("retention", (Object)table.getRetention());
        }
        return tableProps;
    }

    private static State getPartitionProps(Partition partition) {
        State partitionProps = new State();
        for (Map.Entry entry : partition.getParameters().entrySet()) {
            partitionProps.setProp((String)entry.getKey(), entry.getValue());
        }
        if (partition.isSetCreateTime()) {
            partitionProps.setProp("create.time", (Object)partition.getCreateTime());
        }
        if (partition.isSetLastAccessTime()) {
            partitionProps.setProp("last.access.time", (Object)partition.getCreateTime());
        }
        return partitionProps;
    }

    private static State getStorageProps(StorageDescriptor sd) {
        State storageProps = new State();
        for (Map.Entry entry : sd.getParameters().entrySet()) {
            storageProps.setProp((String)entry.getKey(), entry.getValue());
        }
        if (sd.isSetLocation()) {
            storageProps.setProp("location", (Object)sd.getLocation());
        }
        if (sd.isSetInputFormat()) {
            storageProps.setProp("input.format", (Object)sd.getInputFormat());
        }
        if (sd.isSetOutputFormat()) {
            storageProps.setProp("output.format", (Object)sd.getOutputFormat());
        }
        if (sd.isSetCompressed()) {
            storageProps.setProp("compressed", (Object)sd.isCompressed());
        }
        if (sd.isSetNumBuckets()) {
            storageProps.setProp("num.buckets", (Object)sd.getNumBuckets());
        }
        if (sd.isSetBucketCols()) {
            for (String bucketColumn : sd.getBucketCols()) {
                storageProps.appendToListProp("bucket.columns", bucketColumn);
            }
        }
        if (sd.isSetStoredAsSubDirectories()) {
            storageProps.setProp("stored.as.sub.dirs", (Object)sd.isStoredAsSubDirectories());
        }
        return storageProps;
    }

    private static State getSerDeProps(SerDeInfo si) {
        State serDeProps = new State();
        for (Map.Entry entry : si.getParameters().entrySet()) {
            serDeProps.setProp((String)entry.getKey(), entry.getValue());
        }
        if (si.isSetSerializationLib()) {
            serDeProps.setProp("serde.type", (Object)si.getSerializationLib());
        }
        return serDeProps;
    }

    private static List<HiveRegistrationUnit.Column> getColumns(List<FieldSchema> fieldSchemas) {
        ArrayList columns = Lists.newArrayListWithCapacity((int)fieldSchemas.size());
        for (FieldSchema fieldSchema : fieldSchemas) {
            columns.add(new HiveRegistrationUnit.Column(fieldSchema.getName(), fieldSchema.getType(), fieldSchema.getComment()));
        }
        return columns;
    }

    private static List<FieldSchema> getFieldSchemas(List<HiveRegistrationUnit.Column> columns) {
        ArrayList fieldSchemas = Lists.newArrayListWithCapacity((int)columns.size());
        for (HiveRegistrationUnit.Column column : columns) {
            fieldSchemas.add(new FieldSchema(column.getName(), column.getType(), column.getComment()));
        }
        return fieldSchemas;
    }

    private static List<FieldSchema> getFieldSchemas(HiveRegistrationUnit unit) {
        List<HiveRegistrationUnit.Column> columns = unit.getColumns();
        List<Object> fieldSchemas = new ArrayList();
        if (columns != null && columns.size() > 0) {
            fieldSchemas = HiveMetaStoreUtils.getFieldSchemas(columns);
        } else {
            Deserializer deserializer = HiveMetaStoreUtils.getDeserializer(unit);
            if (deserializer != null) {
                try {
                    fieldSchemas = MetaStoreUtils.getFieldsFromDeserializer((String)unit.getTableName(), (Deserializer)deserializer);
                }
                catch (MetaException | SerDeException e) {
                    LOG.warn("Encountered exception while getting fields from deserializer.", e);
                }
            }
        }
        return fieldSchemas;
    }

    private static Deserializer getDeserializer(HiveRegistrationUnit unit) {
        Deserializer deserializer;
        block7: {
            Optional<String> serdeClass = unit.getSerDeType();
            if (!serdeClass.isPresent()) {
                return null;
            }
            String serde = (String)serdeClass.get();
            HiveConf hiveConf = new HiveConf();
            try {
                deserializer = (Deserializer)ReflectionUtils.newInstance(hiveConf.getClassByName(serde).asSubclass(Deserializer.class), (Configuration)hiveConf);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Serde class " + serde + " not found!", (Throwable)e);
                return null;
            }
            Properties props = new Properties();
            props.putAll((Map<?, ?>)unit.getProps().getProperties());
            props.putAll((Map<?, ?>)unit.getStorageProps().getProperties());
            props.putAll((Map<?, ?>)unit.getSerDeProps().getProperties());
            try {
                SerDeUtils.initializeSerDe((Deserializer)deserializer, (Configuration)hiveConf, (Properties)props, null);
                if (!(deserializer instanceof AvroSerDe)) break block7;
                try {
                    HiveMetaStoreUtils.inVokeDetermineSchemaOrThrowExceptionMethod(props, new Configuration());
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | SchemaParseException e) {
                    LOG.warn("Failed to initialize AvroSerDe.");
                    throw new SerDeException(e);
                }
            }
            catch (SerDeException e) {
                LOG.warn("Failed to initialize serde " + serde + " with properties " + props + " for table " + unit.getDbName() + "." + unit.getTableName());
                return null;
            }
        }
        return deserializer;
    }

    @VisibleForTesting
    protected static void inVokeDetermineSchemaOrThrowExceptionMethod(Properties props, Configuration conf) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String methodName = "determineSchemaOrThrowException";
        Method method = MethodUtils.getAccessibleMethod(AvroSerdeUtils.class, (String)methodName, Properties.class);
        boolean withConf = false;
        if (method == null) {
            method = MethodUtils.getAccessibleMethod(AvroSerdeUtils.class, (String)methodName, (Class[])new Class[]{Configuration.class, Properties.class});
            withConf = true;
        }
        Preconditions.checkNotNull((Object)method, (Object)("Cannot find matching " + methodName));
        if (!withConf) {
            MethodUtils.invokeStaticMethod(AvroSerdeUtils.class, (String)methodName, (Object)props);
        } else {
            MethodUtils.invokeStaticMethod(AvroSerdeUtils.class, (String)methodName, (Object[])new Object[]{conf, props});
        }
    }
}

