/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;

@Alpha
public class HiveRegProps
extends State {
    public static final String HIVE_DB_ROOT_DIR = "hive.db.root.dir";
    public static final String HIVE_REGISTER_THREADS = "hive.register.threads";
    public static final int DEFAULT_HIVE_REGISTER_THREADS = 20;
    public static final String HIVE_TABLE_PARTITION_PROPS = "hive.table.partition.props";
    public static final String HIVE_STORAGE_PROPS = "hive.storage.props";
    public static final String HIVE_SERDE_PROPS = "hive.serde.props";
    public static final String HIVE_UPSTREAM_DATA_ATTR_NAMES = "hive.upstream.data.attr.names";
    private static final Splitter SPLITTER = Splitter.on((char)':').trimResults().omitEmptyStrings();
    private final State tablePartitionProps;
    private final State storageProps;
    private final State serdeProps;
    private Optional<String> runtimeTableProps;

    public HiveRegProps(State props) {
        super(props);
        this.tablePartitionProps = this.createHiveProps(HIVE_TABLE_PARTITION_PROPS);
        this.runtimeTableProps = props.contains("runtime.props") ? Optional.of((Object)props.getProp("runtime.props")) : Optional.absent();
        this.storageProps = this.createHiveProps(HIVE_STORAGE_PROPS);
        this.serdeProps = this.createHiveProps(HIVE_SERDE_PROPS);
    }

    public HiveRegProps(State props, State tableProps, State storageProps, State serdeProps) {
        super(props);
        this.tablePartitionProps = tableProps;
        this.runtimeTableProps = props.contains("runtime.props") ? Optional.of((Object)props.getProp("runtime.props")) : Optional.absent();
        this.storageProps = storageProps;
        this.serdeProps = serdeProps;
    }

    private State createHiveProps(String propKey) {
        State state = new State();
        if (!this.contains(propKey)) {
            return state;
        }
        for (String propValue : this.getPropAsList(propKey)) {
            List tokens = SPLITTER.splitToList((CharSequence)propValue);
            Preconditions.checkState((tokens.size() == 2 ? 1 : 0) != 0, (Object)(propValue + " is not a valid Hive table/partition property"));
            state.setProp((String)tokens.get(0), tokens.get(1));
        }
        return state;
    }

    public Optional<String> getDbRootDir() {
        return Optional.fromNullable((Object)this.getProp(HIVE_DB_ROOT_DIR));
    }

    public Optional<String> getUpstreamDataAttrName() {
        return Optional.fromNullable((Object)this.getProp(HIVE_UPSTREAM_DATA_ATTR_NAMES));
    }

    public int getNumThreads() {
        return this.getPropAsInt(HIVE_REGISTER_THREADS, 20);
    }

    public State getTablePartitionProps() {
        return this.tablePartitionProps;
    }

    public State getStorageProps() {
        return this.storageProps;
    }

    public State getSerdeProps() {
        return this.serdeProps;
    }

    public Optional<String> getRuntimeTableProps() {
        return this.runtimeTableProps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HiveRegProps)) {
            return false;
        }
        HiveRegProps other = (HiveRegProps)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        State this$tablePartitionProps = this.getTablePartitionProps();
        State other$tablePartitionProps = other.getTablePartitionProps();
        if (this$tablePartitionProps == null ? other$tablePartitionProps != null : !this$tablePartitionProps.equals(other$tablePartitionProps)) {
            return false;
        }
        State this$storageProps = this.getStorageProps();
        State other$storageProps = other.getStorageProps();
        if (this$storageProps == null ? other$storageProps != null : !this$storageProps.equals(other$storageProps)) {
            return false;
        }
        State this$serdeProps = this.getSerdeProps();
        State other$serdeProps = other.getSerdeProps();
        if (this$serdeProps == null ? other$serdeProps != null : !this$serdeProps.equals(other$serdeProps)) {
            return false;
        }
        Optional<String> this$runtimeTableProps = this.getRuntimeTableProps();
        Optional<String> other$runtimeTableProps = other.getRuntimeTableProps();
        return !(this$runtimeTableProps == null ? other$runtimeTableProps != null : !this$runtimeTableProps.equals(other$runtimeTableProps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HiveRegProps;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        State $tablePartitionProps = this.getTablePartitionProps();
        result = result * 59 + ($tablePartitionProps == null ? 43 : $tablePartitionProps.hashCode());
        State $storageProps = this.getStorageProps();
        result = result * 59 + ($storageProps == null ? 43 : $storageProps.hashCode());
        State $serdeProps = this.getSerdeProps();
        result = result * 59 + ($serdeProps == null ? 43 : $serdeProps.hashCode());
        Optional<String> $runtimeTableProps = this.getRuntimeTableProps();
        result = result * 59 + ($runtimeTableProps == null ? 43 : $runtimeTableProps.hashCode());
        return result;
    }
}

