/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.hive.HiveMetaStoreClientFactory;
import org.apache.gobblin.hive.HiveRegProps;
import org.apache.gobblin.util.AutoReturnableObject;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;

public class HiveMetastoreClientPool {
    private final GenericObjectPool<IMetaStoreClient> pool;
    private final HiveMetaStoreClientFactory factory;
    private final HiveConf hiveConf;
    private final HiveRegProps hiveRegProps;
    private static final long DEFAULT_POOL_CACHE_TTL_MINUTES = 30L;
    private static final Cache<Optional<String>, HiveMetastoreClientPool> poolCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<Optional<String>, HiveMetastoreClientPool>(){

        public void onRemoval(RemovalNotification<Optional<String>, HiveMetastoreClientPool> notification) {
            if (notification.getValue() != null) {
                ((HiveMetastoreClientPool)notification.getValue()).close();
            }
        }
    }).build();

    public static HiveMetastoreClientPool get(final Properties properties, final Optional<String> metastoreURI) throws IOException {
        try {
            return (HiveMetastoreClientPool)poolCache.get(metastoreURI, (Callable)new Callable<HiveMetastoreClientPool>(){

                @Override
                public HiveMetastoreClientPool call() throws Exception {
                    return new HiveMetastoreClientPool(properties, (Optional<String>)metastoreURI);
                }
            });
        }
        catch (ExecutionException ee) {
            throw new IOException("Failed to get " + HiveMetastoreClientPool.class.getSimpleName(), ee.getCause());
        }
    }

    @Deprecated
    public HiveMetastoreClientPool(Properties properties, Optional<String> metastoreURI) {
        this.hiveRegProps = new HiveRegProps(new State(properties));
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(this.hiveRegProps.getNumThreads());
        config.setMaxIdle(this.hiveRegProps.getNumThreads());
        this.factory = new HiveMetaStoreClientFactory(metastoreURI);
        this.pool = new GenericObjectPool((PooledObjectFactory)this.factory, config);
        this.hiveConf = this.factory.getHiveConf();
    }

    public void close() {
        this.pool.close();
    }

    public AutoReturnableObject<IMetaStoreClient> getClient() throws IOException {
        return new AutoReturnableObject(this.pool);
    }

    public static synchronized MultiClient safeGetClients(Map<String, HiveMetastoreClientPool> namedPools) throws IOException {
        return new MultiClient(namedPools);
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    public HiveRegProps getHiveRegProps() {
        return this.hiveRegProps;
    }

    public static class MultiClient
    implements AutoCloseable {
        private final Map<String, AutoReturnableObject<IMetaStoreClient>> clients = Maps.newHashMap();
        private final Closer closer = Closer.create();

        private MultiClient(Map<String, HiveMetastoreClientPool> namedPools) throws IOException {
            HashMap requiredClientsPerPool = Maps.newHashMap();
            for (Map.Entry<String, HiveMetastoreClientPool> entry : namedPools.entrySet()) {
                if (requiredClientsPerPool.containsKey(entry.getValue())) {
                    requiredClientsPerPool.put(entry.getValue(), (Integer)requiredClientsPerPool.get(entry.getValue()) + 1);
                    continue;
                }
                requiredClientsPerPool.put(entry.getValue(), 1);
            }
            for (Map.Entry<String, HiveMetastoreClientPool> entry : requiredClientsPerPool.entrySet()) {
                if (((HiveMetastoreClientPool)((Object)entry.getKey())).pool.getMaxTotal() >= (Integer)((Object)entry.getValue())) continue;
                throw new IOException(String.format("Not enough clients available in the pool. Required %d, max available %d.", entry.getValue(), ((HiveMetastoreClientPool)((Object)entry.getKey())).pool.getMaxTotal()));
            }
            for (Map.Entry<String, HiveMetastoreClientPool> entry : namedPools.entrySet()) {
                this.clients.put(entry.getKey(), (AutoReturnableObject<IMetaStoreClient>)this.closer.register(entry.getValue().getClient()));
            }
        }

        public IMetaStoreClient getClient(String name) throws IOException {
            if (!this.clients.containsKey(name)) {
                throw new IOException("There is no client with name " + name);
            }
            return (IMetaStoreClient)this.clients.get(name).get();
        }

        @Override
        public void close() throws IOException {
            this.closer.close();
        }
    }
}

