/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.google.common.base.Preconditions;
import org.apache.gobblin.writer.LastWatermarkTracker;
import org.apache.gobblin.writer.MultiWriterWatermarkTracker;
import org.apache.gobblin.writer.WatermarkTracker;

public class WatermarkTrackerFactory {
    public static WatermarkTracker getInstance(TrackerBehavior trackerBehavior) {
        Preconditions.checkNotNull((Object)trackerBehavior);
        if (!trackerBehavior.validated) {
            trackerBehavior.validate();
        }
        if (trackerBehavior.trackLast) {
            return new LastWatermarkTracker(trackerBehavior.ignoreUnacknowledged);
        }
        if (trackerBehavior.trackAll) {
            return new MultiWriterWatermarkTracker();
        }
        throw new AssertionError((Object)("Could not find an applicable WatermarkTracker for TrackerBehavior : " + trackerBehavior.toString()));
    }

    public static class TrackerBehavior {
        boolean trackAll = true;
        boolean trackLast = false;
        boolean ignoreUnacknowledged = false;
        boolean validated = false;

        private TrackerBehavior() {
        }

        public static TrackerBehavior defaultBehavior() {
            return new TrackerBehavior();
        }

        TrackerBehavior trackAll() {
            this.trackAll = true;
            this.trackLast = false;
            return this;
        }

        TrackerBehavior trackLast() {
            this.trackLast = true;
            this.trackAll = false;
            return this;
        }

        TrackerBehavior ignoreUnacked() {
            this.ignoreUnacknowledged = true;
            return this;
        }

        private void validate() {
            Preconditions.checkState((this.trackAll || this.trackLast ? 1 : 0) != 0, (Object)"Either trackAll or trackLast must be set");
            this.validated = true;
        }

        TrackerBehavior build() {
            this.validate();
            return this;
        }
    }
}

