/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.gobblin.writer.WriteCallback;
import org.apache.gobblin.writer.WriteResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FutureWrappedWriteCallback
implements WriteCallback<Object>,
Future<WriteResponse> {
    private static final Logger log = LoggerFactory.getLogger(FutureWrappedWriteCallback.class);
    private WriteCallback _innerCallback;
    private WriteResponse _writeResponse = null;
    private Throwable _throwable = null;
    private volatile boolean _callbackFired;

    public FutureWrappedWriteCallback(WriteCallback innerCallback) {
        this._innerCallback = innerCallback;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this._callbackFired;
    }

    @Override
    public WriteResponse get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        FutureWrappedWriteCallback futureWrappedWriteCallback = this;
        synchronized (futureWrappedWriteCallback) {
            while (!this._callbackFired) {
                this.wait(timeout);
            }
        }
        if (this._callbackFired) {
            if (this._throwable != null) {
                throw new ExecutionException(this._throwable);
            }
            return this._writeResponse;
        }
        throw new AssertionError((Object)"Should not be here if _callbackFired is behaving well");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(WriteResponse writeResponse) {
        this._writeResponse = writeResponse;
        FutureWrappedWriteCallback futureWrappedWriteCallback = this;
        synchronized (futureWrappedWriteCallback) {
            this._callbackFired = true;
            if (this._innerCallback != null) {
                try {
                    this._innerCallback.onSuccess(writeResponse);
                }
                catch (Exception e) {
                    log.error("Ignoring error thrown in callback", (Throwable)e);
                }
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Throwable throwable) {
        FutureWrappedWriteCallback futureWrappedWriteCallback = this;
        synchronized (futureWrappedWriteCallback) {
            this._throwable = throwable;
            this._callbackFired = true;
            if (this._innerCallback != null) {
                this._innerCallback.onFailure(throwable);
            }
            this.notifyAll();
        }
    }
}

