/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.writer.AsyncDataWriter;
import org.apache.gobblin.writer.Batch;
import org.apache.gobblin.writer.BatchAccumulator;
import org.apache.gobblin.writer.BatchAsyncDataWriter;
import org.apache.gobblin.writer.RecordMetadata;
import org.apache.gobblin.writer.WriteCallback;
import org.apache.gobblin.writer.WriteResponse;
import org.apache.gobblin.writer.WriteResponseFuture;
import org.apache.gobblin.writer.WriteResponseMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public abstract class BufferedAsyncDataWriter<D>
implements AsyncDataWriter<D> {
    private RecordProcessor<D> processor;
    private BatchAccumulator<D> accumulator;
    private ExecutorService service;
    private volatile boolean running;
    private final long startTime;
    private static final Logger LOG = LoggerFactory.getLogger(BufferedAsyncDataWriter.class);
    private static final WriteResponseMapper<RecordMetadata> WRITE_RESPONSE_WRAPPER = new WriteResponseMapper<RecordMetadata>(){

        @Override
        public WriteResponse wrap(final RecordMetadata recordMetadata) {
            return new WriteResponse<RecordMetadata>(){

                @Override
                public RecordMetadata getRawResponse() {
                    return recordMetadata;
                }

                @Override
                public String getStringResponse() {
                    return recordMetadata.toString();
                }

                @Override
                public long bytesWritten() {
                    return -1L;
                }
            };
        }
    };

    public BufferedAsyncDataWriter(BatchAccumulator<D> accumulator, BatchAsyncDataWriter<D> dataWriter) {
        this.processor = new RecordProcessor<D>(accumulator, dataWriter);
        this.accumulator = accumulator;
        this.service = Executors.newFixedThreadPool(1);
        this.running = true;
        this.startTime = System.currentTimeMillis();
        try {
            this.service.execute(this.processor);
            this.service.shutdown();
        }
        catch (Exception e) {
            LOG.error("Cannot start internal thread to consume the data");
        }
    }

    @Override
    public Future<WriteResponse> write(D record, @Nullable WriteCallback callback) {
        try {
            Future<RecordMetadata> future = this.accumulator.append(record, callback);
            return new WriteResponseFuture<RecordMetadata>(future, WRITE_RESPONSE_WRAPPER);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        this.accumulator.flush();
    }

    public void forceClose() {
        LOG.info("Force to close the buffer data writer (not supported)");
    }

    @Override
    public void close() throws IOException {
        try {
            this.running = false;
            this.accumulator.close();
            if (!this.service.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.forceClose();
            } else {
                LOG.info("Closed properly: elapsed " + (System.currentTimeMillis() - this.startTime) + " milliseconds");
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interruption happened during close " + e.toString());
        }
        finally {
            this.processor.close();
        }
    }

    private class RecordProcessor<D>
    implements Runnable,
    Closeable {
        BatchAccumulator<D> accumulator;
        BatchAsyncDataWriter<D> writer;

        @Override
        public void close() throws IOException {
            this.writer.close();
        }

        public RecordProcessor(BatchAccumulator<D> accumulator, BatchAsyncDataWriter<D> writer) {
            this.accumulator = accumulator;
            this.writer = writer;
        }

        @Override
        public void run() {
            Batch<D> batch;
            LOG.info("Start iterating accumulator");
            while (BufferedAsyncDataWriter.this.running) {
                batch = this.accumulator.getNextAvailableBatch();
                if (batch == null) continue;
                this.writer.write(batch, this.createBatchCallback(batch));
            }
            this.accumulator.waitClose();
            LOG.info("Start to process remaining batches");
            while ((batch = this.accumulator.getNextAvailableBatch()) != null) {
                this.writer.write(batch, this.createBatchCallback(batch));
            }
            this.accumulator.flush();
        }

        private WriteCallback createBatchCallback(final Batch<D> batch) {
            return new WriteCallback<Object>(){

                @Override
                public void onSuccess(WriteResponse writeResponse) {
                    LOG.info("Batch " + batch.getId() + " is on success with size " + batch.getCurrentSizeInByte() + " num of record " + batch.getRecords().size());
                    batch.onSuccess(writeResponse);
                    batch.done();
                    RecordProcessor.this.accumulator.deallocate(batch);
                }

                @Override
                public void onFailure(Throwable throwable) {
                    LOG.info("Batch " + batch.getId() + " is on failure");
                    batch.onFailure(throwable);
                    batch.done();
                    RecordProcessor.this.accumulator.deallocate(batch);
                }
            };
        }
    }
}

