/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.gobblin.ack.Ackable;
import org.apache.gobblin.source.extractor.CheckpointableWatermark;

public class AcknowledgableWatermark
implements Comparable<AcknowledgableWatermark>,
Ackable {
    private final CheckpointableWatermark _checkpointableWatermark;
    private final AtomicInteger _acked = new AtomicInteger(1);

    public AcknowledgableWatermark(CheckpointableWatermark watermark) {
        this._checkpointableWatermark = watermark;
    }

    public void ack() {
        int ackValue = this._acked.decrementAndGet();
        if (ackValue < 0) {
            throw new AssertionError((Object)"The acknowledgement counter for this watermark went negative. Please file a bug!");
        }
    }

    public AcknowledgableWatermark incrementAck() {
        this._acked.incrementAndGet();
        return this;
    }

    public boolean isAcked() {
        return this._acked.get() == 0;
    }

    public CheckpointableWatermark getCheckpointableWatermark() {
        return this._checkpointableWatermark;
    }

    @Override
    public int compareTo(AcknowledgableWatermark o) {
        return this._checkpointableWatermark.compareTo((Object)o._checkpointableWatermark);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcknowledgableWatermark watermark = (AcknowledgableWatermark)o;
        return this._checkpointableWatermark.equals(watermark._checkpointableWatermark);
    }

    public int hashCode() {
        return this._checkpointableWatermark.hashCode();
    }
}

