/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.instrumented.extractor;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.reactivex.Flowable;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.instrumented.Instrumentable;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metadata.GlobalMetadata;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.records.RecordStreamWithMetadata;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.stream.RecordEnvelope;
import org.apache.gobblin.stream.StreamEntity;
import org.apache.gobblin.util.FinalState;

public abstract class InstrumentedExtractorBase<S, D>
implements Extractor<S, D>,
Instrumentable,
Closeable,
FinalState {
    private final boolean instrumentationEnabled;
    private MetricContext metricContext;
    private Optional<Meter> readRecordsMeter;
    private Optional<Meter> dataRecordExceptionsMeter;
    private Optional<Timer> extractorTimer;
    protected final Closer closer = Closer.create();

    public InstrumentedExtractorBase(WorkUnitState workUnitState) {
        this(workUnitState, Optional.absent());
    }

    protected InstrumentedExtractorBase(WorkUnitState workUnitState, Optional<Class<?>> classTag) {
        this.instrumentationEnabled = GobblinMetrics.isEnabled((State)workUnitState);
        this.metricContext = (MetricContext)this.closer.register((Closeable)Instrumented.getMetricContext((State)workUnitState, (Class)classTag.or(this.getClass()), this.generateTags((State)workUnitState)));
        this.regenerateMetrics();
    }

    @Override
    public void switchMetricContext(List<Tag<?>> tags) {
        this.metricContext = (MetricContext)this.closer.register((Closeable)Instrumented.newContextFromReferenceContext(this.metricContext, tags, (Optional<String>)Optional.absent()));
        this.regenerateMetrics();
    }

    @Override
    public void switchMetricContext(MetricContext context) {
        this.metricContext = context;
        this.regenerateMetrics();
    }

    protected void regenerateMetrics() {
        if (this.isInstrumentationEnabled()) {
            this.readRecordsMeter = Optional.of((Object)this.metricContext.meter("gobblin.extractor.records.read"));
            this.dataRecordExceptionsMeter = Optional.of((Object)this.metricContext.meter("gobblin.extractor.records.failed"));
            this.extractorTimer = Optional.of((Object)this.metricContext.timer("gobblin.extractor.extract.time"));
        } else {
            this.readRecordsMeter = Optional.absent();
            this.dataRecordExceptionsMeter = Optional.absent();
            this.extractorTimer = Optional.absent();
        }
    }

    @Override
    public boolean isInstrumentationEnabled() {
        return this.instrumentationEnabled;
    }

    @Override
    public List<Tag<?>> generateTags(State state) {
        return Lists.newArrayList();
    }

    public RecordEnvelope<D> readRecordEnvelope() throws DataRecordException, IOException {
        if (!this.isInstrumentationEnabled()) {
            return this.readRecordEnvelopeImpl();
        }
        try {
            long startTimeNanos = System.nanoTime();
            this.beforeRead();
            RecordEnvelope<D> record = this.readRecordEnvelopeImpl();
            this.afterRead(record == null ? null : record.getRecord(), startTimeNanos);
            return record;
        }
        catch (DataRecordException exception) {
            this.onException((Exception)((Object)exception));
            throw exception;
        }
        catch (IOException exception) {
            this.onException(exception);
            throw exception;
        }
    }

    public RecordStreamWithMetadata<D, S> recordStream(AtomicBoolean shutdownRequest) throws IOException {
        Object schema = this.getSchema();
        Flowable recordStream = Flowable.generate(() -> shutdownRequest, (state, emitter) -> {
            if (state.get()) {
                emitter.onComplete();
            }
            try {
                long startTimeNanos = 0L;
                if (this.isInstrumentationEnabled()) {
                    startTimeNanos = System.nanoTime();
                    this.beforeRead();
                }
                StreamEntity<D> record = this.readStreamEntityImpl();
                if (this.isInstrumentationEnabled()) {
                    Object unwrappedRecord = null;
                    if (record instanceof RecordEnvelope) {
                        unwrappedRecord = ((RecordEnvelope)record).getRecord();
                    }
                    this.afterRead(unwrappedRecord, startTimeNanos);
                }
                if (record != null) {
                    emitter.onNext(record);
                } else {
                    emitter.onComplete();
                }
            }
            catch (IOException | DataRecordException exc) {
                if (this.isInstrumentationEnabled()) {
                    this.onException((Exception)exc);
                }
                emitter.onError(exc);
            }
        });
        recordStream = recordStream.doFinally(this::close);
        return new RecordStreamWithMetadata(recordStream, GlobalMetadata.builder().schema(schema).build());
    }

    public void beforeRead() {
    }

    public void afterRead(D record, long startTime) {
        Instrumented.updateTimer(this.extractorTimer, System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        if (record != null) {
            Instrumented.markMeter(this.readRecordsMeter);
        }
    }

    public void onException(Exception exception) {
        if (DataRecordException.class.isInstance(exception)) {
            Instrumented.markMeter(this.dataRecordExceptionsMeter);
        }
    }

    protected StreamEntity<D> readStreamEntityImpl() throws DataRecordException, IOException {
        return this.readRecordEnvelopeImpl();
    }

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Findbugs believes readRecord(null) is non-null. This is not true.")
    protected RecordEnvelope<D> readRecordEnvelopeImpl() throws DataRecordException, IOException {
        Object record = this.readRecordImpl(null);
        return record == null ? null : new RecordEnvelope(record);
    }

    @Nullable
    protected D readRecordImpl(D reuse) throws DataRecordException, IOException {
        throw new UnsupportedOperationException();
    }

    public State getFinalState() {
        return new State();
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    @Override
    public MetricContext getMetricContext() {
        return this.metricContext;
    }
}

