/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.instrumented.converter;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.instrumented.Instrumentable;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;

abstract class InstrumentedConverterBase<SI, SO, DI, DO>
extends Converter<SI, SO, DI, DO>
implements Instrumentable,
Closeable {
    private boolean instrumentationEnabled = false;
    private MetricContext metricContext;
    private Optional<Meter> recordsInMeter = Optional.absent();
    private Optional<Meter> recordsOutMeter = Optional.absent();
    private Optional<Meter> recordsExceptionMeter = Optional.absent();
    private Optional<Timer> converterTimer = Optional.absent();
    protected final Closer closer = Closer.create();

    InstrumentedConverterBase() {
    }

    public Converter<SI, SO, DI, DO> init(WorkUnitState workUnit) {
        return this.init(workUnit, this.getClass());
    }

    protected Converter<SI, SO, DI, DO> init(WorkUnitState workUnit, Class<?> classTag) {
        Converter converter = super.init(workUnit);
        this.instrumentationEnabled = GobblinMetrics.isEnabled((State)workUnit);
        this.metricContext = (MetricContext)this.closer.register((Closeable)Instrumented.getMetricContext((State)workUnit, classTag));
        this.regenerateMetrics();
        return converter;
    }

    @Override
    public void switchMetricContext(List<Tag<?>> tags) {
        this.metricContext = (MetricContext)this.closer.register((Closeable)Instrumented.newContextFromReferenceContext(this.metricContext, tags, (Optional<String>)Optional.absent()));
        this.regenerateMetrics();
    }

    @Override
    public void switchMetricContext(MetricContext context) {
        this.metricContext = context;
        this.regenerateMetrics();
    }

    protected void regenerateMetrics() {
        if (this.isInstrumentationEnabled()) {
            this.recordsInMeter = Optional.of((Object)this.metricContext.meter("gobblin.converter.records.in"));
            this.recordsOutMeter = Optional.of((Object)this.metricContext.meter("gobblin.converter.records.out"));
            this.recordsExceptionMeter = Optional.of((Object)this.metricContext.meter("gobblin.converter.records.failed"));
            this.converterTimer = Optional.of((Object)this.metricContext.timer("gobblin.converter.convert.time"));
        }
    }

    @Override
    public List<Tag<?>> generateTags(State state) {
        return Lists.newArrayList();
    }

    @Override
    public boolean isInstrumentationEnabled() {
        return this.instrumentationEnabled;
    }

    public Iterable<DO> convertRecord(SO outputSchema, DI inputRecord, WorkUnitState workUnit) throws DataConversionException {
        if (!this.isInstrumentationEnabled()) {
            return this.convertRecordImpl(outputSchema, inputRecord, workUnit);
        }
        try {
            long startTime = System.nanoTime();
            this.beforeConvert(outputSchema, inputRecord, workUnit);
            Iterable<DO> it = this.convertRecordImpl(outputSchema, inputRecord, workUnit);
            this.afterConvert(it, startTime);
            return Iterables.transform(it, (Function)new Function<DO, DO>(){

                public DO apply(DO input) {
                    InstrumentedConverterBase.this.onIterableNext(input);
                    return input;
                }
            });
        }
        catch (DataConversionException exception) {
            this.onException((Exception)((Object)exception));
            throw exception;
        }
    }

    public void beforeConvert(SO outputSchema, DI inputRecord, WorkUnitState workUnit) {
        Instrumented.markMeter(this.recordsInMeter);
    }

    public void afterConvert(Iterable<DO> iterable, long startTimeNanos) {
        Instrumented.updateTimer(this.converterTimer, System.nanoTime() - startTimeNanos, TimeUnit.NANOSECONDS);
    }

    public void onIterableNext(DO next) {
        Instrumented.markMeter(this.recordsOutMeter);
    }

    public void onException(Exception exception) {
        if (DataConversionException.class.isInstance(exception)) {
            Instrumented.markMeter(this.recordsExceptionMeter);
        }
    }

    public abstract Iterable<DO> convertRecordImpl(SO var1, DI var2, WorkUnitState var3) throws DataConversionException;

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    @Override
    public MetricContext getMetricContext() {
        return this.metricContext;
    }
}

