/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.crypto;

import java.util.Map;
import java.util.ServiceLoader;
import org.apache.gobblin.crypto.CredentialStore;
import org.apache.gobblin.crypto.CredentialStoreProvider;
import org.apache.gobblin.crypto.EncryptionConfigParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialStoreFactory {
    private static final Logger log = LoggerFactory.getLogger(CredentialStoreFactory.class);
    private static final Object $LOCK = new Object[0];
    private static ServiceLoader<CredentialStoreProvider> credentialStoreProviderLoader = ServiceLoader.load(CredentialStoreProvider.class);

    public static CredentialStore buildCredentialStore(Map<String, Object> parameters) {
        Object object = $LOCK;
        synchronized (object) {
            String credType = EncryptionConfigParser.getKeystoreType(parameters);
            for (CredentialStoreProvider provider : credentialStoreProviderLoader) {
                log.debug("Looking for cred store type {} in provider {}", (Object)credType, (Object)provider.getClass().getName());
                CredentialStore credStore = provider.buildCredentialStore(parameters);
                if (credStore == null) continue;
                log.debug("Found cred store type {} in provider {}", (Object)credType, (Object)provider.getClass().getName());
                return credStore;
            }
            throw new IllegalArgumentException("Could not find a provider to build algorithm " + credType + " - is gobblin-crypto-provider in classpath?");
        }
    }
}

