/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.jdbc;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.adapter.jdbc.JdbcTableScan;
import org.apache.calcite.adapter.jdbc.JdbcUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.runtime.ResultSetEnumerable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

class JdbcTable
extends AbstractQueryableTable
implements TranslatableTable,
ScannableTable {
    private RelProtoDataType protoRowType;
    private final JdbcSchema jdbcSchema;
    private final String jdbcCatalogName;
    private final String jdbcSchemaName;
    private final String jdbcTableName;
    private final Schema.TableType jdbcTableType;

    public JdbcTable(JdbcSchema jdbcSchema, String jdbcCatalogName, String jdbcSchemaName, String tableName, Schema.TableType jdbcTableType) {
        super((Type)((Object)Object[].class));
        this.jdbcSchema = jdbcSchema;
        this.jdbcCatalogName = jdbcCatalogName;
        this.jdbcSchemaName = jdbcSchemaName;
        this.jdbcTableName = tableName;
        this.jdbcTableType = jdbcTableType;
    }

    public String toString() {
        return "JdbcTable {" + this.jdbcTableName + "}";
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return this.jdbcTableType;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.protoRowType == null) {
            try {
                this.protoRowType = this.jdbcSchema.getRelDataType(this.jdbcCatalogName, this.jdbcSchemaName, this.jdbcTableName);
            }
            catch (SQLException e) {
                throw new RuntimeException("Exception while reading definition of table '" + this.jdbcTableName + "'", e);
            }
        }
        return (RelDataType)this.protoRowType.apply(typeFactory);
    }

    private List<Pair<ColumnMetaData.Rep, Integer>> fieldClasses(final JavaTypeFactory typeFactory) {
        RelDataType rowType = (RelDataType)this.protoRowType.apply(typeFactory);
        return Lists.transform(rowType.getFieldList(), (Function)new Function<RelDataTypeField, Pair<ColumnMetaData.Rep, Integer>>(){

            public Pair<ColumnMetaData.Rep, Integer> apply(RelDataTypeField field) {
                RelDataType type = field.getType();
                Class clazz = (Class)typeFactory.getJavaClass(type);
                ColumnMetaData.Rep rep = Util.first(ColumnMetaData.Rep.of((Type)clazz), ColumnMetaData.Rep.OBJECT);
                return Pair.of(rep, type.getSqlTypeName().getJdbcOrdinal());
            }
        });
    }

    SqlString generateSql() {
        SqlNodeList selectList = new SqlNodeList(Collections.singletonList(new SqlIdentifier("*", SqlParserPos.ZERO)), SqlParserPos.ZERO);
        SqlSelect node = new SqlSelect(SqlParserPos.ZERO, SqlNodeList.EMPTY, selectList, this.tableName(), null, null, null, null, null, null, null);
        SqlPrettyWriter writer = new SqlPrettyWriter(this.jdbcSchema.dialect);
        node.unparse(writer, 0, 0);
        return writer.toSqlString();
    }

    SqlIdentifier tableName() {
        ArrayList<String> strings = new ArrayList<String>();
        if (this.jdbcSchema.catalog != null) {
            strings.add(this.jdbcSchema.catalog);
        }
        if (this.jdbcSchema.schema != null) {
            strings.add(this.jdbcSchema.schema);
        }
        strings.add(this.jdbcTableName);
        return new SqlIdentifier(strings, SqlParserPos.ZERO);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return new JdbcTableScan(context.getCluster(), relOptTable, this, this.jdbcSchema.convention);
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new JdbcTableQueryable(queryProvider, schema, tableName);
    }

    @Override
    public Enumerable<Object[]> scan(DataContext root) {
        JavaTypeFactory typeFactory = root.getTypeFactory();
        SqlString sql = this.generateSql();
        return ResultSetEnumerable.of(this.jdbcSchema.getDataSource(), sql.getSql(), JdbcUtils.ObjectArrayRowBuilder.factory(this.fieldClasses(typeFactory)));
    }

    private class JdbcTableQueryable<T>
    extends AbstractTableQueryable<T> {
        public JdbcTableQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            super(queryProvider, schema, JdbcTable.this, tableName);
        }

        public String toString() {
            return "JdbcTableQueryable {table: " + this.tableName + "}";
        }

        public Enumerator<T> enumerator() {
            JavaTypeFactory typeFactory = ((CalciteConnection)this.queryProvider).getTypeFactory();
            SqlString sql = JdbcTable.this.generateSql();
            Enumerable<Object[]> enumerable = ResultSetEnumerable.of(JdbcTable.this.jdbcSchema.getDataSource(), sql.getSql(), JdbcUtils.ObjectArrayRowBuilder.factory(JdbcTable.this.fieldClasses(typeFactory)));
            return enumerable.enumerator();
        }
    }
}

