/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metastore.util;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;

public class MySqlJdbcUrl {
    private static final String PREFIX = "jdbc:";
    private final URIBuilder builder;

    private MySqlJdbcUrl() {
        this.builder = new URIBuilder();
        this.builder.setScheme("mysql");
    }

    private MySqlJdbcUrl(String url) throws MalformedURLException, URISyntaxException {
        if (!url.startsWith(PREFIX)) {
            throw new MalformedURLException();
        }
        this.builder = new URIBuilder(url.substring(PREFIX.length()));
    }

    public static MySqlJdbcUrl create() {
        return new MySqlJdbcUrl();
    }

    public static MySqlJdbcUrl parse(String url) throws MalformedURLException, URISyntaxException {
        return new MySqlJdbcUrl(url);
    }

    public MySqlJdbcUrl setHost(String host) {
        this.builder.setHost(host);
        return this;
    }

    public MySqlJdbcUrl setPort(int port) {
        this.builder.setPort(port);
        return this;
    }

    public MySqlJdbcUrl setPath(String path) {
        this.builder.setPath("/" + path);
        return this;
    }

    public MySqlJdbcUrl setUser(String user) {
        return this.setParameter("user", user);
    }

    public MySqlJdbcUrl setPassword(String password) {
        return this.setParameter("password", password);
    }

    public MySqlJdbcUrl setParameter(String param, String value) {
        this.builder.setParameter(param, value);
        return this;
    }

    public String toString() {
        try {
            return PREFIX + this.builder.build().toString();
        }
        catch (URISyntaxException e) {
            return "";
        }
    }
}

