/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metastore;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.password.PasswordManager;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.io.StreamUtils;
import org.apache.hadoop.io.Text;

public class MysqlStateStore<T extends State>
implements StateStore<T> {
    private final Class<T> stateClass;
    private final DataSource dataSource;
    private final boolean compressedValues;
    private static final String UPSERT_JOB_STATE_TEMPLATE = "INSERT INTO $TABLE$ (store_name, table_name, state) VALUES(?,?,?) ON DUPLICATE KEY UPDATE state = values(state)";
    private static final String SELECT_JOB_STATE_TEMPLATE = "SELECT state FROM $TABLE$ WHERE store_name = ? and table_name = ?";
    private static final String SELECT_JOB_STATE_WITH_LIKE_TEMPLATE = "SELECT state FROM $TABLE$ WHERE store_name = ? and table_name like ?";
    private static final String SELECT_JOB_STATE_EXISTS_TEMPLATE = "SELECT 1 FROM $TABLE$ WHERE store_name = ? and table_name = ?";
    private static final String SELECT_JOB_STATE_NAMES_TEMPLATE = "SELECT table_name FROM $TABLE$ WHERE store_name = ?";
    private static final String DELETE_JOB_STORE_TEMPLATE = "DELETE FROM $TABLE$ WHERE store_name = ?";
    private static final String DELETE_JOB_STATE_TEMPLATE = "DELETE FROM $TABLE$ WHERE store_name = ? AND table_name = ?";
    private static final String CLONE_JOB_STATE_TEMPLATE = "INSERT INTO $TABLE$(store_name, table_name, state) (SELECT store_name, ?, state FROM $TABLE$ s WHERE store_name = ? AND table_name = ?) ON DUPLICATE KEY UPDATE state = s.state";
    private static final String CREATE_JOB_STATE_TABLE_TEMPLATE = "CREATE TABLE IF NOT EXISTS $TABLE$ (store_name varchar(100) CHARACTER SET latin1 COLLATE latin1_bin not null,table_name varchar(667) CHARACTER SET latin1 COLLATE latin1_bin not null, modified_time timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, state longblob, primary key(store_name, table_name))";
    private final String UPSERT_JOB_STATE_SQL;
    private final String SELECT_JOB_STATE_SQL;
    private final String SELECT_JOB_STATE_WITH_LIKE_SQL;
    private final String SELECT_JOB_STATE_EXISTS_SQL;
    private final String SELECT_JOB_STATE_NAMES_SQL;
    private final String DELETE_JOB_STORE_SQL;
    private final String DELETE_JOB_STATE_SQL;
    private final String CLONE_JOB_STATE_SQL;

    public MysqlStateStore(DataSource dataSource, String stateStoreTableName, boolean compressedValues, Class<T> stateClass) throws IOException {
        this.dataSource = dataSource;
        this.stateClass = stateClass;
        this.compressedValues = compressedValues;
        this.UPSERT_JOB_STATE_SQL = UPSERT_JOB_STATE_TEMPLATE.replace("$TABLE$", stateStoreTableName);
        this.SELECT_JOB_STATE_SQL = SELECT_JOB_STATE_TEMPLATE.replace("$TABLE$", stateStoreTableName);
        this.SELECT_JOB_STATE_WITH_LIKE_SQL = SELECT_JOB_STATE_WITH_LIKE_TEMPLATE.replace("$TABLE$", stateStoreTableName);
        this.SELECT_JOB_STATE_EXISTS_SQL = SELECT_JOB_STATE_EXISTS_TEMPLATE.replace("$TABLE$", stateStoreTableName);
        this.SELECT_JOB_STATE_NAMES_SQL = SELECT_JOB_STATE_NAMES_TEMPLATE.replace("$TABLE$", stateStoreTableName);
        this.DELETE_JOB_STORE_SQL = DELETE_JOB_STORE_TEMPLATE.replace("$TABLE$", stateStoreTableName);
        this.DELETE_JOB_STATE_SQL = DELETE_JOB_STATE_TEMPLATE.replace("$TABLE$", stateStoreTableName);
        this.CLONE_JOB_STATE_SQL = CLONE_JOB_STATE_TEMPLATE.replace("$TABLE$", stateStoreTableName);
        String createJobTable = CREATE_JOB_STATE_TABLE_TEMPLATE.replace("$TABLE$", stateStoreTableName);
        try (Connection connection = dataSource.getConnection();
             PreparedStatement createStatement = connection.prepareStatement(createJobTable);){
            createStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new IOException("Failure creation table " + stateStoreTableName, e);
        }
    }

    public static BasicDataSource newDataSource(Config config) {
        BasicDataSource basicDataSource = new BasicDataSource();
        PasswordManager passwordManager = PasswordManager.getInstance((Properties)ConfigUtils.configToProperties((Config)config));
        basicDataSource.setDriverClassName(ConfigUtils.getString((Config)config, (String)"state.store.db.jdbc.driver", (String)"com.mysql.jdbc.Driver"));
        basicDataSource.setValidationQuery("select 1");
        basicDataSource.setTestOnBorrow(true);
        basicDataSource.setDefaultAutoCommit(false);
        basicDataSource.setTimeBetweenEvictionRunsMillis(60000L);
        basicDataSource.setUrl(config.getString("state.store.db.url"));
        basicDataSource.setUsername(passwordManager.readPassword(config.getString("state.store.db.user")));
        basicDataSource.setPassword(passwordManager.readPassword(config.getString("state.store.db.password")));
        basicDataSource.setMinEvictableIdleTimeMillis(ConfigUtils.getLong((Config)config, (String)"state.store.db.conn.min.evictable.idle.time", (Long)300000L).longValue());
        return basicDataSource;
    }

    @Override
    public boolean create(String storeName) throws IOException {
        return true;
    }

    @Override
    public boolean create(String storeName, String tableName) throws IOException {
        if (this.exists(storeName, tableName)) {
            throw new IOException(String.format("State already exists for storeName %s tableName %s", storeName, tableName));
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean exists(String storeName, String tableName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addStateToDataOutputStream(DataOutput dataOutput, T state) throws IOException {
        new Text(Strings.nullToEmpty((String)state.getId())).write(dataOutput);
        state.write(dataOutput);
    }

    @Override
    public void put(String storeName, String tableName, T state) throws IOException {
        this.putAll(storeName, tableName, Collections.singleton(state));
    }

    @Override
    public void putAll(String storeName, String tableName, Collection<T> states) throws IOException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement insertStatement = connection.prepareStatement(this.UPSERT_JOB_STATE_SQL);
             ByteArrayOutputStream byteArrayOs = new ByteArrayOutputStream();
             OutputStream os = this.compressedValues ? new GZIPOutputStream(byteArrayOs) : byteArrayOs;
             DataOutputStream dataOutput = new DataOutputStream(os);){
            int index = 0;
            insertStatement.setString(++index, storeName);
            insertStatement.setString(++index, tableName);
            for (State state : states) {
                this.addStateToDataOutputStream(dataOutput, state);
            }
            dataOutput.close();
            insertStatement.setBlob(++index, new ByteArrayInputStream(byteArrayOs.toByteArray()));
            insertStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            throw new IOException("Failure storing state to store " + storeName + " table " + tableName, e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T get(String storeName, String tableName, String stateId) throws IOException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement queryStatement = connection.prepareStatement(this.SELECT_JOB_STATE_SQL);){
            int index = 0;
            queryStatement.setString(++index, storeName);
            queryStatement.setString(++index, tableName);
            try (ResultSet rs = queryStatement.executeQuery();){
                Throwable throwable;
                DataInputStream dis;
                Throwable throwable2;
                InputStream is;
                block83: {
                    if (!rs.next()) return null;
                    Blob blob = rs.getBlob(1);
                    Text key = new Text();
                    try {
                        State state;
                        block84: {
                            is = StreamUtils.isCompressed((byte[])blob.getBytes(1L, 2)) ? new GZIPInputStream(blob.getBinaryStream()) : blob.getBinaryStream();
                            throwable2 = null;
                            try {
                                block80: {
                                    block81: {
                                        block82: {
                                            dis = new DataInputStream(is);
                                            throwable = null;
                                            try {
                                                while (dis.available() > 0) {
                                                    State state2 = (State)this.stateClass.newInstance();
                                                    key.readFields((DataInput)dis);
                                                    state2.readFields((DataInput)dis);
                                                    if (!key.toString().equals(stateId)) continue;
                                                    state = state2;
                                                    if (dis == null) break block80;
                                                    if (throwable == null) break block81;
                                                    break block82;
                                                }
                                                break block83;
                                            }
                                            catch (Throwable throwable3) {
                                                try {
                                                    throwable = throwable3;
                                                    throw throwable3;
                                                }
                                                catch (Throwable throwable4) {
                                                    if (dis == null) throw throwable4;
                                                    if (throwable == null) {
                                                        dis.close();
                                                        throw throwable4;
                                                    }
                                                    try {
                                                        dis.close();
                                                        throw throwable4;
                                                    }
                                                    catch (Throwable throwable5) {
                                                        throwable.addSuppressed(throwable5);
                                                        throw throwable4;
                                                    }
                                                }
                                            }
                                        }
                                        try {
                                            dis.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable.addSuppressed(throwable6);
                                        }
                                        break block80;
                                    }
                                    dis.close();
                                }
                                if (is == null) return (T)state;
                                if (throwable2 == null) break block84;
                            }
                            catch (Throwable throwable7) {
                                try {
                                    throwable2 = throwable7;
                                    throw throwable7;
                                }
                                catch (Throwable throwable8) {
                                    if (is == null) throw throwable8;
                                    if (throwable2 != null) {
                                        try {
                                            is.close();
                                            throw throwable8;
                                        }
                                        catch (Throwable throwable9) {
                                            throwable2.addSuppressed(throwable9);
                                            throw throwable8;
                                        }
                                    }
                                    is.close();
                                    throw throwable8;
                                }
                            }
                            try {
                                is.close();
                                return (T)state;
                            }
                            catch (Throwable throwable10) {
                                throwable2.addSuppressed(throwable10);
                                return (T)state;
                            }
                        }
                        is.close();
                        return (T)state;
                    }
                    catch (EOFException eOFException) {
                        // empty catch block
                        return null;
                    }
                }
                if (dis != null) {
                    if (throwable != null) {
                        try {
                            dis.close();
                        }
                        catch (Throwable throwable11) {
                            throwable.addSuppressed(throwable11);
                        }
                    } else {
                        dis.close();
                    }
                }
                if (is == null) return null;
                if (throwable2 != null) {
                    try {
                        is.close();
                        return null;
                    }
                    catch (Throwable throwable12) {
                        throwable2.addSuppressed(throwable12);
                        return null;
                    }
                }
                is.close();
                return null;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("failure retrieving state from storeName " + storeName + " tableName " + tableName, e);
        }
    }

    protected List<T> getAll(String storeName, String tableName, boolean useLike) throws IOException {
        ArrayList states;
        block64: {
            states = Lists.newArrayList();
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement queryStatement = connection.prepareStatement(useLike ? this.SELECT_JOB_STATE_WITH_LIKE_SQL : this.SELECT_JOB_STATE_SQL);){
                queryStatement.setString(1, storeName);
                queryStatement.setString(2, tableName);
                ResultSet rs = queryStatement.executeQuery();
                Throwable throwable = null;
                block50: while (true) {
                    try {
                        while (rs.next()) {
                            Blob blob = rs.getBlob(1);
                            Text key = new Text();
                            try {
                                InputStream is = StreamUtils.isCompressed((byte[])blob.getBytes(1L, 2)) ? new GZIPInputStream(blob.getBinaryStream()) : blob.getBinaryStream();
                                Throwable throwable2 = null;
                                try {
                                    DataInputStream dis = new DataInputStream(is);
                                    Throwable throwable3 = null;
                                    try {
                                        while (true) {
                                            if (dis.available() <= 0) continue block50;
                                            State state = (State)this.stateClass.newInstance();
                                            Text.readString((DataInput)dis);
                                            state.readFields((DataInput)dis);
                                            states.add(state);
                                        }
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3 = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        if (dis == null) continue block50;
                                        if (throwable3 != null) {
                                            try {
                                                dis.close();
                                            }
                                            catch (Throwable throwable5) {
                                                throwable3.addSuppressed(throwable5);
                                            }
                                            continue block50;
                                        }
                                        dis.close();
                                        continue block50;
                                    }
                                }
                                catch (Throwable throwable6) {
                                    throwable2 = throwable6;
                                    throw throwable6;
                                }
                                finally {
                                    if (is == null) continue block50;
                                    if (throwable2 != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable2.addSuppressed(throwable7);
                                        }
                                        continue block50;
                                    }
                                    is.close();
                                    continue block50;
                                }
                            }
                            catch (EOFException eOFException) {
                            }
                        }
                        break block64;
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new IOException("failure retrieving state from storeName " + storeName + " tableName " + tableName, e);
            }
        }
        return states;
    }

    @Override
    public List<T> getAll(String storeName, String tableName) throws IOException {
        return this.getAll(storeName, tableName, false);
    }

    @Override
    public List<T> getAll(String storeName) throws IOException {
        return this.getAll(storeName, "%", true);
    }

    @Override
    public List<String> getTableNames(String storeName, Predicate<String> predicate) throws IOException {
        ArrayList names = Lists.newArrayList();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement queryStatement = connection.prepareStatement(this.SELECT_JOB_STATE_NAMES_SQL);){
            queryStatement.setString(1, storeName);
            try (ResultSet rs = queryStatement.executeQuery();){
                while (rs.next()) {
                    String name = rs.getString(1);
                    if (!predicate.apply((Object)name)) continue;
                    names.add(name);
                }
            }
        }
        catch (SQLException e) {
            throw new IOException(String.format("Could not query table names for store %s", storeName), e);
        }
        return names;
    }

    @Override
    public void createAlias(String storeName, String original, String alias) throws IOException {
        if (!this.exists(storeName, original)) {
            throw new IOException(String.format("State does not exist for table %s", original));
        }
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement cloneStatement = connection.prepareStatement(this.CLONE_JOB_STATE_SQL);){
            int index = 0;
            cloneStatement.setString(++index, alias);
            cloneStatement.setString(++index, storeName);
            cloneStatement.setString(++index, original);
            cloneStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            throw new IOException(String.format("Failure creating alias for store %s original %s", storeName, original), e);
        }
    }

    @Override
    public void delete(String storeName, String tableName) throws IOException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement deleteStatement = connection.prepareStatement(this.DELETE_JOB_STATE_SQL);){
            int index = 0;
            deleteStatement.setString(++index, storeName);
            deleteStatement.setString(++index, tableName);
            deleteStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            throw new IOException("failure deleting storeName " + storeName + " tableName " + tableName, e);
        }
    }

    @Override
    public void delete(String storeName) throws IOException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement deleteStatement = connection.prepareStatement(this.DELETE_JOB_STORE_SQL);){
            deleteStatement.setString(1, storeName);
            deleteStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            throw new IOException("failure deleting storeName " + storeName, e);
        }
    }
}

