/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server;

import com.linkedin.parseq.Engine;
import com.linkedin.parseq.EngineBuilder;
import com.linkedin.r2.filter.FilterChains;
import com.linkedin.r2.transport.common.RestRequestHandler;
import com.linkedin.r2.transport.common.StreamRequestHandler;
import com.linkedin.r2.transport.common.bridge.server.TransportDispatcher;
import com.linkedin.r2.transport.http.server.HttpNettyServerFactory;
import com.linkedin.r2.transport.http.server.HttpServer;
import com.linkedin.restli.docgen.DefaultDocumentationRequestHandler;
import com.linkedin.restli.server.DelegatingTransportDispatcher;
import com.linkedin.restli.server.RestLiConfig;
import com.linkedin.restli.server.RestLiDocumentationRequestHandler;
import com.linkedin.restli.server.RestLiServer;
import com.linkedin.restli.server.resources.PrototypeResourceFactory;
import com.linkedin.restli.server.resources.ResourceFactory;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class NettyStandaloneLauncher {
    private final int _port;
    private final int _threadPoolSize;
    private final int _parseqThreadPoolSize;
    private final String[] _packages;
    private final HttpServer _server;

    public NettyStandaloneLauncher(int port, String ... packages) {
        this(port, 256, NettyStandaloneLauncher.getDefaultParseqThreadPoolSize(), packages);
    }

    public NettyStandaloneLauncher(int port, int threadPoolSize, int parseqThreadPoolSize, String ... packages) {
        this._port = port;
        this._threadPoolSize = threadPoolSize;
        this._parseqThreadPoolSize = parseqThreadPoolSize;
        this._packages = packages;
        RestLiConfig config = new RestLiConfig();
        config.setDocumentationRequestHandler((RestLiDocumentationRequestHandler)new DefaultDocumentationRequestHandler());
        config.setServerNodeUri(URI.create("/"));
        config.addResourcePackageNames(this._packages);
        System.err.println("Netty parseqThreadPoolSize: " + parseqThreadPoolSize);
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(parseqThreadPoolSize);
        Engine engine = new EngineBuilder().setTaskExecutor((Executor)scheduler).setTimerScheduler(scheduler).build();
        RestLiServer restServer = new RestLiServer(config, (ResourceFactory)new PrototypeResourceFactory(), engine);
        DelegatingTransportDispatcher dispatcher = new DelegatingTransportDispatcher((RestRequestHandler)restServer, (StreamRequestHandler)restServer);
        System.err.println("Netty threadPoolSize: " + threadPoolSize);
        this._server = new HttpNettyServerFactory(FilterChains.empty()).createServer(this._port, threadPoolSize, (TransportDispatcher)dispatcher);
    }

    public int getPort() {
        return this._port;
    }

    public int getThreadPoolSize() {
        return this._threadPoolSize;
    }

    public int getParseqThreadPoolSize() {
        return this._parseqThreadPoolSize;
    }

    public String[] getPackages() {
        return this._packages;
    }

    public void start() throws IOException {
        this._server.start();
    }

    public void stop() throws IOException {
        this._server.stop();
    }

    public static void main(String[] args) throws IOException {
        NettyStandaloneLauncher launcher = NettyStandaloneLauncher.configureLauncher(args);
        launcher.start();
        System.out.printf("HttpServer running on port %d. Press any key to stop server", launcher.getPort());
        System.in.read();
        launcher.stop();
    }

    private static int getDefaultParseqThreadPoolSize() {
        int numCores = Runtime.getRuntime().availableProcessors();
        return numCores + 1;
    }

    private static NettyStandaloneLauncher configureLauncher(String ... args) {
        if (args.length < 2) {
            NettyStandaloneLauncher.help();
        }
        int port = 1338;
        String[] packages = null;
        int threadPoolSize = 256;
        int parseqThreadPoolSize = NettyStandaloneLauncher.getDefaultParseqThreadPoolSize();
        for (int i = 0; i < args.length; ++i) {
            boolean hasValueArg;
            boolean bl = hasValueArg = i + 1 < args.length;
            if (args[i].equals("-port")) {
                if (hasValueArg) {
                    try {
                        port = Integer.parseInt(args[i + 1]);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid port number: " + args[i + 1]);
                        NettyStandaloneLauncher.help();
                    }
                    continue;
                }
                System.out.println("Missing port number");
                NettyStandaloneLauncher.help();
                continue;
            }
            if (args[i].equals("-threads")) {
                if (hasValueArg) {
                    try {
                        threadPoolSize = Integer.parseInt(args[i + 1]);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid threads: " + args[i + 1]);
                        NettyStandaloneLauncher.help();
                    }
                    continue;
                }
                System.out.println("Missing thread count");
                NettyStandaloneLauncher.help();
                continue;
            }
            if (args[i].equals("-parseqthreads")) {
                if (hasValueArg) {
                    try {
                        parseqThreadPoolSize = Integer.parseInt(args[i + 1]);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid parseqthreads: " + args[i + 1]);
                        NettyStandaloneLauncher.help();
                    }
                    continue;
                }
                System.out.println("Missing parseqthreads count");
                NettyStandaloneLauncher.help();
                continue;
            }
            if (!args[i].equals("-packages")) continue;
            if (hasValueArg) {
                packages = args[i + 1].split(",");
                continue;
            }
            System.out.println("Missing packages");
        }
        if (packages == null) {
            NettyStandaloneLauncher.help();
        }
        return new NettyStandaloneLauncher(port, threadPoolSize, parseqThreadPoolSize, packages);
    }

    private static void help() {
        System.out.println("Usage: launcher [-port port] [-threads threadPoolSize] [-parseqthreads parseqThreadPoolSize] [-packages package1,package2,...]");
        System.exit(0);
    }
}

