/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.docgen.examplegen;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.generator.DataGenerator;
import com.linkedin.data.schema.generator.SchemaSampleDataGenerator;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DirectArrayTemplate;
import com.linkedin.data.template.DirectMapTemplate;
import com.linkedin.data.template.DynamicRecordMetadata;
import com.linkedin.data.template.FieldDef;
import com.linkedin.data.template.FixedTemplate;
import com.linkedin.data.template.JacksonDataTemplateCodec;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.restli.client.AbstractRequestBuilder;
import com.linkedin.restli.client.ActionRequest;
import com.linkedin.restli.client.ActionRequestBuilder;
import com.linkedin.restli.client.BatchCreateRequest;
import com.linkedin.restli.client.BatchCreateRequestBuilder;
import com.linkedin.restli.client.BatchDeleteRequest;
import com.linkedin.restli.client.BatchDeleteRequestBuilder;
import com.linkedin.restli.client.BatchGetKVRequest;
import com.linkedin.restli.client.BatchGetRequestBuilder;
import com.linkedin.restli.client.BatchPartialUpdateRequest;
import com.linkedin.restli.client.BatchPartialUpdateRequestBuilder;
import com.linkedin.restli.client.BatchUpdateRequest;
import com.linkedin.restli.client.BatchUpdateRequestBuilder;
import com.linkedin.restli.client.CreateRequest;
import com.linkedin.restli.client.CreateRequestBuilder;
import com.linkedin.restli.client.DeleteRequest;
import com.linkedin.restli.client.DeleteRequestBuilder;
import com.linkedin.restli.client.FindRequest;
import com.linkedin.restli.client.FindRequestBuilder;
import com.linkedin.restli.client.GetAllRequest;
import com.linkedin.restli.client.GetAllRequestBuilder;
import com.linkedin.restli.client.GetRequest;
import com.linkedin.restli.client.GetRequestBuilder;
import com.linkedin.restli.client.OptionsRequest;
import com.linkedin.restli.client.OptionsRequestBuilder;
import com.linkedin.restli.client.PartialUpdateRequest;
import com.linkedin.restli.client.PartialUpdateRequestBuilder;
import com.linkedin.restli.client.Request;
import com.linkedin.restli.client.RestfulRequestBuilder;
import com.linkedin.restli.client.RestliRequestOptions;
import com.linkedin.restli.client.UpdateRequest;
import com.linkedin.restli.client.UpdateRequestBuilder;
import com.linkedin.restli.client.uribuilders.RestliUriBuilderUtil;
import com.linkedin.restli.client.util.PatchGenerator;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.HttpMethod;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.common.ResourceSpec;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.restli.common.util.ResourceSchemaToResourceSpecTranslator;
import com.linkedin.restli.common.util.RichResourceSchema;
import com.linkedin.restli.docgen.examplegen.ExampleGenerationException;
import com.linkedin.restli.docgen.examplegen.ExampleRequestResponse;
import com.linkedin.restli.internal.client.RequestBodyTransformer;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.server.ResourceContextImpl;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.ServerResourceContext;
import com.linkedin.restli.internal.server.model.ResourceMethodDescriptor;
import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.internal.server.response.RestLiResponseHandler;
import com.linkedin.restli.internal.server.util.RestLiSyntaxException;
import com.linkedin.restli.internal.server.util.RestUtils;
import com.linkedin.restli.restspec.ActionSchema;
import com.linkedin.restli.restspec.FinderSchema;
import com.linkedin.restli.restspec.ParameterSchema;
import com.linkedin.restli.restspec.ParameterSchemaArray;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.restspec.RestMethodSchema;
import com.linkedin.restli.restspec.RestSpecCodec;
import com.linkedin.restli.server.ActionResult;
import com.linkedin.restli.server.BatchCreateResult;
import com.linkedin.restli.server.BatchResult;
import com.linkedin.restli.server.BatchUpdateResult;
import com.linkedin.restli.server.CollectionResult;
import com.linkedin.restli.server.CreateResponse;
import com.linkedin.restli.server.ResourceContext;
import com.linkedin.restli.server.ResourceLevel;
import com.linkedin.restli.server.UpdateResponse;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExampleRequestResponseGenerator {
    private static final ResourceSchemaToResourceSpecTranslator.ClassBindingResolver BINDING_RESOLVER = new ExampleGeneratorClassBindingResolver();
    private static final JacksonDataTemplateCodec CODEC = new JacksonDataTemplateCodec();
    private final RestliRequestOptions _requestOptions;
    private final RichResourceSchema _resourceSchema;
    private final ResourceSpec _resourceSpec;
    private final ResourceModel _resourceModel;
    private final Map<ResourceSchema, ResourceSpec> _parentResources;
    private final DataSchemaResolver _schemaResolver;
    private final DataGenerator _dataGenerator;
    private final RestLiResponseHandler _responseHandler = new RestLiResponseHandler.Builder().build();
    private final String _uriTemplate;

    public ExampleRequestResponseGenerator(ResourceSchema resourceSchema, DataSchemaResolver schemaResolver) {
        this(Collections.emptyList(), resourceSchema, schemaResolver);
    }

    public ExampleRequestResponseGenerator(ResourceSchema resourceSchema, DataSchemaResolver schemaResolver, DataGenerator dataGenerator, RestliRequestOptions requestOptions) {
        this(Collections.emptyList(), resourceSchema, schemaResolver, dataGenerator, requestOptions);
    }

    public ExampleRequestResponseGenerator(List<ResourceSchema> parentResourceSchemas, ResourceSchema resourceSchema, DataSchemaResolver schemaResolver) {
        this(parentResourceSchemas, resourceSchema, schemaResolver, (DataGenerator)new SchemaSampleDataGenerator(schemaResolver, new SchemaSampleDataGenerator.DataGenerationOptions()), RestliRequestOptions.DEFAULT_OPTIONS);
    }

    public ExampleRequestResponseGenerator(List<ResourceSchema> parentResourceSpecs, ResourceSchema resourceSchema, DataSchemaResolver schemaResolver, DataGenerator dataGenerator, RestliRequestOptions requestOptions) {
        this._requestOptions = requestOptions;
        this._parentResources = ExampleRequestResponseGenerator.translate(parentResourceSpecs, schemaResolver);
        this._resourceSchema = new RichResourceSchema(resourceSchema);
        this._resourceSpec = ExampleRequestResponseGenerator.translate(resourceSchema, schemaResolver);
        this._resourceModel = ExampleRequestResponseGenerator.buildPlaceholderResourceModel(resourceSchema);
        this._uriTemplate = this._resourceSchema.getResourceSchema().getPath();
        this._schemaResolver = schemaResolver;
        this._dataGenerator = dataGenerator;
    }

    public ExampleRequestResponse method(ResourceMethod method) {
        switch (method) {
            case OPTIONS: {
                return this.options();
            }
            case GET_ALL: {
                return this.getAll();
            }
            case GET: {
                return this.get();
            }
            case CREATE: {
                return this.create();
            }
            case UPDATE: {
                return this.update();
            }
            case PARTIAL_UPDATE: {
                return this.partialUpdate();
            }
            case DELETE: {
                return this.delete();
            }
            case BATCH_GET: {
                return this.batchGet();
            }
            case BATCH_CREATE: {
                return this.batchCreate();
            }
            case BATCH_UPDATE: {
                return this.batchUpdate();
            }
            case BATCH_PARTIAL_UPDATE: {
                return this.batchPartialUpdate();
            }
            case BATCH_DELETE: {
                return this.batchDelete();
            }
        }
        throw new IllegalArgumentException("Unrecognized ResourceMethod value requested, this method only supports core restful methods, finder and action not supported (for those, use finder() or action()).  for method:" + method);
    }

    public ExampleRequestResponse finder(String name) {
        FinderSchema finderSchema = this._resourceSchema.getFinder(name);
        if (finderSchema == null) {
            throw new IllegalArgumentException("No such finder for resource: " + name);
        }
        RecordDataSchema metadataSchema = null;
        if (finderSchema.hasMetadata()) {
            metadataSchema = (RecordDataSchema)RestSpecCodec.textToSchema((String)finderSchema.getMetadata().getType(), (DataSchemaResolver)this._schemaResolver);
        }
        return this.buildRequestResponse((Request<?>)this.buildFinderRequest(finderSchema), this.buildFinderResult(metadataSchema), ExampleRequestResponseGenerator.buildResourceMethodDescriptorForFinder(name));
    }

    public ExampleRequestResponse action(String name, ResourceLevel resourceLevel) {
        ActionSchema actionSchema;
        switch (resourceLevel) {
            case COLLECTION: {
                actionSchema = this._resourceSchema.getAction(name);
                break;
            }
            case ENTITY: {
                actionSchema = this._resourceSchema.getEntityAction(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported resourceLevel: " + resourceLevel);
            }
        }
        if (actionSchema == null) {
            throw new IllegalArgumentException("No such action for resource: " + name);
        }
        DynamicRecordMetadata returnsMetadata = this._resourceSpec.getActionResponseMetadata(name);
        return this.buildRequestResponse((Request<?>)this.buildActionRequest(actionSchema, resourceLevel), this.buildActionResult(actionSchema), ExampleRequestResponseGenerator.buildResourceMethodDescriptorForAction(name, returnsMetadata, resourceLevel));
    }

    public ExampleRequestResponse options() {
        OptionsRequest request = new OptionsRequestBuilder(this._uriTemplate, this._requestOptions).build();
        return this.buildRequestResponse((Request<?>)request, this._resourceSchema, ExampleRequestResponseGenerator.buildResourceMethodDescriptorForRestMethod(request));
    }

    public ExampleRequestResponse getAll() {
        this.checkSupports(ResourceMethod.GET_ALL);
        GetAllRequestBuilder getAll = new GetAllRequestBuilder(this._uriTemplate, RecordTemplatePlaceholder.class, this._resourceSpec, this._requestOptions);
        this.addParams((RestfulRequestBuilder<?, ?, ?>)getAll, ResourceMethod.GET_ALL);
        this.addPathKeys((AbstractRequestBuilder<?, ?, ?>)getAll);
        GetAllRequest request = getAll.build();
        return this.buildRequestResponse((Request<?>)request, this.buildFinderResult(null), ExampleRequestResponseGenerator.buildResourceMethodDescriptorForFinder("getAll"));
    }

    public ExampleRequestResponse get() {
        this.checkSupports(ResourceMethod.GET);
        GetRequestBuilder get = new GetRequestBuilder(this._uriTemplate, RecordTemplatePlaceholder.class, this._resourceSpec, this._requestOptions);
        if (this._resourceSpec.getKeyType() != null) {
            get.id(this.generateKey());
        }
        this.addParams((RestfulRequestBuilder<?, ?, ?>)get, ResourceMethod.GET);
        this.addPathKeys((AbstractRequestBuilder<?, ?, ?>)get);
        GetRequest request = get.build();
        return this.buildRequestResponse((Request<?>)request, (Object)this.generateEntity(), ExampleRequestResponseGenerator.buildResourceMethodDescriptorForRestMethod(request));
    }

    public ExampleRequestResponse create() {
        this.checkSupports(ResourceMethod.CREATE);
        CreateRequestBuilder create = new CreateRequestBuilder(this._uriTemplate, RecordTemplatePlaceholder.class, this._resourceSpec, this._requestOptions);
        create.input((RecordTemplate)this.generateEntity());
        this.addParams((RestfulRequestBuilder<?, ?, ?>)create, ResourceMethod.CREATE);
        this.addPathKeys((AbstractRequestBuilder<?, ?, ?>)create);
        CreateRequest request = create.build();
        return this.buildRequestResponse((Request<?>)request, new CreateResponse(this.generateKey(), HttpStatus.S_201_CREATED), ExampleRequestResponseGenerator.buildResourceMethodDescriptorForRestMethod(request));
    }

    public ExampleRequestResponse update() {
        this.checkSupports(ResourceMethod.UPDATE);
        UpdateRequestBuilder update = new UpdateRequestBuilder(this._uriTemplate, RecordTemplatePlaceholder.class, this._resourceSpec, this._requestOptions);
        if (this._resourceSpec.getKeyType() != null) {
            update.id(this.generateKey());
        }
        update.input((RecordTemplate)this.generateEntity());
        this.addParams((RestfulRequestBuilder<?, ?, ?>)update, ResourceMethod.UPDATE);
        this.addPathKeys((AbstractRequestBuilder<?, ?, ?>)update);
        UpdateRequest request = update.build();
        return this.buildRequestResponse((Request<?>)request, new UpdateResponse(HttpStatus.S_200_OK), ExampleRequestResponseGenerator.buildResourceMethodDescriptorForRestMethod(request));
    }

    public ExampleRequestResponse partialUpdate() {
        this.checkSupports(ResourceMethod.PARTIAL_UPDATE);
        PartialUpdateRequestBuilder update = new PartialUpdateRequestBuilder(this._uriTemplate, RecordTemplatePlaceholder.class, this._resourceSpec, this._requestOptions);
        if (this._resourceSpec.getKeyType() != null) {
            update.id(this.generateKey());
        }
        update.input(PatchGenerator.diffEmpty((RecordTemplate)this.generateEntity()));
        this.addParams((RestfulRequestBuilder<?, ?, ?>)update, ResourceMethod.PARTIAL_UPDATE);
        this.addPathKeys((AbstractRequestBuilder<?, ?, ?>)update);
        PartialUpdateRequest request = update.build();
        return this.buildRequestResponse((Request<?>)request, new UpdateResponse(HttpStatus.S_200_OK), ExampleRequestResponseGenerator.buildResourceMethodDescriptorForRestMethod(request));
    }

    public ExampleRequestResponse delete() {
        this.checkSupports(ResourceMethod.DELETE);
        DeleteRequestBuilder delete = new DeleteRequestBuilder(this._uriTemplate, RecordTemplatePlaceholder.class, this._resourceSpec, this._requestOptions);
        if (this._resourceSpec.getKeyType() != null) {
            delete.id(this.generateKey());
        }
        this.addParams((RestfulRequestBuilder<?, ?, ?>)delete, ResourceMethod.DELETE);
        this.addPathKeys((AbstractRequestBuilder<?, ?, ?>)delete);
        DeleteRequest request = delete.build();
        return this.buildRequestResponse((Request<?>)request, new UpdateResponse(HttpStatus.S_200_OK), ExampleRequestResponseGenerator.buildResourceMethodDescriptorForRestMethod(request));
    }

    public ExampleRequestResponse batchGet() {
        this.checkSupports(ResourceMethod.BATCH_GET);
        BatchGetRequestBuilder batchGet = new BatchGetRequestBuilder(this._uriTemplate, RecordTemplatePlaceholder.class, this._resourceSpec, this._requestOptions);
        Object id1 = this.generateKey(0);
        Object id2 = this.generateKey(1);
        batchGet.ids(new Object[]{id1, id2});
        this.addParams((RestfulRequestBuilder<?, ?, ?>)batchGet, ResourceMethod.BATCH_GET);
        this.addPathKeys((AbstractRequestBuilder<?, ?, ?>)batchGet);
        BatchGetKVRequest request = batchGet.buildKV();
        HashMap<Object, RecordTemplatePlaceholder> bgResponseData = new HashMap<Object, RecordTemplatePlaceholder>();
        bgResponseData.put(id1, this.generateEntity());
        bgResponseData.put(id2, this.generateEntity());
        BatchResult result = new BatchResult(bgResponseData, new HashMap());
        return this.buildRequestResponse((Request<?>)request, result, ExampleRequestResponseGenerator.buildResourceMethodDescriptorForRestMethod(request));
    }

    public ExampleRequestResponse batchCreate() {
        this.checkSupports(ResourceMethod.BATCH_CREATE);
        BatchCreateRequestBuilder create = new BatchCreateRequestBuilder(this._uriTemplate, RecordTemplatePlaceholder.class, this._resourceSpec, this._requestOptions);
        create.input((RecordTemplate)this.generateEntity());
        create.input((RecordTemplate)this.generateEntity());
        this.addParams((RestfulRequestBuilder<?, ?, ?>)create, ResourceMethod.BATCH_CREATE);
        this.addPathKeys((AbstractRequestBuilder<?, ?, ?>)create);
        BatchCreateRequest request = create.build();
        BatchCreateResult result = new BatchCreateResult(Arrays.asList(new CreateResponse(this.generateKey(), HttpStatus.S_201_CREATED), new CreateResponse(this.generateKey(), HttpStatus.S_201_CREATED)));
        return this.buildRequestResponse((Request<?>)request, result, ExampleRequestResponseGenerator.buildResourceMethodDescriptorForRestMethod(request));
    }

    public ExampleRequestResponse batchUpdate() {
        this.checkSupports(ResourceMethod.BATCH_UPDATE);
        BatchUpdateRequestBuilder update = new BatchUpdateRequestBuilder(this._uriTemplate, RecordTemplatePlaceholder.class, this._resourceSpec, this._requestOptions);
        Object id1 = this.generateKey(0);
        Object id2 = this.generateKey(1);
        update.input(id1, (RecordTemplate)this.generateEntity());
        update.input(id2, (RecordTemplate)this.generateEntity());
        this.addParams((RestfulRequestBuilder<?, ?, ?>)update, ResourceMethod.BATCH_UPDATE);
        this.addPathKeys((AbstractRequestBuilder<?, ?, ?>)update);
        BatchUpdateRequest request = update.build();
        return this.buildRequestResponse((Request<?>)request, this.createBatchUpdateResult(id1, id2), ExampleRequestResponseGenerator.buildResourceMethodDescriptorForRestMethod(request));
    }

    private BatchUpdateResult<Object, RecordTemplatePlaceholder> createBatchUpdateResult(Object id1, Object id2) {
        HashMap<Object, UpdateResponse> buResponseData = new HashMap<Object, UpdateResponse>();
        buResponseData.put(id1, new UpdateResponse(HttpStatus.S_200_OK));
        buResponseData.put(id2, new UpdateResponse(HttpStatus.S_200_OK));
        return new BatchUpdateResult(buResponseData);
    }

    public ExampleRequestResponse batchPartialUpdate() {
        this.checkSupports(ResourceMethod.BATCH_PARTIAL_UPDATE);
        BatchPartialUpdateRequestBuilder update = new BatchPartialUpdateRequestBuilder(this._uriTemplate, RecordTemplatePlaceholder.class, this._resourceSpec, this._requestOptions);
        Object id1 = this.generateKey(0);
        Object id2 = this.generateKey(1);
        update.input(id1, PatchGenerator.diffEmpty((RecordTemplate)this.generateEntity()));
        update.input(id2, PatchGenerator.diffEmpty((RecordTemplate)this.generateEntity()));
        this.addParams((RestfulRequestBuilder<?, ?, ?>)update, ResourceMethod.BATCH_PARTIAL_UPDATE);
        this.addPathKeys((AbstractRequestBuilder<?, ?, ?>)update);
        BatchPartialUpdateRequest request = update.build();
        return this.buildRequestResponse((Request<?>)request, this.createBatchUpdateResult(id1, id2), ExampleRequestResponseGenerator.buildResourceMethodDescriptorForRestMethod(request));
    }

    public ExampleRequestResponse batchDelete() {
        this.checkSupports(ResourceMethod.BATCH_DELETE);
        BatchDeleteRequestBuilder delete = new BatchDeleteRequestBuilder(this._uriTemplate, RecordTemplatePlaceholder.class, this._resourceSpec, this._requestOptions);
        Object id1 = this.generateKey(0);
        Object id2 = this.generateKey(1);
        delete.ids(new Object[]{id1, id2});
        this.addParams((RestfulRequestBuilder<?, ?, ?>)delete, ResourceMethod.BATCH_DELETE);
        this.addPathKeys((AbstractRequestBuilder<?, ?, ?>)delete);
        BatchDeleteRequest request = delete.build();
        HashMap<Object, UpdateResponse> bdResponseData = new HashMap<Object, UpdateResponse>();
        bdResponseData.put(id1, new UpdateResponse(HttpStatus.S_200_OK));
        bdResponseData.put(id2, new UpdateResponse(HttpStatus.S_200_OK));
        BatchUpdateResult result = new BatchUpdateResult(bdResponseData);
        return this.buildRequestResponse((Request<?>)request, result, ExampleRequestResponseGenerator.buildResourceMethodDescriptorForRestMethod(request));
    }

    private ExampleRequestResponse buildRequestResponse(Request<?> request, Object responseEntity, ResourceMethodDescriptor method) {
        RestRequest restRequest = this.buildRequest(request);
        RestResponse restResponse = this.buildResponse(responseEntity, method, restRequest);
        return new ExampleRequestResponse(restRequest, restResponse);
    }

    private RestRequest buildRequest(Request<?> request) {
        ProtocolVersion protocolVersion;
        switch (this._requestOptions.getProtocolVersionOption()) {
            case FORCE_USE_LATEST: {
                protocolVersion = AllProtocolVersions.LATEST_PROTOCOL_VERSION;
                break;
            }
            case USE_LATEST_IF_AVAILABLE: {
                protocolVersion = AllProtocolVersions.BASELINE_PROTOCOL_VERSION;
                break;
            }
            case FORCE_USE_NEXT: {
                protocolVersion = AllProtocolVersions.NEXT_PROTOCOL_VERSION;
                break;
            }
            case FORCE_USE_PREVIOUS: {
                protocolVersion = AllProtocolVersions.PREVIOUS_PROTOCOL_VERSION;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported enum value: " + this._requestOptions.getProtocolVersionOption());
            }
        }
        URI uri = RestliUriBuilderUtil.createUriBuilder(request, (String)"", (ProtocolVersion)protocolVersion).build();
        RestRequestBuilder requestBuilder = new RestRequestBuilder(uri);
        requestBuilder.setMethod(request.getMethod().getHttpMethod().name());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("X-RestLi-Protocol-Version", protocolVersion.toString());
        if (request.getMethod().getHttpMethod() == HttpMethod.POST) {
            requestBuilder.setHeader("X-RestLi-Method", request.getMethod().toString());
        }
        if (request.getInputRecord() != null) {
            requestBuilder.setHeader("Content-Type", "application/json");
            ExampleRequestResponseGenerator.writeEntity(request, protocolVersion, requestBuilder);
        }
        return requestBuilder.build();
    }

    private static void writeEntity(Request<?> request, ProtocolVersion protocolVersion, RestRequestBuilder messageBuilder) {
        try {
            DataMap dataMap = RequestBodyTransformer.transform(request, (ProtocolVersion)protocolVersion);
            messageBuilder.setEntity(CODEC.mapToBytes(dataMap));
        }
        catch (IOException e) {
            throw new ExampleGenerationException("Unable to serializing data", e);
        }
    }

    private RestResponse buildResponse(Object responseEntity, ResourceMethodDescriptor method, RestRequest restRequest) {
        try {
            ResourceContextImpl context = new ResourceContextImpl();
            RestUtils.validateRequestHeadersAndUpdateResourceContext(Collections.emptyMap(), (ServerResourceContext)context);
            method.setResourceModel(this._resourceModel);
            RoutingResult routingResult = new RoutingResult((ResourceContext)context, method);
            return this._responseHandler.buildResponse(restRequest, routingResult, responseEntity);
        }
        catch (RestLiSyntaxException e) {
            throw new ExampleGenerationException("Internal error during example generation", e);
        }
        catch (IOException e) {
            throw new ExampleGenerationException("Unable to build example response", e);
        }
    }

    private void checkSupports(ResourceMethod method) throws IllegalArgumentException {
        if (!this._resourceSpec.getSupportedMethods().contains(method)) {
            throw new IllegalArgumentException(method + " not supported for resource.");
        }
    }

    private FindRequest<RecordTemplatePlaceholder> buildFinderRequest(FinderSchema finderSchema) {
        FindRequestBuilder finder = new FindRequestBuilder(this._uriTemplate, RecordTemplatePlaceholder.class, this._resourceSpec, this._requestOptions);
        finder.name(finderSchema.getName());
        if (finderSchema.hasAssocKeys()) {
            CompoundKey key = (CompoundKey)this.generateKey();
            for (String partKey : finderSchema.getAssocKeys()) {
                finder.assocKey(partKey, key.getPart(partKey));
            }
        } else if (finderSchema.hasAssocKey()) {
            String partKey = finderSchema.getAssocKey();
            CompoundKey key = (CompoundKey)this.generateKey();
            finder.assocKey(partKey, key.getPart(partKey));
        }
        if (finderSchema.hasParameters() && !finderSchema.getParameters().isEmpty()) {
            this.addParams((RestfulRequestBuilder<?, ?, ?>)finder, finderSchema.getParameters());
        }
        this.addPathKeys((AbstractRequestBuilder<?, ?, ?>)finder);
        return finder.build();
    }

    private CollectionResult<RecordTemplatePlaceholder, RecordTemplatePlaceholder> buildFinderResult(RecordDataSchema finderMetadataSchema) {
        ArrayList<RecordTemplatePlaceholder> results = new ArrayList<RecordTemplatePlaceholder>();
        results.add(this.generateEntity());
        results.add(this.generateEntity());
        if (finderMetadataSchema != null) {
            DataMap metadataDataMap = (DataMap)this._dataGenerator.buildData("metadata", (DataSchema)finderMetadataSchema);
            RecordTemplatePlaceholder metadata = new RecordTemplatePlaceholder(metadataDataMap, finderMetadataSchema);
            return new CollectionResult(results, Integer.valueOf(results.size()), (RecordTemplate)metadata);
        }
        return new CollectionResult(results);
    }

    private ActionRequest<?> buildActionRequest(ActionSchema action, ResourceLevel resourceLevel) {
        FieldDef fieldDef;
        DynamicRecordMetadata requestParamsMetadata = this._resourceSpec.getRequestMetadata(action.getName());
        DynamicRecordMetadata responseMetadata = this._resourceSpec.getActionResponseMetadata(action.getName());
        TypeSpec responseType = null;
        if (responseMetadata != null && (fieldDef = responseMetadata.getFieldDef("value")) != null && fieldDef.getDataClass() != null) {
            responseType = new TypeSpec(fieldDef.getDataClass(), (DataSchema)responseMetadata.getRecordDataSchema());
        }
        ActionRequestBuilder request = new ActionRequestBuilder(this._uriTemplate, responseType, this._resourceSpec, this._requestOptions);
        request.name(action.getName());
        if (resourceLevel == ResourceLevel.ENTITY && !this._resourceSpec.isKeylessResource()) {
            request.id(this.generateKey());
        }
        if (requestParamsMetadata != null) {
            this.addParams(request, requestParamsMetadata, action.getParameters());
        }
        this.addPathKeys((AbstractRequestBuilder<?, ?, ?>)request);
        return request.build();
    }

    private ActionResult<?> buildActionResult(ActionSchema actionSchema) {
        DynamicRecordMetadata returnsMetadata = this._resourceSpec.getActionResponseMetadata(actionSchema.getName());
        if (actionSchema.hasReturns()) {
            FieldDef fieldDef = returnsMetadata.getFieldDef("value");
            Object returnValue = this.generateFieldDefValue(fieldDef);
            return new ActionResult(returnValue);
        }
        return null;
    }

    private static ResourceMethodDescriptor buildResourceMethodDescriptorForAction(String name, DynamicRecordMetadata returnsMetadata, ResourceLevel resourceLevel) {
        return ResourceMethodDescriptor.createForAction(null, null, (String)name, (ResourceLevel)resourceLevel, (FieldDef)(returnsMetadata == null ? null : returnsMetadata.getFieldDef("value")), (RecordDataSchema)returnsMetadata.getRecordDataSchema(), null, null, null);
    }

    private static ResourceMethodDescriptor buildResourceMethodDescriptorForRestMethod(Request<?> request) {
        return ResourceMethodDescriptor.createForRestful((ResourceMethod)request.getMethod(), null, null);
    }

    private static ResourceMethodDescriptor buildResourceMethodDescriptorForFinder(String name) {
        return ResourceMethodDescriptor.createForFinder(null, Collections.emptyList(), (String)name, RecordTemplatePlaceholder.class, null, null);
    }

    private void addParams(RestfulRequestBuilder<?, ?, ?> builder, ResourceMethod method) {
        RestMethodSchema methodSchema = this._resourceSchema.getMethod(method.toString().toLowerCase());
        ParameterSchemaArray parameters = methodSchema.getParameters();
        this.addParams(builder, parameters);
    }

    private void addPathKeys(AbstractRequestBuilder<?, ?, ?> builder) {
        block5: for (Map.Entry<ResourceSchema, ResourceSpec> entry : this._parentResources.entrySet()) {
            ResourceSchema resourceSchema = entry.getKey();
            ResourceSpec resourceSpec = entry.getValue();
            if (resourceSpec.getKeyType() == null) continue;
            switch (ExampleRequestResponseGenerator.toResourceKeyType(resourceSpec.getKeyType().getType())) {
                case PRIMITIVE: 
                case COMPLEX: {
                    String keyName = resourceSchema.getCollection().getIdentifier().getName();
                    builder.pathKey(keyName, this.generateKey(resourceSpec, resourceSchema, null));
                    continue block5;
                }
                case COMPOUND: {
                    Map keyParts = resourceSpec.getKeyParts();
                    for (Map.Entry infoEntry : keyParts.entrySet()) {
                        String key = (String)infoEntry.getKey();
                        CompoundKey.TypeInfo typeInfo = (CompoundKey.TypeInfo)infoEntry.getValue();
                        builder.pathKey(key, this._dataGenerator.buildData(key, typeInfo.getBinding().getSchema()));
                    }
                    String assocKeyName = resourceSchema.getAssociation().getIdentifier();
                    builder.pathKey(assocKeyName, this.generateKey(resourceSpec, resourceSchema, null));
                    continue block5;
                }
                case NONE: {
                    continue block5;
                }
            }
            throw new IllegalStateException("Unrecognized key type: " + resourceSpec.getKeyType().getType());
        }
    }

    private void addParams(RestfulRequestBuilder<?, ?, ?> builder, ParameterSchemaArray parameters) {
        if (parameters != null) {
            for (ParameterSchema parameter : parameters) {
                if (parameter.hasItems()) continue;
                DataSchema dataSchema = RestSpecCodec.textToSchema((String)parameter.getType(), (DataSchemaResolver)this._schemaResolver);
                Object value = this._dataGenerator.buildData(parameter.getName(), dataSchema);
                builder.setParam(parameter.getName(), value);
            }
        }
    }

    private void addParams(ActionRequestBuilder<?, ?> request, DynamicRecordMetadata requestMetadata, ParameterSchemaArray parameters) {
        if (parameters != null) {
            for (ParameterSchema parameter : parameters) {
                FieldDef fieldDef = requestMetadata.getFieldDef(parameter.getName());
                Object value = this.generateFieldDefValue(fieldDef);
                if (fieldDef.getDataSchema().getType() == DataSchema.Type.TYPEREF) {
                    FieldDef deRefFieldDef = new FieldDef(fieldDef.getName(), fieldDef.getDataClass(), fieldDef.getDataSchema().getDereferencedDataSchema());
                    deRefFieldDef.getField().setRecord(fieldDef.getField().getRecord());
                    fieldDef = deRefFieldDef;
                }
                request.setParam(fieldDef, value);
            }
        }
    }

    private Object generateFieldDefValue(FieldDef<?> fieldDef) {
        Object value = this._dataGenerator.buildData(fieldDef.getName(), fieldDef.getDataSchema());
        DataSchema dereferencedDataSchema = fieldDef.getDataSchema().getDereferencedDataSchema();
        if (!dereferencedDataSchema.isPrimitive()) {
            switch (dereferencedDataSchema.getType()) {
                case FIXED: {
                    value = new FixedTemplatePlaceholder(value, (FixedDataSchema)dereferencedDataSchema);
                    break;
                }
                case ENUM: {
                    break;
                }
                case ARRAY: {
                    value = new ArrayTemplatePlaceholder<Object>((DataList)value, (ArrayDataSchema)dereferencedDataSchema, Object.class);
                    break;
                }
                case RECORD: {
                    value = new RecordTemplatePlaceholder((DataMap)value, (RecordDataSchema)dereferencedDataSchema);
                    break;
                }
                case MAP: {
                    value = new MapTemplatePlaceholder<Object>((DataMap)value, (MapDataSchema)dereferencedDataSchema, Object.class);
                    break;
                }
                case UNION: {
                    value = new UnionTemplatePlaceholder(value, (UnionDataSchema)dereferencedDataSchema);
                    break;
                }
                case TYPEREF: {
                    throw new IllegalStateException("TYPEREF should not be returned for a dereferenced byte. schema: " + fieldDef.getDataSchema());
                }
                default: {
                    throw new IllegalStateException("Unrecognized enum value: " + dereferencedDataSchema.getType());
                }
            }
        }
        return value;
    }

    private Object generateKey() {
        return this.generateKey(null);
    }

    private Object generateKey(Integer batchIdx) {
        return this.generateKey(this._resourceSpec, this._resourceSchema.getResourceSchema(), batchIdx);
    }

    private Object generateKey(ResourceSpec resourceSpec, ResourceSchema resourceSchema, Integer batchIdx) {
        if (resourceSpec.getKeyType() == null) {
            throw new IllegalArgumentException("Cannot generate key for keyless resource.");
        }
        switch (ExampleRequestResponseGenerator.toResourceKeyType(resourceSpec.getKeyType().getType())) {
            case COMPLEX: {
                RecordDataSchema keySchema = (RecordDataSchema)resourceSpec.getComplexKeyType().getKeyType().getSchema();
                DataMap keyData = (DataMap)this._dataGenerator.buildData(ExampleRequestResponseGenerator.postfixBatchIdx(keySchema.getName() + "Key", batchIdx), (DataSchema)keySchema);
                RecordDataSchema paramsSchema = (RecordDataSchema)resourceSpec.getComplexKeyType().getParamsType().getSchema();
                DataMap paramsData = (DataMap)this._dataGenerator.buildData(ExampleRequestResponseGenerator.postfixBatchIdx(keySchema.getName() + "Params", batchIdx), (DataSchema)paramsSchema);
                return new ComplexResourceKey((RecordTemplate)new RecordTemplatePlaceholder(keyData, keySchema), (RecordTemplate)new RecordTemplatePlaceholder(paramsData, paramsSchema));
            }
            case COMPOUND: {
                CompoundKey compoundKey = new CompoundKey();
                for (Map.Entry keyPart : resourceSpec.getKeyParts().entrySet()) {
                    String key = (String)keyPart.getKey();
                    CompoundKey.TypeInfo typeInfo = (CompoundKey.TypeInfo)keyPart.getValue();
                    compoundKey.append(key, this._dataGenerator.buildData(ExampleRequestResponseGenerator.postfixBatchIdx(key, batchIdx), typeInfo.getBinding().getSchema()));
                }
                return compoundKey;
            }
            case PRIMITIVE: {
                String keyName = resourceSchema.getCollection().getIdentifier().getName();
                return this._dataGenerator.buildData(ExampleRequestResponseGenerator.postfixBatchIdx(keyName, batchIdx), resourceSpec.getKeyType().getSchema());
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalStateException("Unknown enum value: " + resourceSpec.getKeyType().getType());
    }

    private static String postfixBatchIdx(String input, Integer batchIdx) {
        if (batchIdx == null) {
            return input;
        }
        return input + batchIdx;
    }

    private RecordTemplatePlaceholder generateEntity() {
        RecordDataSchema inputSchema = (RecordDataSchema)this._resourceSpec.getValueType().getSchema();
        DataMap inputData = (DataMap)this._dataGenerator.buildData("entity", (DataSchema)inputSchema);
        return new RecordTemplatePlaceholder(inputData, inputSchema);
    }

    private static ResourceKeyType toResourceKeyType(Class<?> type) {
        if (ComplexResourceKey.class == type) {
            return ResourceKeyType.COMPLEX;
        }
        if (CompoundKey.class.isAssignableFrom(type)) {
            return ResourceKeyType.COMPOUND;
        }
        if (Void.class == type) {
            return ResourceKeyType.NONE;
        }
        return ResourceKeyType.PRIMITIVE;
    }

    private static ResourceSpec translate(ResourceSchema resourceSchema, DataSchemaResolver schemaResolver) {
        return new ResourceSchemaToResourceSpecTranslator(schemaResolver, BINDING_RESOLVER).translate(resourceSchema);
    }

    private static Map<ResourceSchema, ResourceSpec> translate(List<ResourceSchema> resourceSchemas, DataSchemaResolver schemaResolver) {
        HashMap<ResourceSchema, ResourceSpec> result = new HashMap<ResourceSchema, ResourceSpec>();
        for (ResourceSchema resourceSchema : resourceSchemas) {
            result.put(resourceSchema, ExampleRequestResponseGenerator.translate(resourceSchema, schemaResolver));
        }
        return result;
    }

    private static ResourceModel buildPlaceholderResourceModel(ResourceSchema resourceSchema) {
        return new ResourceModel(RecordTemplatePlaceholder.class, Object.class, null, resourceSchema.getName(), null, resourceSchema.getNamespace());
    }

    public static class FixedTemplatePlaceholder
    extends FixedTemplate {
        public FixedTemplatePlaceholder(Object object) throws TemplateOutputCastException {
            super(object, null);
        }

        public FixedTemplatePlaceholder(Object object, FixedDataSchema schema) throws TemplateOutputCastException {
            super(object, schema);
        }
    }

    public static class MapTemplatePlaceholder<V>
    extends DirectMapTemplate<V> {
        public MapTemplatePlaceholder(DataMap map) {
            super(map, null, null);
        }

        public MapTemplatePlaceholder(DataMap map, MapDataSchema schema, Class<V> valueClass) {
            super(map, schema, valueClass);
        }
    }

    public static class ArrayTemplatePlaceholder<E>
    extends DirectArrayTemplate<E> {
        public ArrayTemplatePlaceholder(DataList list) {
            super(list, null, null);
        }

        public ArrayTemplatePlaceholder(DataList list, ArrayDataSchema schema, Class<E> elementClass) {
            super(list, schema, elementClass);
        }
    }

    public static class UnionTemplatePlaceholder
    extends UnionTemplate {
        public UnionTemplatePlaceholder(Object object) throws TemplateOutputCastException {
            super(object, null);
        }

        public UnionTemplatePlaceholder(Object object, UnionDataSchema schema) throws TemplateOutputCastException {
            super(object, schema);
        }
    }

    public static class RecordTemplatePlaceholder
    extends RecordTemplate {
        public RecordTemplatePlaceholder(DataMap object) throws TemplateOutputCastException {
            super(object, null);
        }

        public RecordTemplatePlaceholder(DataMap object, RecordDataSchema schema) throws TemplateOutputCastException {
            super(object, schema);
        }
    }

    private static class ExampleGeneratorClassBindingResolver
    implements ResourceSchemaToResourceSpecTranslator.ClassBindingResolver {
        private ExampleGeneratorClassBindingResolver() {
        }

        public Class<? extends DataTemplate> resolveTemplateClass(DataSchema schema) {
            switch (schema.getDereferencedType()) {
                case FIXED: {
                    return FixedTemplatePlaceholder.class;
                }
                case ARRAY: {
                    return ArrayTemplatePlaceholder.class;
                }
                case RECORD: {
                    return RecordTemplatePlaceholder.class;
                }
                case MAP: {
                    return MapTemplatePlaceholder.class;
                }
                case UNION: {
                    return UnionTemplatePlaceholder.class;
                }
                case TYPEREF: {
                    throw new IllegalStateException("TYPEREF should not be returned for a dereferenced byte. schema: " + schema);
                }
            }
            throw new IllegalStateException("Unrecognized enum value: " + schema.getDereferencedType());
        }

        public Class<? extends Enum> resolveEnumClass(EnumDataSchema enumDataSchema) {
            return Enum.class;
        }
    }

    private static enum ResourceKeyType {
        COMPLEX,
        COMPOUND,
        PRIMITIVE,
        NONE;

    }
}

