/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.docgen;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class Node<T> {
    private final T _object;
    private final Set<Node<?>> _neighbors = new HashSet();

    public Node(T object) {
        this._object = object;
    }

    public void addAdjacentNode(Node<?> node) {
        this._neighbors.add(node);
    }

    public Iterable<Node<?>> getAdjacency() {
        return this._neighbors;
    }

    public <O> Iterable<Node<O>> getAdjacency(final Class<O> type) {
        return new Iterable<Node<O>>(){

            @Override
            public Iterator<Node<O>> iterator() {
                return new Iterator<Node<O>>(){
                    private Iterator<Node<?>> _itr;
                    private Node<O> _next;
                    {
                        this._itr = Node.this._neighbors.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this._next != null) {
                            return true;
                        }
                        while (this._itr.hasNext() && this._next == null) {
                            Node<?> next = this._itr.next();
                            if (!type.isAssignableFrom(next.getObject().getClass())) continue;
                            this._next = next;
                        }
                        return this._next != null;
                    }

                    @Override
                    public Node<O> next() {
                        if (this.hasNext()) {
                            Node next = this._next;
                            this._next = null;
                            return next;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Object getObject() {
        return this._object;
    }

    public int hashCode() {
        return this._object.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Node) {
            return obj.equals(this._object);
        }
        return false;
    }
}

