/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.docgen;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.docgen.BaseResourceSchemaVisitor;
import com.linkedin.restli.docgen.ResourceSchemaVisitior;
import com.linkedin.restli.restspec.ActionSchema;
import com.linkedin.restli.restspec.FinderSchema;
import com.linkedin.restli.restspec.RestMethodSchema;
import com.linkedin.restli.server.ResourceLevel;
import com.linkedin.restli.server.util.ChainedIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MethodGatheringResourceSchemaVisitor
extends BaseResourceSchemaVisitor {
    private final Set<String> _resourceNames = new HashSet<String>();
    private final Set<RestMethodSchema> _restMethods = new HashSet<RestMethodSchema>();
    private final Set<FinderSchema> _finders = new HashSet<FinderSchema>();
    private final Set<ActionSchema> _collectionActions = new HashSet<ActionSchema>();
    private final Set<ActionSchema> _entityActions = new HashSet<ActionSchema>();

    public MethodGatheringResourceSchemaVisitor(String ... resourceNames) {
        for (String resourceName : resourceNames) {
            this._resourceNames.add(resourceName);
        }
    }

    public Set<RestMethodSchema> getRestMethods() {
        return this._restMethods;
    }

    public Set<FinderSchema> getFinders() {
        return this._finders;
    }

    public Set<ActionSchema> getCollectionActions() {
        return this._collectionActions;
    }

    public Set<ActionSchema> getEntityActions() {
        return this._entityActions;
    }

    public Iterable<? extends RecordTemplate> getAllMethods() {
        return new Iterable<RecordTemplate>(){
            private final Iterator<RecordTemplate> _itr;
            {
                this._itr = MethodGatheringResourceSchemaVisitor.this.getAllMethodsIterator();
            }

            @Override
            public Iterator<RecordTemplate> iterator() {
                return this._itr;
            }
        };
    }

    public Iterator<RecordTemplate> getAllMethodsIterator() {
        return new ChainedIterator(new Iterator[]{this._restMethods.iterator(), this._finders.iterator(), this._collectionActions.iterator(), this._entityActions.iterator()});
    }

    @Override
    public void visitAction(ResourceSchemaVisitior.VisitContext context, RecordTemplate parentResource, ResourceLevel resourceLevel, ActionSchema actionSchema) {
        if (!this.isTargetResourcePath(context)) {
            return;
        }
        if (resourceLevel == ResourceLevel.COLLECTION) {
            this._collectionActions.add(actionSchema);
        } else {
            this._entityActions.add(actionSchema);
        }
    }

    @Override
    public void visitFinder(ResourceSchemaVisitior.VisitContext context, RecordTemplate parentResource, FinderSchema finderSchema) {
        if (this.isTargetResourcePath(context)) {
            this._finders.add(finderSchema);
        }
    }

    @Override
    public void visitRestMethod(ResourceSchemaVisitior.VisitContext context, RecordTemplate parentResource, RestMethodSchema restMethodSchema) {
        if (this.isTargetResourcePath(context)) {
            this._restMethods.add(restMethodSchema);
        }
    }

    private boolean isTargetResourcePath(ResourceSchemaVisitior.VisitContext visitContext) {
        return this._resourceNames.contains(visitContext.getResourcePath());
    }
}

