/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2;

import com.linkedin.d2.ConsistentHashAlgorithmEnum;
import com.linkedin.d2.hashConfigType;
import com.linkedin.d2.hashMethodEnum;
import com.linkedin.d2.quarantineInfo;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;

public class D2LoadBalancerStrategyProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"D2LoadBalancerStrategyProperties\",\"namespace\":\"com.linkedin.d2\",\"doc\":\"Load balancer properties for a particular D2 service\",\"fields\":[{\"name\":\"globalStepDown\",\"type\":\"double\",\"doc\":\"The step down function's delta size when adjusting the drop rate. Should be between 0.0 - 1.0. Defaults to 0.2.\",\"optional\":true},{\"name\":\"globalStepUp\",\"type\":\"double\",\"doc\":\"The step up function's delta size when adjusting the drop rate. Should be between 0.0 - 1.0. Defaults to 0.2.\",\"optional\":true},{\"name\":\"initialRecoveryLevel\",\"type\":\"double\",\"doc\":\"When a node is completely degraded, this config is used to determine the starting recovery weight for that node. Should be between 0.0 - 1.0. Defaults to 0.01.\",\"optional\":true},{\"name\":\"ringRampFactor\",\"type\":\"double\",\"doc\":\"How fast should load balancer ramp up node that has been 100% degraded and is being recovered. This is used with initialRecoveryLevel to recover the traffic of a node. Defaults to 1.0.\",\"optional\":true},{\"name\":\"highWaterMark\",\"type\":\"double\",\"doc\":\"If average ms latency for the entire service is over this number then we consider the service is in a bad state. Defaults to 3000ms.\",\"optional\":true},{\"name\":\"lowWaterMark\",\"type\":\"double\",\"doc\":\"If average ms latency for the entire service is lower than this number then we consider the service is in a good state. Defaults to 500ms.\",\"optional\":true},{\"name\":\"pointsPerWeight\",\"type\":\"int\",\"doc\":\"The number of points per weight given for a particular node in a hash ring. Defaults to 100.\",\"optional\":true},{\"name\":\"updateIntervalMs\",\"type\":\"long\",\"doc\":\"Interval in ms between each round of load balancer calculation. Defaults to 5000ms.\",\"optional\":true},{\"name\":\"minCallCountHighWaterMark\",\"type\":\"long\",\"doc\":\"If call count for the cluster for this service is over this number then we can use the statistics to calculate drop rate. Defaults to 10.\",\"optional\":true},{\"name\":\"minCallCountLowWaterMark\",\"type\":\"long\",\"doc\":\"If call count for the cluster for this service is below this number then we will not use the statistics to calculate drop rate. Defaults to 5.\",\"optional\":true},{\"name\":\"hashMethod\",\"type\":{\"type\":\"enum\",\"name\":\"hashMethodEnum\",\"symbols\":[\"RANDOM\",\"URI_REGEX\"]},\"doc\":\"What hashing method used to hash incoming request. Used to determine which node should serve the request. Choices are Random, UriRegex\",\"optional\":true,\"symbolDocs\":{\"URI_REGEX\":\"Extract a key from URI and use it to hash\",\"RANDOM\":\"The default fall back value\"}},{\"name\":\"hashConfig\",\"type\":{\"type\":\"record\",\"name\":\"hashConfigType\",\"fields\":[{\"name\":\"uriRegexes\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"List of Regex to match against the URI of incoming request and compute hash value. The hash value is computed based on the contents of the first capture group of the first expression that matches the request URI\",\"optional\":true},{\"name\":\"failOnNoMatch\",\"type\":\"boolean\",\"doc\":\"Optional config value. if true, fail if no regex matches, otherwise fall back to random.\",\"default\":false},{\"name\":\"warnOnNoMatch\",\"type\":\"boolean\",\"doc\":\" Optional config value. if false, don't warn on falling back to random if the uri doesn't match the regex\",\"default\":true}]},\"doc\":\"Configuration used to supplement the hash method.\",\"optional\":true},{\"name\":\"updateOnlyAtInterval\",\"type\":\"boolean\",\"doc\":\"Whether to update load balancer strategy state only at each update interval.\",\"default\":false},{\"name\":\"hashRingPointCleanupRate\",\"type\":\"double\",\"doc\":\"The highest ratio of unused entries over the total entries of the Ring points that d2 maintains.\",\"optional\":true},{\"name\":\"consistentHashAlgorithm\",\"type\":{\"type\":\"enum\",\"name\":\"ConsistentHashAlgorithmEnum\",\"symbols\":[\"POINT_BASED\",\"MULTI_PROBE\"],\"symbolDocs\":{\"POINT_BASED\":\"Point-based consistent hash ring. The more points the ring has, the more balanced it is.\",\"MULTI_PROBE\":\"Multi-probe consistent hash. The more probes to use, the more balanced the ring is.\"}},\"doc\":\"Consistent hash algorithm the d2 load balancer should use. Defaults to POINT_BASED.\",\"optional\":true},{\"name\":\"numberOfProbes\",\"type\":\"int\",\"doc\":\"The number of probes used to look up a key in consistent hash ring. Defaults to 21.\",\"optional\":true},{\"name\":\"quarantineCfg\",\"type\":{\"type\":\"record\",\"name\":\"quarantineInfo\",\"doc\":\"Config info for d2 quarantine feature\",\"fields\":[{\"name\":\"quarantineMaxPercent\",\"type\":\"double\",\"doc\":\"The percentage of the hosts that can be quarantined at the same time. It is also the switch to turn on Quarantine feature.\"},{\"name\":\"quarantineMethod\",\"type\":\"string\",\"doc\":\"Config the health checking method for quarantine. Format: <METHOD>:<FULL_PATH>. Default to OPTIONS method.\",\"optional\":true},{\"name\":\"quarantineLatency\",\"type\":\"long\",\"doc\":\"The latency threshold (in milliseconds) for health checking response. Responding time longer than this threshold is considered as unhealthy.\",\"optional\":true}]},\"optional\":true},{\"name\":\"errorStatusRegex\",\"type\":\"string\",\"doc\":\"Regular expression to match the status code indicates a server-side error.\",\"optional\":true}]}");
    private static final RecordDataSchema.Field FIELD_GlobalStepDown = SCHEMA.getField("globalStepDown");
    private static final RecordDataSchema.Field FIELD_GlobalStepUp = SCHEMA.getField("globalStepUp");
    private static final RecordDataSchema.Field FIELD_InitialRecoveryLevel = SCHEMA.getField("initialRecoveryLevel");
    private static final RecordDataSchema.Field FIELD_RingRampFactor = SCHEMA.getField("ringRampFactor");
    private static final RecordDataSchema.Field FIELD_HighWaterMark = SCHEMA.getField("highWaterMark");
    private static final RecordDataSchema.Field FIELD_LowWaterMark = SCHEMA.getField("lowWaterMark");
    private static final RecordDataSchema.Field FIELD_PointsPerWeight = SCHEMA.getField("pointsPerWeight");
    private static final RecordDataSchema.Field FIELD_UpdateIntervalMs = SCHEMA.getField("updateIntervalMs");
    private static final RecordDataSchema.Field FIELD_MinCallCountHighWaterMark = SCHEMA.getField("minCallCountHighWaterMark");
    private static final RecordDataSchema.Field FIELD_MinCallCountLowWaterMark = SCHEMA.getField("minCallCountLowWaterMark");
    private static final RecordDataSchema.Field FIELD_HashMethod = SCHEMA.getField("hashMethod");
    private static final RecordDataSchema.Field FIELD_HashConfig = SCHEMA.getField("hashConfig");
    private static final RecordDataSchema.Field FIELD_UpdateOnlyAtInterval = SCHEMA.getField("updateOnlyAtInterval");
    private static final RecordDataSchema.Field FIELD_HashRingPointCleanupRate = SCHEMA.getField("hashRingPointCleanupRate");
    private static final RecordDataSchema.Field FIELD_ConsistentHashAlgorithm = SCHEMA.getField("consistentHashAlgorithm");
    private static final RecordDataSchema.Field FIELD_NumberOfProbes = SCHEMA.getField("numberOfProbes");
    private static final RecordDataSchema.Field FIELD_QuarantineCfg = SCHEMA.getField("quarantineCfg");
    private static final RecordDataSchema.Field FIELD_ErrorStatusRegex = SCHEMA.getField("errorStatusRegex");

    public D2LoadBalancerStrategyProperties() {
        super(new DataMap(), SCHEMA);
    }

    public D2LoadBalancerStrategyProperties(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasGlobalStepDown() {
        return this.contains(FIELD_GlobalStepDown);
    }

    public void removeGlobalStepDown() {
        this.remove(FIELD_GlobalStepDown);
    }

    public Double getGlobalStepDown(GetMode mode) {
        return (Double)this.obtainDirect(FIELD_GlobalStepDown, Double.class, mode);
    }

    public Double getGlobalStepDown() {
        return (Double)this.obtainDirect(FIELD_GlobalStepDown, Double.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setGlobalStepDown(Double value, SetMode mode) {
        this.putDirect(FIELD_GlobalStepDown, Double.class, Double.class, value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setGlobalStepDown(Double value) {
        this.putDirect(FIELD_GlobalStepDown, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2LoadBalancerStrategyProperties setGlobalStepDown(double value) {
        this.putDirect(FIELD_GlobalStepDown, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasGlobalStepUp() {
        return this.contains(FIELD_GlobalStepUp);
    }

    public void removeGlobalStepUp() {
        this.remove(FIELD_GlobalStepUp);
    }

    public Double getGlobalStepUp(GetMode mode) {
        return (Double)this.obtainDirect(FIELD_GlobalStepUp, Double.class, mode);
    }

    public Double getGlobalStepUp() {
        return (Double)this.obtainDirect(FIELD_GlobalStepUp, Double.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setGlobalStepUp(Double value, SetMode mode) {
        this.putDirect(FIELD_GlobalStepUp, Double.class, Double.class, value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setGlobalStepUp(Double value) {
        this.putDirect(FIELD_GlobalStepUp, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2LoadBalancerStrategyProperties setGlobalStepUp(double value) {
        this.putDirect(FIELD_GlobalStepUp, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasInitialRecoveryLevel() {
        return this.contains(FIELD_InitialRecoveryLevel);
    }

    public void removeInitialRecoveryLevel() {
        this.remove(FIELD_InitialRecoveryLevel);
    }

    public Double getInitialRecoveryLevel(GetMode mode) {
        return (Double)this.obtainDirect(FIELD_InitialRecoveryLevel, Double.class, mode);
    }

    public Double getInitialRecoveryLevel() {
        return (Double)this.obtainDirect(FIELD_InitialRecoveryLevel, Double.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setInitialRecoveryLevel(Double value, SetMode mode) {
        this.putDirect(FIELD_InitialRecoveryLevel, Double.class, Double.class, value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setInitialRecoveryLevel(Double value) {
        this.putDirect(FIELD_InitialRecoveryLevel, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2LoadBalancerStrategyProperties setInitialRecoveryLevel(double value) {
        this.putDirect(FIELD_InitialRecoveryLevel, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasRingRampFactor() {
        return this.contains(FIELD_RingRampFactor);
    }

    public void removeRingRampFactor() {
        this.remove(FIELD_RingRampFactor);
    }

    public Double getRingRampFactor(GetMode mode) {
        return (Double)this.obtainDirect(FIELD_RingRampFactor, Double.class, mode);
    }

    public Double getRingRampFactor() {
        return (Double)this.obtainDirect(FIELD_RingRampFactor, Double.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setRingRampFactor(Double value, SetMode mode) {
        this.putDirect(FIELD_RingRampFactor, Double.class, Double.class, value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setRingRampFactor(Double value) {
        this.putDirect(FIELD_RingRampFactor, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2LoadBalancerStrategyProperties setRingRampFactor(double value) {
        this.putDirect(FIELD_RingRampFactor, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasHighWaterMark() {
        return this.contains(FIELD_HighWaterMark);
    }

    public void removeHighWaterMark() {
        this.remove(FIELD_HighWaterMark);
    }

    public Double getHighWaterMark(GetMode mode) {
        return (Double)this.obtainDirect(FIELD_HighWaterMark, Double.class, mode);
    }

    public Double getHighWaterMark() {
        return (Double)this.obtainDirect(FIELD_HighWaterMark, Double.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setHighWaterMark(Double value, SetMode mode) {
        this.putDirect(FIELD_HighWaterMark, Double.class, Double.class, value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setHighWaterMark(Double value) {
        this.putDirect(FIELD_HighWaterMark, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2LoadBalancerStrategyProperties setHighWaterMark(double value) {
        this.putDirect(FIELD_HighWaterMark, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasLowWaterMark() {
        return this.contains(FIELD_LowWaterMark);
    }

    public void removeLowWaterMark() {
        this.remove(FIELD_LowWaterMark);
    }

    public Double getLowWaterMark(GetMode mode) {
        return (Double)this.obtainDirect(FIELD_LowWaterMark, Double.class, mode);
    }

    public Double getLowWaterMark() {
        return (Double)this.obtainDirect(FIELD_LowWaterMark, Double.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setLowWaterMark(Double value, SetMode mode) {
        this.putDirect(FIELD_LowWaterMark, Double.class, Double.class, value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setLowWaterMark(Double value) {
        this.putDirect(FIELD_LowWaterMark, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2LoadBalancerStrategyProperties setLowWaterMark(double value) {
        this.putDirect(FIELD_LowWaterMark, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasPointsPerWeight() {
        return this.contains(FIELD_PointsPerWeight);
    }

    public void removePointsPerWeight() {
        this.remove(FIELD_PointsPerWeight);
    }

    public Integer getPointsPerWeight(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_PointsPerWeight, Integer.class, mode);
    }

    public Integer getPointsPerWeight() {
        return (Integer)this.obtainDirect(FIELD_PointsPerWeight, Integer.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setPointsPerWeight(Integer value, SetMode mode) {
        this.putDirect(FIELD_PointsPerWeight, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setPointsPerWeight(Integer value) {
        this.putDirect(FIELD_PointsPerWeight, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2LoadBalancerStrategyProperties setPointsPerWeight(int value) {
        this.putDirect(FIELD_PointsPerWeight, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasUpdateIntervalMs() {
        return this.contains(FIELD_UpdateIntervalMs);
    }

    public void removeUpdateIntervalMs() {
        this.remove(FIELD_UpdateIntervalMs);
    }

    public Long getUpdateIntervalMs(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_UpdateIntervalMs, Long.class, mode);
    }

    public Long getUpdateIntervalMs() {
        return (Long)this.obtainDirect(FIELD_UpdateIntervalMs, Long.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setUpdateIntervalMs(Long value, SetMode mode) {
        this.putDirect(FIELD_UpdateIntervalMs, Long.class, Long.class, value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setUpdateIntervalMs(Long value) {
        this.putDirect(FIELD_UpdateIntervalMs, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2LoadBalancerStrategyProperties setUpdateIntervalMs(long value) {
        this.putDirect(FIELD_UpdateIntervalMs, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMinCallCountHighWaterMark() {
        return this.contains(FIELD_MinCallCountHighWaterMark);
    }

    public void removeMinCallCountHighWaterMark() {
        this.remove(FIELD_MinCallCountHighWaterMark);
    }

    public Long getMinCallCountHighWaterMark(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_MinCallCountHighWaterMark, Long.class, mode);
    }

    public Long getMinCallCountHighWaterMark() {
        return (Long)this.obtainDirect(FIELD_MinCallCountHighWaterMark, Long.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setMinCallCountHighWaterMark(Long value, SetMode mode) {
        this.putDirect(FIELD_MinCallCountHighWaterMark, Long.class, Long.class, value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setMinCallCountHighWaterMark(Long value) {
        this.putDirect(FIELD_MinCallCountHighWaterMark, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2LoadBalancerStrategyProperties setMinCallCountHighWaterMark(long value) {
        this.putDirect(FIELD_MinCallCountHighWaterMark, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMinCallCountLowWaterMark() {
        return this.contains(FIELD_MinCallCountLowWaterMark);
    }

    public void removeMinCallCountLowWaterMark() {
        this.remove(FIELD_MinCallCountLowWaterMark);
    }

    public Long getMinCallCountLowWaterMark(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_MinCallCountLowWaterMark, Long.class, mode);
    }

    public Long getMinCallCountLowWaterMark() {
        return (Long)this.obtainDirect(FIELD_MinCallCountLowWaterMark, Long.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setMinCallCountLowWaterMark(Long value, SetMode mode) {
        this.putDirect(FIELD_MinCallCountLowWaterMark, Long.class, Long.class, value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setMinCallCountLowWaterMark(Long value) {
        this.putDirect(FIELD_MinCallCountLowWaterMark, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2LoadBalancerStrategyProperties setMinCallCountLowWaterMark(long value) {
        this.putDirect(FIELD_MinCallCountLowWaterMark, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasHashMethod() {
        return this.contains(FIELD_HashMethod);
    }

    public void removeHashMethod() {
        this.remove(FIELD_HashMethod);
    }

    public hashMethodEnum getHashMethod(GetMode mode) {
        return (hashMethodEnum)((Object)this.obtainDirect(FIELD_HashMethod, hashMethodEnum.class, mode));
    }

    public hashMethodEnum getHashMethod() {
        return (hashMethodEnum)((Object)this.obtainDirect(FIELD_HashMethod, hashMethodEnum.class, GetMode.STRICT));
    }

    public D2LoadBalancerStrategyProperties setHashMethod(hashMethodEnum value, SetMode mode) {
        this.putDirect(FIELD_HashMethod, hashMethodEnum.class, String.class, (Object)value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setHashMethod(hashMethodEnum value) {
        this.putDirect(FIELD_HashMethod, hashMethodEnum.class, String.class, (Object)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasHashConfig() {
        return this.contains(FIELD_HashConfig);
    }

    public void removeHashConfig() {
        this.remove(FIELD_HashConfig);
    }

    public hashConfigType getHashConfig(GetMode mode) {
        return (hashConfigType)this.obtainWrapped(FIELD_HashConfig, hashConfigType.class, mode);
    }

    public hashConfigType getHashConfig() {
        return (hashConfigType)this.obtainWrapped(FIELD_HashConfig, hashConfigType.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setHashConfig(hashConfigType value, SetMode mode) {
        this.putWrapped(FIELD_HashConfig, hashConfigType.class, (DataTemplate)value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setHashConfig(hashConfigType value) {
        this.putWrapped(FIELD_HashConfig, hashConfigType.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasUpdateOnlyAtInterval() {
        return this.contains(FIELD_UpdateOnlyAtInterval);
    }

    public void removeUpdateOnlyAtInterval() {
        this.remove(FIELD_UpdateOnlyAtInterval);
    }

    public Boolean isUpdateOnlyAtInterval(GetMode mode) {
        return (Boolean)this.obtainDirect(FIELD_UpdateOnlyAtInterval, Boolean.class, mode);
    }

    public Boolean isUpdateOnlyAtInterval() {
        return (Boolean)this.obtainDirect(FIELD_UpdateOnlyAtInterval, Boolean.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setUpdateOnlyAtInterval(Boolean value, SetMode mode) {
        this.putDirect(FIELD_UpdateOnlyAtInterval, Boolean.class, Boolean.class, value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setUpdateOnlyAtInterval(Boolean value) {
        this.putDirect(FIELD_UpdateOnlyAtInterval, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2LoadBalancerStrategyProperties setUpdateOnlyAtInterval(boolean value) {
        this.putDirect(FIELD_UpdateOnlyAtInterval, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasHashRingPointCleanupRate() {
        return this.contains(FIELD_HashRingPointCleanupRate);
    }

    public void removeHashRingPointCleanupRate() {
        this.remove(FIELD_HashRingPointCleanupRate);
    }

    public Double getHashRingPointCleanupRate(GetMode mode) {
        return (Double)this.obtainDirect(FIELD_HashRingPointCleanupRate, Double.class, mode);
    }

    public Double getHashRingPointCleanupRate() {
        return (Double)this.obtainDirect(FIELD_HashRingPointCleanupRate, Double.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setHashRingPointCleanupRate(Double value, SetMode mode) {
        this.putDirect(FIELD_HashRingPointCleanupRate, Double.class, Double.class, value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setHashRingPointCleanupRate(Double value) {
        this.putDirect(FIELD_HashRingPointCleanupRate, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2LoadBalancerStrategyProperties setHashRingPointCleanupRate(double value) {
        this.putDirect(FIELD_HashRingPointCleanupRate, Double.class, Double.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasConsistentHashAlgorithm() {
        return this.contains(FIELD_ConsistentHashAlgorithm);
    }

    public void removeConsistentHashAlgorithm() {
        this.remove(FIELD_ConsistentHashAlgorithm);
    }

    public ConsistentHashAlgorithmEnum getConsistentHashAlgorithm(GetMode mode) {
        return (ConsistentHashAlgorithmEnum)((Object)this.obtainDirect(FIELD_ConsistentHashAlgorithm, ConsistentHashAlgorithmEnum.class, mode));
    }

    public ConsistentHashAlgorithmEnum getConsistentHashAlgorithm() {
        return (ConsistentHashAlgorithmEnum)((Object)this.obtainDirect(FIELD_ConsistentHashAlgorithm, ConsistentHashAlgorithmEnum.class, GetMode.STRICT));
    }

    public D2LoadBalancerStrategyProperties setConsistentHashAlgorithm(ConsistentHashAlgorithmEnum value, SetMode mode) {
        this.putDirect(FIELD_ConsistentHashAlgorithm, ConsistentHashAlgorithmEnum.class, String.class, (Object)value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setConsistentHashAlgorithm(ConsistentHashAlgorithmEnum value) {
        this.putDirect(FIELD_ConsistentHashAlgorithm, ConsistentHashAlgorithmEnum.class, String.class, (Object)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasNumberOfProbes() {
        return this.contains(FIELD_NumberOfProbes);
    }

    public void removeNumberOfProbes() {
        this.remove(FIELD_NumberOfProbes);
    }

    public Integer getNumberOfProbes(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_NumberOfProbes, Integer.class, mode);
    }

    public Integer getNumberOfProbes() {
        return (Integer)this.obtainDirect(FIELD_NumberOfProbes, Integer.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setNumberOfProbes(Integer value, SetMode mode) {
        this.putDirect(FIELD_NumberOfProbes, Integer.class, Integer.class, value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setNumberOfProbes(Integer value) {
        this.putDirect(FIELD_NumberOfProbes, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2LoadBalancerStrategyProperties setNumberOfProbes(int value) {
        this.putDirect(FIELD_NumberOfProbes, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasQuarantineCfg() {
        return this.contains(FIELD_QuarantineCfg);
    }

    public void removeQuarantineCfg() {
        this.remove(FIELD_QuarantineCfg);
    }

    public quarantineInfo getQuarantineCfg(GetMode mode) {
        return (quarantineInfo)this.obtainWrapped(FIELD_QuarantineCfg, quarantineInfo.class, mode);
    }

    public quarantineInfo getQuarantineCfg() {
        return (quarantineInfo)this.obtainWrapped(FIELD_QuarantineCfg, quarantineInfo.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setQuarantineCfg(quarantineInfo value, SetMode mode) {
        this.putWrapped(FIELD_QuarantineCfg, quarantineInfo.class, (DataTemplate)value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setQuarantineCfg(quarantineInfo value) {
        this.putWrapped(FIELD_QuarantineCfg, quarantineInfo.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasErrorStatusRegex() {
        return this.contains(FIELD_ErrorStatusRegex);
    }

    public void removeErrorStatusRegex() {
        this.remove(FIELD_ErrorStatusRegex);
    }

    public String getErrorStatusRegex(GetMode mode) {
        return (String)this.obtainDirect(FIELD_ErrorStatusRegex, String.class, mode);
    }

    public String getErrorStatusRegex() {
        return (String)this.obtainDirect(FIELD_ErrorStatusRegex, String.class, GetMode.STRICT);
    }

    public D2LoadBalancerStrategyProperties setErrorStatusRegex(String value, SetMode mode) {
        this.putDirect(FIELD_ErrorStatusRegex, String.class, String.class, value, mode);
        return this;
    }

    public D2LoadBalancerStrategyProperties setErrorStatusRegex(String value) {
        this.putDirect(FIELD_ErrorStatusRegex, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public D2LoadBalancerStrategyProperties clone() throws CloneNotSupportedException {
        return (D2LoadBalancerStrategyProperties)super.clone();
    }

    public D2LoadBalancerStrategyProperties copy() throws CloneNotSupportedException {
        return (D2LoadBalancerStrategyProperties)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec globalStepDown() {
            return new PathSpec(this.getPathComponents(), "globalStepDown");
        }

        public PathSpec globalStepUp() {
            return new PathSpec(this.getPathComponents(), "globalStepUp");
        }

        public PathSpec initialRecoveryLevel() {
            return new PathSpec(this.getPathComponents(), "initialRecoveryLevel");
        }

        public PathSpec ringRampFactor() {
            return new PathSpec(this.getPathComponents(), "ringRampFactor");
        }

        public PathSpec highWaterMark() {
            return new PathSpec(this.getPathComponents(), "highWaterMark");
        }

        public PathSpec lowWaterMark() {
            return new PathSpec(this.getPathComponents(), "lowWaterMark");
        }

        public PathSpec pointsPerWeight() {
            return new PathSpec(this.getPathComponents(), "pointsPerWeight");
        }

        public PathSpec updateIntervalMs() {
            return new PathSpec(this.getPathComponents(), "updateIntervalMs");
        }

        public PathSpec minCallCountHighWaterMark() {
            return new PathSpec(this.getPathComponents(), "minCallCountHighWaterMark");
        }

        public PathSpec minCallCountLowWaterMark() {
            return new PathSpec(this.getPathComponents(), "minCallCountLowWaterMark");
        }

        public PathSpec hashMethod() {
            return new PathSpec(this.getPathComponents(), "hashMethod");
        }

        public hashConfigType.Fields hashConfig() {
            return new hashConfigType.Fields(this.getPathComponents(), "hashConfig");
        }

        public PathSpec updateOnlyAtInterval() {
            return new PathSpec(this.getPathComponents(), "updateOnlyAtInterval");
        }

        public PathSpec hashRingPointCleanupRate() {
            return new PathSpec(this.getPathComponents(), "hashRingPointCleanupRate");
        }

        public PathSpec consistentHashAlgorithm() {
            return new PathSpec(this.getPathComponents(), "consistentHashAlgorithm");
        }

        public PathSpec numberOfProbes() {
            return new PathSpec(this.getPathComponents(), "numberOfProbes");
        }

        public quarantineInfo.Fields quarantineCfg() {
            return new quarantineInfo.Fields(this.getPathComponents(), "quarantineCfg");
        }

        public PathSpec errorStatusRegex() {
            return new PathSpec(this.getPathComponents(), "errorStatusRegex");
        }
    }
}

