/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metadata.types;

import java.io.IOException;
import org.apache.gobblin.metadata.MetadataMerger;
import org.apache.gobblin.metadata.types.GlobalMetadata;
import org.apache.gobblin.writer.FsWriterMetrics;

public class GlobalMetadataJsonMerger
implements MetadataMerger<String> {
    private GlobalMetadata mergedMetadata = new GlobalMetadata();

    public void update(String metadata) {
        try {
            GlobalMetadata parsedMetadata = GlobalMetadata.fromJson(metadata);
            this.mergedMetadata.addAll(parsedMetadata);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error parsing metadata", e);
        }
    }

    public void update(FsWriterMetrics metrics) {
        long numRecords = this.mergedMetadata.getNumRecords();
        int numFiles = this.mergedMetadata.getNumFiles();
        for (FsWriterMetrics.FileInfo fileInfo : metrics.getFileInfos()) {
            numRecords += fileInfo.getNumRecords();
            ++numFiles;
            this.mergedMetadata.setFileMetadata(fileInfo.getFileName(), "Num-Records", fileInfo.getNumRecords());
        }
        this.mergedMetadata.setNumRecords(numRecords);
        this.mergedMetadata.setNumOutputFiles(numFiles);
    }

    public String getMergedMetadata() {
        try {
            return this.mergedMetadata.toJson();
        }
        catch (IOException e) {
            throw new AssertionError("Unexpected IOException serializing to JSON", e);
        }
    }
}

