/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.test;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.eventbus.EventBus;
import java.util.concurrent.ExecutionException;

public class TestingEventBuses {
    private static final LoadingCache<String, EventBus> _instances = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, EventBus>(){

        public EventBus load(String key) throws Exception {
            return new EventBus(key);
        }
    });

    public static EventBus getEventBus(String eventBusId) {
        try {
            return (EventBus)_instances.get((Object)eventBusId);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unable to create an EventBus with id " + eventBusId + ": " + e, e);
        }
    }

    public static class Event {
        private final Object value;
        private final long timestampNanos;

        public Event(Object value) {
            this.value = value;
            this.timestampNanos = System.nanoTime();
        }

        public <T> T getTypedValue() {
            return (T)this.value;
        }

        public boolean valueEquals(Object otherValue) {
            if (null == this.value) {
                return null == otherValue;
            }
            return this.value.equals(otherValue);
        }

        public Object getValue() {
            return this.value;
        }

        public long getTimestampNanos() {
            return this.timestampNanos;
        }

        public String toString() {
            return "TestingEventBuses.Event(value=" + this.getValue() + ", timestampNanos=" + this.getTimestampNanos() + ")";
        }
    }
}

