/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.Watermark;
import org.apache.gobblin.source.extractor.exception.ExtractPrepareException;
import org.apache.gobblin.source.extractor.exception.HighWatermarkException;
import org.apache.gobblin.source.extractor.exception.RecordCountException;
import org.apache.gobblin.source.extractor.exception.SchemaException;
import org.apache.gobblin.source.extractor.extract.LongWatermark;
import org.apache.gobblin.source.extractor.extract.ProtocolSpecificLayer;
import org.apache.gobblin.source.extractor.partition.Partition;
import org.apache.gobblin.source.extractor.schema.ArrayDataType;
import org.apache.gobblin.source.extractor.schema.DataType;
import org.apache.gobblin.source.extractor.schema.EnumDataType;
import org.apache.gobblin.source.extractor.schema.MapDataType;
import org.apache.gobblin.source.extractor.utils.Utils;
import org.apache.gobblin.source.extractor.watermark.Predicate;
import org.apache.gobblin.source.extractor.watermark.WatermarkPredicate;
import org.apache.gobblin.source.extractor.watermark.WatermarkType;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class QueryBasedExtractor<S, D>
implements Extractor<S, D>,
ProtocolSpecificLayer<S, D> {
    private static final Logger log = LoggerFactory.getLogger(QueryBasedExtractor.class);
    private static final Gson GSON = new Gson();
    protected final WorkUnitState workUnitState;
    protected final WorkUnit workUnit;
    private final String entity;
    private final String schema;
    private final Partition partition;
    private boolean fetchStatus = true;
    private S outputSchema;
    private long sourceRecordCount = 0L;
    private long highWatermark;
    private Iterator<D> iterator;
    protected final List<String> columnList = new ArrayList<String>();
    @VisibleForTesting
    protected final List<Predicate> predicateList = new ArrayList<Predicate>();

    private S getOutputSchema() {
        return this.outputSchema;
    }

    protected void setOutputSchema(S outputSchema) {
        this.outputSchema = outputSchema;
    }

    private long getSourceRecordCount() {
        return this.sourceRecordCount;
    }

    public boolean getFetchStatus() {
        return this.fetchStatus;
    }

    public void setFetchStatus(boolean fetchStatus) {
        this.fetchStatus = fetchStatus;
    }

    public void setHighWatermark(long highWatermark) {
        this.highWatermark = highWatermark;
    }

    private boolean isPullRequired() {
        return this.getFetchStatus();
    }

    protected boolean isInitialPull() {
        return this.iterator == null;
    }

    public QueryBasedExtractor(WorkUnitState workUnitState) {
        this.workUnitState = workUnitState;
        this.workUnit = this.workUnitState.getWorkunit();
        this.schema = this.workUnitState.getProp("source.querybased.schema");
        this.entity = this.workUnitState.getProp("source.entity");
        this.partition = Partition.deserialize(this.workUnit);
        MDC.put((String)"tableName", (String)this.getWorkUnitName());
    }

    private String getWorkUnitName() {
        String timeSeqStr;
        int timeIndex;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(StringUtils.stripToEmpty((String)this.workUnitState.getProp("source.querybased.schema")));
        sb.append("_");
        sb.append(StringUtils.stripToEmpty((String)this.workUnitState.getProp("source.entity")));
        sb.append("_");
        String id = this.workUnitState.getId();
        int seqIndex = id.lastIndexOf("_", id.length());
        if (seqIndex > 0 && (timeIndex = (timeSeqStr = id.substring(0, seqIndex)).lastIndexOf("_", timeSeqStr.length())) > 0) {
            sb.append(id.substring(timeIndex + 1));
        }
        sb.append("]");
        return sb.toString();
    }

    public D readRecord(@Deprecated D reuse) throws DataRecordException, IOException {
        if (!this.isPullRequired()) {
            log.info("No more records to read");
            return null;
        }
        D nextElement = null;
        try {
            if (this.isInitialPull()) {
                log.info("Initial pull");
                if (this.shouldRemoveDataPullUpperBounds()) {
                    this.removeDataPullUpperBounds();
                }
                this.iterator = this.getIterator();
            }
            if (this.iterator.hasNext()) {
                nextElement = this.iterator.next();
                if (!this.iterator.hasNext()) {
                    log.debug("Getting next pull");
                    this.iterator = this.getIterator();
                    if (this.iterator == null) {
                        this.setFetchStatus(false);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DataRecordException("Failed to get records using rest api; error - " + e.getMessage(), e);
        }
        return nextElement;
    }

    private boolean shouldRemoveDataPullUpperBounds() {
        if (!this.workUnitState.getPropAsBoolean("source.querybased.allowRemoveUpperBounds", true)) {
            return false;
        }
        if (!this.partition.isLastPartition()) {
            return false;
        }
        return !this.partition.getHasUserSpecifiedHighWatermark() && this.workUnitState.getProp("workunit.state.actual.high.water.mark") == null;
    }

    private void removeDataPullUpperBounds() {
        log.info("Removing data pull upper bound for last work unit");
        Iterator<Predicate> it = this.predicateList.iterator();
        while (it.hasNext()) {
            Predicate predicate = it.next();
            if (predicate.getType() != Predicate.PredicateType.HWM) continue;
            log.info("Remove predicate: " + predicate.condition);
            it.remove();
        }
    }

    private Iterator<D> getIterator() throws DataRecordException, IOException {
        if (Boolean.valueOf(this.workUnitState.getProp("source.querybased.is.specific.api.active")).booleanValue()) {
            return this.getRecordSetFromSourceApi(this.schema, this.entity, this.workUnit, this.predicateList);
        }
        return this.getRecordSet(this.schema, this.entity, this.workUnit, this.predicateList);
    }

    public long getExpectedRecordCount() {
        return this.getSourceRecordCount();
    }

    public S getSchema() {
        return this.getOutputSchema();
    }

    public long getHighWatermark() {
        return this.highWatermark;
    }

    public void close() {
        log.info("Updating the current state high water mark with " + this.highWatermark);
        this.workUnitState.setActualHighWatermark((Watermark)new LongWatermark(this.highWatermark));
        try {
            this.closeConnection();
        }
        catch (Exception e) {
            log.error("Failed to close the extractor", (Throwable)e);
        }
    }

    public boolean isFullDump() {
        return Boolean.valueOf(this.workUnitState.getProp("extract.is.full"));
    }

    public Extractor<S, D> build() throws ExtractPrepareException {
        String watermarkColumn = this.workUnitState.getProp("extract.delta.fields");
        long lwm = this.partition.getLowWatermark();
        long hwm = this.partition.getHighWatermark();
        log.info("Low water mark: " + lwm + "; and High water mark: " + hwm);
        WatermarkType watermarkType = StringUtils.isBlank((CharSequence)this.workUnitState.getProp("source.querybased.watermark.type")) ? null : WatermarkType.valueOf(this.workUnitState.getProp("source.querybased.watermark.type").toUpperCase());
        log.info("Source Entity is " + this.entity);
        try {
            this.setTimeOut(this.workUnitState.getPropAsInt("source.conn.timeout", 500000));
            this.extractMetadata(this.schema, this.entity, this.workUnit);
            if (StringUtils.isNotBlank((CharSequence)watermarkColumn)) {
                if (this.partition.isLastPartition()) {
                    long adjustedHighWatermark = this.getLatestWatermark(watermarkColumn, watermarkType, lwm, hwm);
                    log.info("High water mark from source: " + adjustedHighWatermark);
                    if (adjustedHighWatermark == -1L) {
                        adjustedHighWatermark = this.getLowWatermarkWithNoDelta(lwm);
                    }
                    this.highWatermark = adjustedHighWatermark;
                } else {
                    this.highWatermark = hwm;
                }
                log.info("High water mark for the current run: " + this.highWatermark);
                this.setRangePredicates(watermarkColumn, watermarkType, lwm, this.highWatermark);
            }
            if (!Boolean.valueOf(this.workUnitState.getProp("source.querybased.skip.count.calc")).booleanValue()) {
                this.sourceRecordCount = this.getSourceCount(this.schema, this.entity, this.workUnit, this.predicateList);
            } else {
                log.info("Skip count calculation");
                this.sourceRecordCount = -1L;
            }
            if (this.sourceRecordCount == 0L) {
                log.info("Record count is 0; Setting fetch status to false to skip readRecord()");
                this.setFetchStatus(false);
            }
        }
        catch (SchemaException e) {
            throw new ExtractPrepareException("Failed to get schema for this object; error - " + e.getMessage(), e);
        }
        catch (HighWatermarkException e) {
            throw new ExtractPrepareException("Failed to get high watermark; error - " + e.getMessage(), e);
        }
        catch (RecordCountException e) {
            throw new ExtractPrepareException("Failed to get record count; error - " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ExtractPrepareException("Failed to prepare the extract build; error - " + e.getMessage(), e);
        }
        return this;
    }

    private long getLowWatermarkWithNoDelta(long lwm) {
        if (lwm == -1L) {
            return -1L;
        }
        String watermarkType = this.workUnitState.getProp("source.querybased.watermark.type", "TIMESTAMP");
        WatermarkType wmType = WatermarkType.valueOf(watermarkType.toUpperCase());
        int deltaNum = new WatermarkPredicate(wmType).getDeltaNumForNextWatermark();
        switch (wmType) {
            case SIMPLE: {
                return lwm - (long)deltaNum;
            }
        }
        Date lowWaterMarkDate = Utils.toDate(lwm, "yyyyMMddHHmmss");
        return Long.parseLong(Utils.dateToString(Utils.addSecondsToDate(lowWaterMarkDate, deltaNum * -1), "yyyyMMddHHmmss"));
    }

    private long getLatestWatermark(String watermarkColumn, WatermarkType watermarkType, long lwmValue, long hwmValue) throws HighWatermarkException, IOException {
        if (!Boolean.valueOf(this.workUnitState.getProp("source.querybased.skip.high.watermark.calc")).booleanValue()) {
            log.info("Getting high watermark");
            ArrayList<Predicate> list = new ArrayList<Predicate>();
            WatermarkPredicate watermark = new WatermarkPredicate(watermarkColumn, watermarkType);
            String lwmOperator = this.partition.isLowWatermarkInclusive() ? ">=" : ">";
            String hwmOperator = this.partition.isLastPartition() || this.partition.isHighWatermarkInclusive() ? "<=" : "<";
            Predicate lwmPredicate = watermark.getPredicate(this, lwmValue, lwmOperator, Predicate.PredicateType.LWM);
            Predicate hwmPredicate = watermark.getPredicate(this, hwmValue, hwmOperator, Predicate.PredicateType.HWM);
            if (lwmPredicate != null) {
                list.add(lwmPredicate);
            }
            if (hwmPredicate != null) {
                list.add(hwmPredicate);
            }
            return this.getMaxWatermark(this.schema, this.entity, watermarkColumn, list, watermark.getWatermarkSourceFormat(this));
        }
        return hwmValue;
    }

    private void setRangePredicates(String watermarkColumn, WatermarkType watermarkType, long lwmValue, long hwmValue) {
        String hourColumn;
        log.debug("Getting range predicates");
        String lwmOperator = this.partition.isLowWatermarkInclusive() ? ">=" : ">";
        String hwmOperator = this.partition.isLastPartition() || this.partition.isHighWatermarkInclusive() ? "<=" : "<";
        WatermarkPredicate watermark = new WatermarkPredicate(watermarkColumn, watermarkType);
        this.addPredicates(watermark.getPredicate(this, lwmValue, lwmOperator, Predicate.PredicateType.LWM));
        this.addPredicates(watermark.getPredicate(this, hwmValue, hwmOperator, Predicate.PredicateType.HWM));
        if (Boolean.valueOf(this.workUnitState.getProp("source.querybased.hourly.extract")).booleanValue() && StringUtils.isNotBlank((CharSequence)(hourColumn = this.workUnitState.getProp("source.querybased.hour.column")))) {
            WatermarkPredicate hourlyWatermark = new WatermarkPredicate(hourColumn, WatermarkType.HOUR);
            this.addPredicates(hourlyWatermark.getPredicate(this, lwmValue, lwmOperator, Predicate.PredicateType.LWM));
            this.addPredicates(hourlyWatermark.getPredicate(this, hwmValue, hwmOperator, Predicate.PredicateType.HWM));
        }
    }

    private void addPredicates(Predicate predicate) {
        if (predicate != null) {
            this.predicateList.add(predicate);
        }
    }

    protected boolean isWatermarkColumn(String watermarkColumn, String columnName) {
        List<String> waterMarkColumnList;
        if (columnName != null) {
            columnName = columnName.toLowerCase();
        }
        return StringUtils.isNotBlank((CharSequence)watermarkColumn) && (waterMarkColumnList = Arrays.asList(watermarkColumn.toLowerCase().split(","))).contains(columnName);
    }

    protected boolean hasMultipleWatermarkColumns(String watermarkColumn) {
        if (StringUtils.isBlank((CharSequence)watermarkColumn)) {
            return false;
        }
        return Arrays.asList(watermarkColumn.toLowerCase().split(",")).size() > 1;
    }

    protected int getPrimarykeyIndex(String primarykeyColumn, String columnName) {
        if (columnName != null) {
            columnName = columnName.toLowerCase();
        }
        if (StringUtils.isNotBlank((CharSequence)primarykeyColumn)) {
            List<String> primarykeyColumnList = Arrays.asList(primarykeyColumn.toLowerCase().split(","));
            return primarykeyColumnList.indexOf(columnName) + 1;
        }
        return 0;
    }

    protected boolean isMetadataColumn(String columnName, List<String> columnList) {
        boolean isColumnCheckEnabled = Boolean.valueOf(this.workUnitState.getProp("source.querybased.is.metadata.column.check.enabled", "true"));
        if (!isColumnCheckEnabled) {
            return true;
        }
        return columnList.contains(columnName = columnName.trim().toLowerCase());
    }

    protected JsonObject convertDataType(String columnName, String type, String elementType, List<String> enumSymbols) {
        String dataType = (String)this.getDataTypeMap().get(type);
        if (dataType == null) {
            dataType = "string";
        }
        DataType convertedDataType = dataType.equals("map") ? new MapDataType(dataType, elementType) : (dataType.equals("array") ? new ArrayDataType(dataType, elementType) : (dataType.equals("enum") ? new EnumDataType(dataType, columnName, enumSymbols) : new DataType(dataType)));
        return ((JsonObject)GSON.fromJson(GSON.toJson((Object)convertedDataType), JsonObject.class)).getAsJsonObject();
    }

    protected boolean isPredicateExists(List<Predicate> predicateList) {
        return predicateList != null && !predicateList.isEmpty();
    }
}

