/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.qualitychecker.task;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.qualitychecker.task.TaskLevelPolicy;
import org.apache.gobblin.qualitychecker.task.TaskLevelPolicyChecker;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskLevelPolicyCheckerBuilder {
    private final State state;
    private final int index;
    private static final Logger LOG = LoggerFactory.getLogger(TaskLevelPolicyCheckerBuilder.class);

    public TaskLevelPolicyCheckerBuilder(State state, int index) {
        this.state = state;
        this.index = index;
    }

    private List<TaskLevelPolicy> createPolicyList() throws Exception {
        ArrayList<TaskLevelPolicy> list = new ArrayList<TaskLevelPolicy>();
        String taskLevelPoliciesKey = ForkOperatorUtils.getPropertyNameForBranch((String)"qualitychecker.task.policies", (int)this.index);
        String taskLevelPolicyTypesKey = ForkOperatorUtils.getPropertyNameForBranch((String)"qualitychecker.task.policy.types", (int)this.index);
        if (this.state.contains(taskLevelPoliciesKey) && this.state.contains(taskLevelPolicyTypesKey)) {
            Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
            ArrayList policies = Lists.newArrayList((Iterable)splitter.split((CharSequence)this.state.getProp(taskLevelPoliciesKey)));
            ArrayList types = Lists.newArrayList((Iterable)splitter.split((CharSequence)this.state.getProp(taskLevelPolicyTypesKey)));
            if (policies.size() != types.size()) {
                throw new Exception("TaskLevelPolicy list and TaskLevelPolicies type list are not the same length");
            }
            for (int i = 0; i < policies.size(); ++i) {
                try {
                    Class<?> policyClass = Class.forName((String)policies.get(i));
                    Constructor<?> policyConstructor = policyClass.getConstructor(State.class, TaskLevelPolicy.Type.class);
                    TaskLevelPolicy policy = (TaskLevelPolicy)policyConstructor.newInstance(this.state, TaskLevelPolicy.Type.valueOf((String)((String)types.get(i))));
                    list.add(policy);
                    continue;
                }
                catch (Exception e) {
                    LOG.error(taskLevelPoliciesKey + " contains a class " + (String)policies.get(i) + " which doesn't extend Policy.", (Throwable)e);
                    throw e;
                }
            }
        }
        return list;
    }

    public static TaskLevelPolicyCheckerBuilder newBuilder(State state, int index) {
        return new TaskLevelPolicyCheckerBuilder(state, index);
    }

    public TaskLevelPolicyChecker build() throws Exception {
        return new TaskLevelPolicyChecker(this.createPolicyList());
    }
}

