/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.qualitychecker.row;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import org.apache.gobblin.qualitychecker.row.RowLevelPolicy;

public class RowLevelPolicyCheckResults {
    Map<RowLevelPolicyResultPair, Long> results = Maps.newConcurrentMap();

    public void put(RowLevelPolicy policy, RowLevelPolicy.Result result) {
        RowLevelPolicyResultPair resultPolicyPair = new RowLevelPolicyResultPair(policy, result);
        long value = this.results.containsKey(resultPolicyPair) ? this.results.get(resultPolicyPair) : 0L;
        this.results.put(new RowLevelPolicyResultPair(policy, result), 1L + value);
    }

    public String getResults() {
        ArrayList<String> list = new ArrayList<String>();
        Joiner joiner = Joiner.on((String)"\n").skipNulls();
        for (Map.Entry<RowLevelPolicyResultPair, Long> entry : this.results.entrySet()) {
            list.add("RowLevelPolicy " + entry.getKey().getPolicy().toString() + " processed " + entry.getValue() + " record(s) with result " + entry.getKey().getResult());
        }
        return joiner.join(list);
    }

    public static class RowLevelPolicyResultPair {
        private RowLevelPolicy policy;
        private RowLevelPolicy.Result result;

        public RowLevelPolicyResultPair(RowLevelPolicy policy, RowLevelPolicy.Result result) {
            this.policy = policy;
            this.result = result;
        }

        public RowLevelPolicy getPolicy() {
            return this.policy;
        }

        public RowLevelPolicy.Result getResult() {
            return this.result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RowLevelPolicyResultPair)) {
                return false;
            }
            RowLevelPolicyResultPair p = (RowLevelPolicyResultPair)o;
            return p.getPolicy().toString().equals(this.policy.toString()) && p.getResult().equals((Object)this.result);
        }

        public int hashCode() {
            return (this.policy.toString() + this.result).hashCode();
        }
    }
}

