/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.policies.time;

import com.google.common.base.Optional;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.qualitychecker.row.RowLevelPolicy;
import org.apache.gobblin.writer.partitioner.TimeBasedWriterPartitioner;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public abstract class RecordTimestampLowerBoundPolicy
extends RowLevelPolicy {
    public static final String RECORD_MAX_ALLOWED_TIME_AGO = "record.max.allowed.time.ago";
    public static final PeriodFormatter PERIOD_FORMATTER = new PeriodFormatterBuilder().appendMonths().appendSuffix("m").appendDays().appendSuffix("d").appendHours().appendSuffix("h").toFormatter();
    protected final TimeBasedWriterPartitioner partitioner = this.getPartitioner();
    protected final DateTimeZone timeZone;
    protected final Optional<Long> earliestAllowedTimestamp;

    public RecordTimestampLowerBoundPolicy(State state, RowLevelPolicy.Type type) {
        super(state, type);
        this.timeZone = DateTimeZone.forID((String)state.getProp("qualitychecker.timezone", "America/Los_Angeles"));
        this.earliestAllowedTimestamp = this.getEarliestAllowedTimestamp();
    }

    private Optional<Long> getEarliestAllowedTimestamp() {
        if (!this.state.contains(RECORD_MAX_ALLOWED_TIME_AGO)) {
            return Optional.absent();
        }
        DateTime currentTime = new DateTime(this.timeZone);
        String maxTimeAgoStr = this.state.getProp(RECORD_MAX_ALLOWED_TIME_AGO);
        Period maxTimeAgo = PERIOD_FORMATTER.parsePeriod(maxTimeAgoStr);
        return Optional.of((Object)currentTime.minus((ReadablePeriod)maxTimeAgo).getMillis());
    }

    protected abstract TimeBasedWriterPartitioner<?> getPartitioner();

    public RowLevelPolicy.Result executePolicy(Object record) {
        long recordTimestamp = this.partitioner.getRecordTimestamp(record);
        if (this.earliestAllowedTimestamp.isPresent() && recordTimestamp < (Long)this.earliestAllowedTimestamp.get()) {
            return RowLevelPolicy.Result.FAILED;
        }
        return RowLevelPolicy.Result.PASSED;
    }
}

