/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.policies.count;

import org.apache.gobblin.configuration.State;
import org.apache.gobblin.qualitychecker.task.TaskLevelPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowCountRangePolicy
extends TaskLevelPolicy {
    private final long rowsRead;
    private final long rowsWritten;
    private final double range;
    private static final Logger LOG = LoggerFactory.getLogger(RowCountRangePolicy.class);

    public RowCountRangePolicy(State state, TaskLevelPolicy.Type type) {
        super(state, type);
        this.rowsRead = state.getPropAsLong("qualitychecker.rows.expected");
        this.rowsWritten = state.getPropAsLong("qualitychecker.rows.written");
        this.range = state.getPropAsDouble("qualitychecker.row.count.range");
    }

    public TaskLevelPolicy.Result executePolicy() {
        double computedRange = Math.abs((double)(this.rowsWritten - this.rowsRead) / (double)this.rowsRead);
        if (computedRange <= this.range) {
            return TaskLevelPolicy.Result.PASSED;
        }
        LOG.error(String.format("RowCountRangePolicy check failed. Rows read %s, Rows written %s, computed range %s, expected range %s ", this.rowsRead, this.rowsWritten, computedRange, this.range));
        return TaskLevelPolicy.Result.FAILED;
    }
}

