/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.initializer;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.initializer.ConverterInitializer;
import org.apache.gobblin.converter.initializer.MultiConverterInitializer;
import org.apache.gobblin.converter.initializer.NoopConverterInitializer;
import org.apache.gobblin.source.workunit.WorkUnitStream;
import org.apache.gobblin.util.ForkOperatorUtils;

public class ConverterInitializerFactory {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().omitEmptyStrings();

    public static ConverterInitializer newInstance(State state, WorkUnitStream workUnits) {
        int branches = state.getPropAsInt("fork.branches", 1);
        if (branches == 1) {
            return ConverterInitializerFactory.newInstance(state, workUnits, branches, 0);
        }
        ArrayList cis = Lists.newArrayList();
        for (int branchId = 0; branchId < branches; ++branchId) {
            cis.add(ConverterInitializerFactory.newInstance(state, workUnits, branches, branchId));
        }
        return new MultiConverterInitializer(cis);
    }

    private static ConverterInitializer newInstance(State state, WorkUnitStream workUnits, int branches, int branchId) {
        Preconditions.checkNotNull((Object)state);
        String converterClassesParam = ForkOperatorUtils.getPropertyNameForBranch((String)"converter.classes", (int)branches, (int)branchId);
        List converterClasses = COMMA_SPLITTER.splitToList((CharSequence)state.getProp(converterClassesParam, ""));
        if (converterClasses.isEmpty()) {
            return NoopConverterInitializer.INSTANCE;
        }
        ArrayList cis = Lists.newArrayList();
        for (String converterClass : converterClasses) {
            Converter converter;
            try {
                converter = (Converter)Class.forName(converterClass).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            cis.add(converter.getInitializer(state, workUnits, branches, branchId));
        }
        return new MultiConverterInitializer(cis);
    }
}

