/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.avro;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.EmptyIterable;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.util.AvroUtils;
import org.apache.gobblin.util.ForkOperatorUtils;

public class AvroFieldRetrieverConverter
extends Converter<Schema, Schema, GenericRecord, Object> {
    private String fieldLocation;

    public Converter<Schema, Schema, GenericRecord, Object> init(WorkUnitState workUnit) {
        String fieldPathKey = ForkOperatorUtils.getPropertyNameForBranch((WorkUnitState)workUnit, (String)"converter.avro.extractor.field.path");
        Preconditions.checkArgument((boolean)workUnit.contains(fieldPathKey), (Object)("The converter " + ((Object)((Object)this)).getClass().getName() + " cannot be used without setting the property " + "converter.avro.extractor.field.path"));
        this.fieldLocation = workUnit.getProp(fieldPathKey);
        return this;
    }

    public Schema convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        Optional schema = AvroUtils.getFieldSchema((Schema)inputSchema, (String)this.fieldLocation);
        return (Schema)schema.orNull();
    }

    public Iterable<Object> convertRecord(Schema outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        Optional field = AvroUtils.getFieldValue((GenericRecord)inputRecord, (String)this.fieldLocation);
        return field.isPresent() ? new SingleRecordIterable(field.get()) : new EmptyIterable();
    }
}

