/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;

public class StringSchemaInjector<SI, DI>
extends Converter<SI, String, DI, DI> {
    public static final String SCHEMA_KEY = "gobblin.converter.schemaInjector.schema";
    private String schema;

    public Converter<SI, String, DI, DI> init(WorkUnitState workUnit) {
        super.init(workUnit);
        Preconditions.checkArgument((boolean)workUnit.contains(SCHEMA_KEY));
        this.schema = workUnit.getProp(SCHEMA_KEY);
        return this;
    }

    public String convertSchema(SI inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return this.schema;
    }

    public Iterable<DI> convertRecord(String outputSchema, DI inputRecord, WorkUnitState workUnit) throws DataConversionException {
        return Lists.newArrayList((Object[])new Object[]{inputRecord});
    }
}

