/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.ClusterVerifiers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyKey;
import org.apache.helix.controller.pipeline.Stage;
import org.apache.helix.controller.pipeline.StageContext;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateCalcStage;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateComputationStage;
import org.apache.helix.controller.stages.ResourceComputationStage;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.tools.ClusterVerifiers.ZkHelixClusterVerifier;
import org.apache.log4j.Logger;

public class BestPossibleExternalViewVerifier
extends ZkHelixClusterVerifier {
    private static Logger LOG = Logger.getLogger(BestPossibleExternalViewVerifier.class);
    private final Map<String, Map<String, String>> _errStates;
    private final Set<String> _resources;
    private final Set<String> _expectLiveInstances;

    public BestPossibleExternalViewVerifier(String zkAddr, String clusterName, Set<String> resources, Map<String, Map<String, String>> errStates, Set<String> expectLiveInstances) {
        super(zkAddr, clusterName);
        this._errStates = errStates;
        this._resources = resources;
        this._expectLiveInstances = expectLiveInstances;
    }

    public BestPossibleExternalViewVerifier(ZkClient zkClient, String clusterName, Set<String> resources, Map<String, Map<String, String>> errStates, Set<String> expectLiveInstances) {
        super(zkClient, clusterName);
        this._errStates = errStates;
        this._resources = resources;
        this._expectLiveInstances = expectLiveInstances;
    }

    @Override
    public boolean verify(long timeout) {
        return this.verifyByZkCallback(timeout);
    }

    @Override
    public boolean verifyByZkCallback(long timeout) {
        ArrayList<ZkHelixClusterVerifier.ClusterVerifyTrigger> triggers = new ArrayList<ZkHelixClusterVerifier.ClusterVerifyTrigger>();
        if (this._resources != null && !this._resources.isEmpty()) {
            for (String resource : this._resources) {
                triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.idealStates(resource), true, false, false));
                triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.externalView(resource), true, false, false));
            }
        } else {
            triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.idealStates(), false, true, true));
            triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.externalViews(), false, true, true));
        }
        return this.verifyByCallback(timeout, triggers);
    }

    @Override
    protected boolean verifyState() {
        try {
            Set<String> actualLiveNodes;
            PropertyKey.Builder keyBuilder = this._accessor.keyBuilder();
            ClusterDataCache cache = new ClusterDataCache();
            cache.refresh(this._accessor);
            Map<String, IdealState> idealStates = cache.getIdealStates();
            if (idealStates == null) {
                idealStates = Collections.emptyMap();
            }
            Iterator<Map.Entry<String, IdealState>> it = idealStates.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, IdealState> pair = it.next();
                if (!pair.getValue().getStateModelDefRef().equals("Task")) continue;
                it.remove();
            }
            if (this._expectLiveInstances != null && !this._expectLiveInstances.isEmpty() && !this._expectLiveInstances.equals(actualLiveNodes = cache.getLiveInstances().keySet())) {
                return false;
            }
            Map<String, Object> extViews = this._accessor.getChildValuesMap(keyBuilder.externalViews());
            if (extViews == null) {
                extViews = Collections.emptyMap();
            }
            if (this._resources != null && !this._resources.isEmpty()) {
                idealStates.keySet().retainAll(this._resources);
                extViews.keySet().retainAll(this._resources);
            }
            for (String resource : extViews.keySet()) {
                if (idealStates.containsKey(resource)) continue;
                idealStates.put(resource, new IdealState(resource));
            }
            BestPossibleStateOutput bestPossOutput = this.calcBestPossState(cache);
            Map<String, Map<Partition, Map<String, String>>> bestPossStateMap = bestPossOutput.getStateMap();
            if (this._errStates != null) {
                for (String resourceName : this._errStates.keySet()) {
                    Map<String, String> partErrStates = this._errStates.get(resourceName);
                    for (String partitionName : partErrStates.keySet()) {
                        String instanceName = partErrStates.get(partitionName);
                        if (!bestPossStateMap.containsKey(resourceName)) {
                            bestPossStateMap.put(resourceName, new HashMap());
                        }
                        Partition partition = new Partition(partitionName);
                        if (!bestPossStateMap.get(resourceName).containsKey(partition)) {
                            bestPossStateMap.get(resourceName).put(partition, new HashMap());
                        }
                        bestPossStateMap.get(resourceName).get(partition).put(instanceName, HelixDefinedState.ERROR.toString());
                    }
                }
            }
            for (String resourceName : idealStates.keySet()) {
                ExternalView extView = (ExternalView)extViews.get(resourceName);
                IdealState is = idealStates.get(resourceName);
                if (extView == null) {
                    if (is.isExternalViewDisabled()) continue;
                    LOG.debug((Object)("externalView for " + resourceName + " is not available"));
                    return false;
                }
                Map<Partition, Map<String, String>> bpStateMap = bestPossOutput.getResourceMap(resourceName);
                StateModelDefinition stateModelDef = cache.getStateModelDef(is.getStateModelDefRef());
                if (stateModelDef == null) {
                    throw new HelixException("State model definition " + is.getStateModelDefRef() + " for resource not found!" + is.getResourceName());
                }
                boolean result = this.verifyExternalView(is, extView, bpStateMap, stateModelDef);
                if (result) continue;
                LOG.debug((Object)("verifyExternalView fails! ExternalView: " + extView + " BestPossibleState: " + bpStateMap));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)"exception in verification", (Throwable)e);
            return false;
        }
    }

    private boolean verifyExternalView(IdealState idealState, ExternalView externalView, Map<Partition, Map<String, String>> bestPossibleState, StateModelDefinition stateModelDef) {
        HashSet<String> ignoreStaes = new HashSet<String>(Arrays.asList(stateModelDef.getInitialState(), HelixDefinedState.DROPPED.toString()));
        Map<String, Map<String, String>> bestPossibleStateMap = this.convertBestPossibleState(bestPossibleState);
        this.removeEntryWithIgnoredStates(bestPossibleStateMap.entrySet().iterator(), ignoreStaes);
        Map<String, Map<String, String>> externalViewMap = externalView.getRecord().getMapFields();
        this.removeEntryWithIgnoredStates(externalViewMap.entrySet().iterator(), ignoreStaes);
        return externalViewMap.equals(bestPossibleStateMap);
    }

    private void removeEntryWithIgnoredStates(Iterator<Map.Entry<String, Map<String, String>>> partitionInstanceStateMapIter, Set<String> ignoredStates) {
        while (partitionInstanceStateMapIter.hasNext()) {
            Map.Entry<String, Map<String, String>> entry = partitionInstanceStateMapIter.next();
            Map<String, String> instanceStateMap = entry.getValue();
            if (instanceStateMap.isEmpty()) {
                partitionInstanceStateMapIter.remove();
                continue;
            }
            Iterator<Map.Entry<String, String>> insIter = instanceStateMap.entrySet().iterator();
            while (insIter.hasNext()) {
                String state = insIter.next().getValue();
                if (!ignoredStates.contains(state)) continue;
                insIter.remove();
            }
        }
    }

    private Map<String, Map<String, String>> convertBestPossibleState(Map<Partition, Map<String, String>> bestPossibleState) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (Partition partition : bestPossibleState.keySet()) {
            result.put(partition.getPartitionName(), bestPossibleState.get(partition));
        }
        return result;
    }

    private BestPossibleStateOutput calcBestPossState(ClusterDataCache cache) throws Exception {
        ClusterEvent event = new ClusterEvent("sampleEvent");
        event.addAttribute("ClusterDataCache", cache);
        this.runStage(event, new ResourceComputationStage());
        this.runStage(event, new CurrentStateComputationStage());
        this.runStage(event, new BestPossibleStateCalcStage());
        BestPossibleStateOutput output = (BestPossibleStateOutput)event.getAttribute(AttributeName.BEST_POSSIBLE_STATE.name());
        return output;
    }

    private void runStage(ClusterEvent event, Stage stage) throws Exception {
        StageContext context = new StageContext();
        stage.init(context);
        stage.preProcess();
        stage.process(event);
        stage.postProcess();
    }

    public String toString() {
        String verifierName = this.getClass().getSimpleName();
        return verifierName + "(" + this._clusterName + "@" + (Object)((Object)this._zkClient) + "@resources[" + (this._resources != null ? Arrays.toString(this._resources.toArray()) : "") + "])";
    }

    public static class Builder {
        private String _clusterName;
        private Map<String, Map<String, String>> _errStates;
        private Set<String> _resources;
        private Set<String> _expectLiveInstances;
        private String _zkAddr;
        private ZkClient _zkClient;

        public Builder(String clusterName) {
            this._clusterName = clusterName;
        }

        public BestPossibleExternalViewVerifier build() {
            if (this._clusterName == null || this._zkAddr == null && this._zkClient == null) {
                throw new IllegalArgumentException("Cluster name or zookeeper info is missing!");
            }
            if (this._zkClient != null) {
                return new BestPossibleExternalViewVerifier(this._zkClient, this._clusterName, this._resources, this._errStates, this._expectLiveInstances);
            }
            return new BestPossibleExternalViewVerifier(this._zkAddr, this._clusterName, this._resources, this._errStates, this._expectLiveInstances);
        }

        public String getClusterName() {
            return this._clusterName;
        }

        public Map<String, Map<String, String>> getErrStates() {
            return this._errStates;
        }

        public Builder setErrStates(Map<String, Map<String, String>> errStates) {
            this._errStates = errStates;
            return this;
        }

        public Set<String> getResources() {
            return this._resources;
        }

        public Builder setResources(Set<String> resources) {
            this._resources = resources;
            return this;
        }

        public Set<String> getExpectLiveInstances() {
            return this._expectLiveInstances;
        }

        public Builder setExpectLiveInstances(Set<String> expectLiveInstances) {
            this._expectLiveInstances = expectLiveInstances;
            return this;
        }

        public String getZkAddr() {
            return this._zkAddr;
        }

        public Builder setZkAddr(String zkAddr) {
            this._zkAddr = zkAddr;
            return this;
        }

        public ZkClient getZkClient() {
            return this._zkClient;
        }

        public Builder setZkClient(ZkClient zkClient) {
            this._zkClient = zkClient;
            return this;
        }
    }
}

