/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import org.apache.helix.monitoring.mbeans.WorkflowMonitorMBean;
import org.apache.helix.task.TaskState;

public class WorkflowMonitor
implements WorkflowMonitorMBean {
    private static final String WORKFLOW_KEY = "Workflow";
    private String _clusterName;
    private String _workflowType;
    private long _successfulWorkflowCount;
    private long _failedWorkflowCount;
    private long _existingWorkflowGauge;
    private long _queuedWorkflowGauge;
    private long _runningWorkflowGauge;

    public WorkflowMonitor(String clusterName, String workflowType) {
        this._clusterName = clusterName;
        this._workflowType = workflowType;
        this._successfulWorkflowCount = 0L;
        this._failedWorkflowCount = 0L;
        this._existingWorkflowGauge = 0L;
        this._queuedWorkflowGauge = 0L;
        this._runningWorkflowGauge = 0L;
    }

    @Override
    public long getSuccessfulWorkflowCount() {
        return this._successfulWorkflowCount;
    }

    @Override
    public long getFailedWorkflowCount() {
        return this._failedWorkflowCount;
    }

    @Override
    public long getExistingWorkflowGauge() {
        return this._existingWorkflowGauge;
    }

    @Override
    public long getQueuedWorkflowGauge() {
        return this._queuedWorkflowGauge;
    }

    @Override
    public long getRunningWorkflowGauge() {
        return this._runningWorkflowGauge;
    }

    @Override
    public String getSensorName() {
        return String.format("%s.%s.%s", this._clusterName, WORKFLOW_KEY, this._workflowType);
    }

    public String getWorkflowType() {
        return this._workflowType;
    }

    public void updateWorkflowCounters(TaskState to) {
        if (to.equals((Object)TaskState.FAILED)) {
            ++this._failedWorkflowCount;
        } else if (to.equals((Object)TaskState.COMPLETED)) {
            ++this._successfulWorkflowCount;
        }
    }

    public void resetGauges() {
        this._existingWorkflowGauge = 0L;
        this._runningWorkflowGauge = 0L;
        this._queuedWorkflowGauge = 0L;
    }

    public void updateWorkflowGauges(TaskState current) {
        if (current == null || current.equals((Object)TaskState.NOT_STARTED)) {
            ++this._queuedWorkflowGauge;
        } else if (current.equals((Object)TaskState.IN_PROGRESS)) {
            ++this._runningWorkflowGauge;
        }
        ++this._existingWorkflowGauge;
    }
}

